/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

public class BindingPWM {
    private SimpleWeightMatrix matrix;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public void setWeightMatrix(SimpleWeightMatrix matrix) {
        this.matrix = matrix;
    }

    public String getName() {
        return this.name;
    }

    public SimpleWeightMatrix getWeightMatrix() {
        return this.matrix;
    }

    public void read(File matrixFile, FiniteAlphabet alpha) {
        try {
            int i;
            BufferedReader br = new BufferedReader(new FileReader(matrixFile));
            String line = br.readLine();
            String[] splitLine = line.split("\\s+");
            this.name = splitLine[0];
            HashMap<String, double[]> alphaWeightHashMap = new HashMap<String, double[]>();
            while ((line = br.readLine()) != null) {
                splitLine = line.split("\\s+");
                String aa = splitLine[0];
                double[] weights = new double[splitLine.length - 1];
                for (i = 1; i < splitLine.length; ++i) {
                    weights[i - 1] = Double.parseDouble(splitLine[i]);
                }
                alphaWeightHashMap.put(aa, weights);
            }
            int numPositions = splitLine.length - 1;
            Distribution[] dists = new Distribution[numPositions];
            for (i = 0; i < numPositions; ++i) {
                Distribution dist = DistributionFactory.DEFAULT.createDistribution((Alphabet)alpha);
                Iterator it = alpha.iterator();
                SymbolTokenization st = null;
                try {
                    st = ProteinTools.getAlphabet().getTokenization("token");
                }
                catch (BioException e) {
                    System.err.println("Unable to get symboltokenization. This should never happen.");
                }
                while (it.hasNext()) {
                    Symbol symbol = (Symbol)it.next();
                    String symbolName = st.tokenizeSymbol(symbol);
                    double[] weights = (double[])alphaWeightHashMap.get(symbolName);
                    if (weights == null) {
                        dist.setWeight(symbol, 0.0);
                        continue;
                    }
                    dist.setWeight(symbol, weights[i]);
                }
                dists[i] = dist;
            }
            this.matrix = new SimpleWeightMatrix(dists);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

