/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.model;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceLogo;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.Profile;

public class LogoGenerator {
    public static BufferedImage generateImage(ProteinProfile proteinProfile, LolaParameterSet params, String fileSuffix) {
        ProteinSequenceLogo logo = params.getLogoTrimPercentage() == 0.0 ? new ProteinSequenceLogo(proteinProfile, params.getLogoHeight(), params.getDrawAxisLabels()) : new ProteinSequenceLogo(proteinProfile, params.getLogoTrimPercentage(), params.getLogoHeight(), params.getDrawAxisLabels());
        logo.sequenceLogoSetStartIndex(params.getLogoStartIndex());
        BufferedImage image = logo.drawSequenceLogo(params.getAminoAcidGrouping().getProteinLogoStyle());
        return image;
    }

    public static void writeLogo(Profile profile, LolaParameterSet params, String fileSuffix) {
        String suffix = fileSuffix;
        if (suffix == null) {
            suffix = "";
        }
        String fileExtension = null;
        String formatName = null;
        String imageFormat = params.getLogoImageFileFormat();
        if (imageFormat == null) {
            imageFormat = "PDF";
        }
        if (imageFormat.equalsIgnoreCase("Bitmap")) {
            formatName = "bmp";
            fileExtension = "bmp";
        } else if (imageFormat.equalsIgnoreCase("JPEG")) {
            formatName = "jpg";
            fileExtension = "jpg";
        } else if (imageFormat.equalsIgnoreCase("PNG")) {
            formatName = "png";
            fileExtension = "png";
        } else if (imageFormat.equalsIgnoreCase("PDF")) {
            formatName = "pdf";
            fileExtension = "pdf";
        } else {
            System.out.println("Unexpected image file format: " + imageFormat);
            throw new IllegalStateException();
        }
        String outFileName = params.getOutputPath() + File.separator + profile.getName() + suffix + "." + fileExtension;
        BufferedImage image = profile.getImage();
        if (image == null) {
            System.out.println("Unexpected null image in LogoGenerator.writeLogo.");
            throw new IllegalStateException();
        }
        try {
            if (imageFormat.equalsIgnoreCase("PDF")) {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outFileName)));
                LogoGenerator.saveLogoAsPDF(profile.getProteinProfile(), params, out);
            } else {
                ImageIO.write((RenderedImage)image, formatName, new File(outFileName));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeImageAsPDF(OutputStream out, BufferedImage logoImage, int width, int height, FontMapper mapper) throws IOException {
        Rectangle pagesize = new Rectangle((float)width, (float)height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            com.lowagie.text.Image itextImage = com.lowagie.text.Image.getInstance((Image)logoImage, null);
            itextImage.setAbsolutePosition(0.0f, 0.0f);
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            tp.addImage(itextImage);
            cb.addTemplate(tp, 38.0f, writer.getVerticalPosition(true) - (float)height);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public static void saveToTextFile(File file, String output) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(output);
        bw.close();
    }

    public static void saveImageAsPDF(File file, BufferedImage logoImage, int width, int height, FontMapper mapper) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        LogoGenerator.writeImageAsPDF(out, logoImage, width, height, mapper);
        ((OutputStream)out).close();
    }

    public static void saveLogoAsPDF(ProteinProfile proteinProfile, LolaParameterSet params, OutputStream out) {
        ProteinSequenceLogo logo = params.getLogoTrimPercentage() == 0.0 ? new ProteinSequenceLogo(proteinProfile, params.getLogoHeight(), params.getDrawAxisLabels()) : new ProteinSequenceLogo(proteinProfile, params.getLogoTrimPercentage(), params.getLogoHeight(), params.getDrawAxisLabels());
        logo.sequenceLogoSetStartIndex(params.getLogoStartIndex());
        try {
            logo.saveAsPDF(out, params.getAminoAcidGrouping().getProteinLogoStyle());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void drawLogoTreeDrawAsPDF(OutputStream out, LogoTreeDraw ltd, int width, int height) throws IOException {
        Rectangle pagesize = new Rectangle((float)width, (float)height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D graphics = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            ltd.draw(graphics);
            graphics.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public static void saveGraphicAsPDF(File file, LogoTreeDraw ltd, int width, int height) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        LogoGenerator.drawLogoTreeDrawAsPDF(out, ltd, width, height);
        ((OutputStream)out).close();
    }
}

