/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.ui.IconSupport;
import cytoscape.visual.ui.PopupFontChooser;
import cytoscape.visual.ui.PopupIconChooser;
import cytoscape.visual.ui.PopupLabelPositionChooser;
import cytoscape.visual.ui.PopupStringChooser;
import giny.model.GraphObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

abstract class VizMapBypass {
    protected Frame parent = Cytoscape.getDesktop();
    protected VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
    protected CyAttributes attrs = null;
    protected GraphObject graphObj = null;

    VizMapBypass() {
    }

    protected abstract String[] getBypassNames();

    protected void addResetAllMenuItem(JMenu menu) {
        JMenuItem jmi = new JMenuItem(new AbstractAction("Reset All"){

            public void actionPerformed(ActionEvent e) {
                String[] names = VizMapBypass.this.getBypassNames();
                String id = VizMapBypass.this.graphObj.getIdentifier();
                for (String attrName : names) {
                    if (!VizMapBypass.this.attrs.hasAttribute(id, attrName)) continue;
                    VizMapBypass.this.attrs.deleteAttribute(id, attrName);
                }
                VizMapBypass.this.vmm.getNetworkView().redrawGraph(false, true);
            }
        });
        menu.add(jmi);
    }

    protected void addResetMenuItem(JMenu menu, String title, final String attrName) {
        JMenuItem jmi = new JMenuItem(new AbstractAction("[ Reset " + title + " ]"){

            public void actionPerformed(ActionEvent e) {
                String id = VizMapBypass.this.graphObj.getIdentifier();
                if (VizMapBypass.this.attrs.hasAttribute(id, attrName)) {
                    VizMapBypass.this.attrs.deleteAttribute(id, attrName);
                }
                VizMapBypass.this.vmm.getNetworkView().redrawGraph(false, true);
            }
        });
        menu.add(jmi);
    }

    protected void addMenuItem(JMenu menu, final String title, final String attrName, final Class c) {
        JCheckBoxMenuItem jmi = new JCheckBoxMenuItem(new AbstractAction(title){

            public void actionPerformed(ActionEvent e) {
                Object obj = this.getBypassValue(title, c);
                if (obj == null) {
                    return;
                }
                String val = ObjectToString.getStringValue(obj);
                VizMapBypass.this.attrs.setAttribute(VizMapBypass.this.graphObj.getIdentifier(), attrName, val);
                VizMapBypass.this.vmm.getNetworkView().redrawGraph(false, true);
            }

            private Object getBypassValue(String title2, Class c2) {
                if (c2 == Color.class) {
                    return CyColorChooser.showDialog(VizMapBypass.this.parent, "Choose " + title2, null);
                }
                if (c2 == Double.class) {
                    return PopupStringChooser.showDialog(VizMapBypass.this.parent, "Choose " + title2, "Input a double:", null, (byte)4);
                }
                if (c2 == Integer.class) {
                    return PopupStringChooser.showDialog(VizMapBypass.this.parent, "Choose " + title2, "Input an integer:", null, (byte)6);
                }
                if (c2 == Byte.class) {
                    IconSupport is = new IconSupport(null, 5);
                    PopupIconChooser chooser = new PopupIconChooser("Choose " + title2, null, is.getIcons(), null, VizMapBypass.this.parent);
                    return chooser.showDialog();
                }
                if (c2 == Arrow.class) {
                    IconSupport is = new IconSupport(null, 2);
                    PopupIconChooser chooser = new PopupIconChooser("Choose " + title2, null, is.getIcons(), null, VizMapBypass.this.parent);
                    return chooser.showDialog();
                }
                if (c2 == LineType.class) {
                    IconSupport is = new IconSupport(null, 1);
                    PopupIconChooser chooser = new PopupIconChooser("Choose " + title2, null, is.getIcons(), null, VizMapBypass.this.parent);
                    return chooser.showDialog();
                }
                if (c2 == String.class) {
                    return PopupStringChooser.showDialog(VizMapBypass.this.parent, "Choose " + title2, "Input a String:", null, (byte)3);
                }
                if (c2 == LabelPosition.class) {
                    return PopupLabelPositionChooser.showDialog(VizMapBypass.this.parent, null);
                }
                if (c2 == Font.class) {
                    return PopupFontChooser.showDialog(VizMapBypass.this.parent, null);
                }
                return null;
            }
        });
        menu.add(jmi);
        String attrString = this.attrs.getStringAttribute(this.graphObj.getIdentifier(), attrName);
        if (attrString == null || attrString.length() == 0) {
            jmi.setSelected(false);
        } else {
            jmi.setSelected(true);
            this.addResetMenuItem(menu, title, attrName);
        }
    }
}

