/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.freehep.application.PrintDialog;
import org.freehep.application.PrintPreview;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

public class PrintHelper
implements Printable {
    private static final String rootName;
    public static final int ORIENTATION_BEST_FIT = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    private Component target;
    private Font headerFooterFont = new Font("SansSerif", 0, 10);
    private PrintRequestAttributeSet atts = new HashPrintRequestAttributeSet();
    private PrinterJob pj;
    private String footer;
    private String header;
    private Studio app;
    private boolean drawBorder;
    private boolean scaleUp;
    private boolean showFooter;
    private boolean showHeader;
    private int orientation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freehep.application.PrintHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rootName = String.valueOf(clazz.getName()) + ".";
    }

    public PrintHelper(Component target, Studio app) {
        this.target = target;
        this.app = app;
        Properties user = app.getUserProperties();
        this.drawBorder = PropertyUtilities.getBoolean(user, String.valueOf(rootName) + "drawBorder", false);
        this.scaleUp = PropertyUtilities.getBoolean(user, String.valueOf(rootName) + "scaleUp", false);
        this.showHeader = PropertyUtilities.getBoolean(user, String.valueOf(rootName) + "showHeader", true);
        this.showFooter = PropertyUtilities.getBoolean(user, String.valueOf(rootName) + "showFooter", false);
        this.footer = PropertyUtilities.getString(user, String.valueOf(rootName) + "footer", null);
        this.header = PropertyUtilities.getString(user, String.valueOf(rootName) + "header", "JAS3&b&d");
        this.orientation = PropertyUtilities.getInteger(user, String.valueOf(rootName) + "orientation", 0);
        this.pj = PrinterJob.getPrinterJob();
        this.pj.setPrintable(this);
        String defaultPrinter = user.getProperty(String.valueOf(rootName) + "defaultPrinter");
        PrintService ps = this.pj.getPrintService();
        if (ps == null) {
            throw new RuntimeException("No Print Service Found");
        }
        if (defaultPrinter != null && !ps.getName().equals(defaultPrinter)) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().equals(defaultPrinter)) {
                    try {
                        this.pj.setPrintService(services[i]);
                        ps = services[i];
                        break;
                    }
                    catch (PrinterException x) {
                        x.printStackTrace();
                    }
                }
                ++i;
            }
        }
        this.atts.add(new JobName(user.getProperty(String.valueOf(rootName) + "printJobName", "JAS3 Plots"), null));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.print.attribute.standard.Media");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Media media = (Media)ps.getDefaultAttributeValue((Class<? extends Attribute>)clazz);
        float x = PropertyUtilities.getFloat(user, String.valueOf(rootName) + "printArea.top", 0.0f);
        float y = PropertyUtilities.getFloat(user, String.valueOf(rootName) + "printArea.left", 0.0f);
        float w = PropertyUtilities.getFloat(user, String.valueOf(rootName) + "printArea.right", 0.0f);
        float h = PropertyUtilities.getFloat(user, String.valueOf(rootName) + "printArea.bottom", 0.0f);
        if (x > 0.0f) {
            this.atts.add(new MediaPrintableArea(x, y, w, h, 25400));
        }
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setScaleUp(boolean scaleUp) {
        this.scaleUp = scaleUp;
    }

    public boolean getScaleUp() {
        return this.scaleUp;
    }

    public void setShowFooter(boolean showFooter) {
        this.showFooter = showFooter;
    }

    public boolean isShowFooter() {
        return this.showFooter;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        boolean useLandscape;
        if (pi >= 1) {
            return 1;
        }
        Graphics2D orig = (Graphics2D)g;
        Graphics2D g2 = (Graphics2D)orig.create();
        g2.translate(pf.getImageableX(), pf.getImageableY());
        Dimension size = this.target.getSize();
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double portraiteRatio = Math.min(pageWidth / (double)size.width, pageHeight / (double)size.height);
        double landscapeRatio = Math.min(pageWidth / (double)size.height, pageHeight / (double)size.width);
        if (!this.scaleUp) {
            portraiteRatio = Math.min(portraiteRatio, 1.0);
            landscapeRatio = Math.min(landscapeRatio, 1.0);
        }
        boolean bl = this.orientation == 0 ? landscapeRatio > portraiteRatio : (useLandscape = this.orientation == 2);
        if (useLandscape) {
            g2.rotate(1.5707963267948966);
            g2.translate(0.0, -pageWidth);
            g2.scale(landscapeRatio, landscapeRatio);
        } else {
            g2.scale(portraiteRatio, portraiteRatio);
        }
        this.target.print(g2);
        g2.dispose();
        if (this.drawBorder) {
            orig.setColor(Color.BLACK);
            orig.draw(new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pageWidth, pageHeight));
        }
        return 0;
    }

    void pageDialog(Component parent) {
        this.pj.pageDialog(this.atts);
    }

    public void print() throws PrinterException {
        this.pj.print(this.atts);
        this.commitChanges();
    }

    void printDialog(Component parent) {
        this.pj.printDialog(this.atts);
    }

    public void printPreview(Component parent) throws PrinterException {
        Media media;
        PrintPreview pp = new PrintPreview(){

            protected boolean onPrint(Pageable document) throws PrinterException {
                PrintHelper.this.print();
                return true;
            }

            protected void onError(PrinterException x) {
                Studio.error(this, "Print Error", x);
            }
        };
        PageFormat pf = this.pj.defaultPage();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.print.attribute.standard.Media");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((media = (Media)this.atts.get(clazz)) instanceof MediaSizeName) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("javax.print.attribute.standard.MediaPrintableArea");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MediaPrintableArea ma = (MediaPrintableArea)this.atts.get(clazz2);
            Paper paper = pf.getPaper();
            paper.setSize(72.0f * ms.getX(25400), 72.0f * ms.getY(25400));
            paper.setImageableArea(72.0f * ma.getX(25400), 72.0f * ma.getY(25400), 72.0f * ma.getWidth(25400), 72.0f * ma.getHeight(25400));
            pf.setPaper(paper);
        }
        pp.setPrintable(this, pf);
        this.app.showDialog(pp.createDialog(parent), "printPreview");
    }

    public void showOptionsDialog(Component parent) {
        PrintDialog pd = new PrintDialog(this.app, this);
        int rc = pd.showDialog(parent);
        if (rc == 0) {
            this.commitChanges();
        }
    }

    private void commitChanges() {
        Media media;
        Class<?> clazz;
        MediaPrintableArea mp;
        Class<?> clazz2;
        JobName jobName;
        Properties user = this.app.getUserProperties();
        PropertyUtilities.setBoolean(user, String.valueOf(rootName) + "drawBorder", this.drawBorder);
        PropertyUtilities.setBoolean(user, String.valueOf(rootName) + "scaleUp", this.scaleUp);
        PropertyUtilities.setBoolean(user, String.valueOf(rootName) + "showHeader", this.showHeader);
        PropertyUtilities.setBoolean(user, String.valueOf(rootName) + "showFooter", this.showFooter);
        PropertyUtilities.setString(user, String.valueOf(rootName) + "footer", this.footer);
        PropertyUtilities.setString(user, String.valueOf(rootName) + "header", this.header);
        PropertyUtilities.setInteger(user, String.valueOf(rootName) + "orientation", this.orientation);
        PropertyUtilities.setString(user, String.valueOf(rootName) + "defaultPrinter", this.pj.getPrintService().getName());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("javax.print.attribute.standard.JobName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jobName = (JobName)this.atts.get(clazz3)) != null) {
            PropertyUtilities.setString(user, String.valueOf(rootName) + "printJobName", jobName.getName());
        }
        if ((clazz2 = class$2) == null) {
            try {
                clazz2 = class$2 = Class.forName("javax.print.attribute.standard.MediaPrintableArea");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mp = (MediaPrintableArea)this.atts.get(clazz2)) != null) {
            PropertyUtilities.setFloat(user, String.valueOf(rootName) + "printArea.x", mp.getX(25400));
            PropertyUtilities.setFloat(user, String.valueOf(rootName) + "printArea.y", mp.getY(25400));
            PropertyUtilities.setFloat(user, String.valueOf(rootName) + "printArea.w", mp.getWidth(25400));
            PropertyUtilities.setFloat(user, String.valueOf(rootName) + "printArea.h", mp.getHeight(25400));
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("javax.print.attribute.standard.Media");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((media = (Media)this.atts.get(clazz)) instanceof MediaSizeName) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            PropertyUtilities.setString(user, String.valueOf(rootName) + "mediaSize", media.getName());
        }
    }
}

