/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.ProfileSet;

public class SaveLogoTreeToFile
implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public SaveLogoTreeToFile(ProfileSet profileSet, LolaParameterSet params) {
        this.profileSet = profileSet;
        this.paramSet = params;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LogoTree tree = this.profileSet.getLogoTree();
        if (tree != null) {
            String outputPath = this.paramSet.getOutputPath() + File.separator + this.paramSet.getTreeFilename();
            if (tree != null) {
                try {
                    if (this.paramSet.getTreeImageFormat().equals("GTR")) {
                        LogoGenerator.saveToTextFile(new File(outputPath), tree.getGTRFormat());
                    } else if (this.paramSet.getTreeImageFormat().equals("PDF")) {
                        LogoGenerator.saveGraphicAsPDF(new File(outputPath), tree.getLogoTreeDraw(), tree.getImage().getWidth(), tree.getImage().getHeight());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                tree.setIsSaved(true);
            }
        }
    }
}

