/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.swf.SWFActionSet;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFHeader;
import org.freehep.graphicsio.swf.SWFTagSet;
import org.freehep.graphicsio.swf.ShowFrame;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.ActionSet;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;
import org.freehep.util.io.TaggedOutputStream;

public class SWFOutputStream
extends TaggedOutputStream
implements SWFConstants {
    private Dimension size;
    private float frameRate;
    private int frameCount = 0;
    private boolean compress;
    private static final AffineTransform identityMatrix = new AffineTransform();

    public SWFOutputStream(OutputStream os, Dimension size, float frameRate, boolean compress) throws IOException {
        this(os, 6, size, frameRate, compress);
    }

    public SWFOutputStream(OutputStream os, int version, Dimension size, float frameRate, boolean compress) throws IOException {
        this(os, new SWFTagSet(version), new SWFActionSet(version), size, frameRate, compress);
    }

    public SWFOutputStream(OutputStream os, SWFTagSet tagSet, SWFActionSet actionSet, Dimension size, float frameRate, boolean compress) throws IOException {
        super(os, (TagSet)tagSet, (ActionSet)actionSet, true);
        this.size = size;
        this.frameRate = frameRate;
        this.compress = compress;
        this.pushBuffer();
    }

    public void close() throws IOException {
        long len = this.popBuffer() + SWFHeader.size();
        SWFHeader header = new SWFHeader(this.getVersion(), len, this.size, this.frameRate, this.frameCount, this.compress);
        this.writeHeader(header);
        this.append();
        super.close();
    }

    public void writeTag(ShowFrame tag) throws IOException {
        ++this.frameCount;
        super.writeTag((Tag)tag);
    }

    public void writeFixed(double d) throws IOException {
        this.byteAlign();
        long whole = (long)d;
        long frac = (long)((d - (double)whole) * 65536.0);
        long fixed = (whole & 0xFFFFL) << 16 | frac & 0xFFFFL;
        this.writeUnsignedInt(fixed);
    }

    public void writeRect(Rectangle2D rect) throws IOException {
        int nbits = 0;
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(rect.getMinX() * 20.0)), (boolean)true));
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(rect.getMaxX() * 20.0)), (boolean)true));
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(rect.getMinY() * 20.0)), (boolean)true));
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(rect.getMaxY() * 20.0)), (boolean)true));
        this.writeRect(rect, nbits);
    }

    public void writeRect(Rectangle2D rect, int nbits) throws IOException {
        this.byteAlign();
        this.writeUBits(nbits, 5);
        this.writeSBits((int)(rect.getMinX() * 20.0), nbits);
        this.writeSBits((int)(rect.getMaxX() * 20.0), nbits);
        this.writeSBits((int)(rect.getMinY() * 20.0), nbits);
        this.writeSBits((int)(rect.getMaxY() * 20.0), nbits);
    }

    public void writeColor(Color color, boolean alpha) throws IOException {
        this.byteAlign();
        this.writeUnsignedByte(color.getRed());
        this.writeUnsignedByte(color.getGreen());
        this.writeUnsignedByte(color.getBlue());
        if (alpha) {
            this.writeUnsignedByte(color.getAlpha());
        }
    }

    public void writeMatrix(AffineTransform matrix) throws IOException {
        int nbits;
        if (matrix == null) {
            matrix = identityMatrix;
        }
        this.byteAlign();
        if (matrix.getScaleX() != 1.0 || matrix.getScaleY() != 1.0) {
            this.writeBitFlag(true);
            nbits = 0;
            nbits = Math.max(nbits, SWFOutputStream.minBits((float)((float)matrix.getScaleX())));
            nbits = Math.max(nbits, SWFOutputStream.minBits((float)((float)matrix.getScaleY())));
            this.writeUBits(nbits, 5);
            this.writeFBits((float)matrix.getScaleX(), nbits);
            this.writeFBits((float)matrix.getScaleY(), nbits);
        } else {
            this.writeBitFlag(false);
        }
        if (matrix.getShearX() != 0.0 || matrix.getShearY() != 0.0) {
            this.writeBitFlag(true);
            nbits = 0;
            nbits = Math.max(nbits, SWFOutputStream.minBits((float)((float)matrix.getShearY())));
            nbits = Math.max(nbits, SWFOutputStream.minBits((float)((float)matrix.getShearX())));
            this.writeUBits(nbits, 5);
            this.writeFBits((float)matrix.getShearY(), nbits);
            this.writeFBits((float)matrix.getShearX(), nbits);
        } else {
            this.writeBitFlag(false);
        }
        nbits = 0;
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(matrix.getTranslateX() * 20.0)), (boolean)true));
        nbits = Math.max(nbits, SWFOutputStream.minBits((long)((int)(matrix.getTranslateY() * 20.0)), (boolean)true));
        this.writeUBits(nbits, 5);
        this.writeSBits((int)(matrix.getTranslateX() * 20.0), nbits);
        this.writeSBits((int)(matrix.getTranslateY() * 20.0), nbits);
    }

    public void writeString(String s) throws IOException {
        if (this.getVersion() >= 6) {
            this.writeUTF(s);
            this.writeByte(0);
        } else {
            this.writeAsciiZString(s);
        }
    }

    public void writeLanguageCode(int code) throws IOException {
        this.writeUnsignedByte(code);
    }

    protected void writeTagHeader(TagHeader tagHeader) throws IOException {
        this.byteAlign();
        int th = tagHeader.getTag() << 6;
        if (tagHeader.getLength() >= 63L) {
            this.writeUnsignedShort(th |= 0x3F);
            this.writeUnsignedInt(tagHeader.getLength());
        } else {
            th = (int)((long)th | tagHeader.getLength());
            this.writeUnsignedShort(th);
        }
    }

    protected void writeActionHeader(ActionHeader header) throws IOException {
        int actionCode = header.getAction();
        long length = header.getLength();
        this.writeUnsignedByte(actionCode);
        if ((actionCode & 0x80) > 0) {
            this.writeUnsignedShort((int)length);
        }
    }

    public void writeHeader(SWFHeader header) throws IOException {
        header.write(this);
    }

    public int getVersion() {
        return ((SWFTagSet)this.tagSet).getVersion();
    }
}

