/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.readers.OBOTags;
import cytoscape.data.ontology.readers.OntologyReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOFlatFileReader
implements OntologyReader {
    public static final String ONTOLOGY_DAG_ROOT = "Ontology DAGs";
    public static final String OBO_PREFIX = "ontology";
    private static final String DEF_ORIGIN = "def_origin";
    protected static final String TERM_TAG = "[Term]";
    private static final String DEF_ONTOLOGY_NAME = "Ontology DAG";
    private ArrayList<String[]> interactionList;
    private CyNetwork ontologyDAG;
    private CyAttributes termAttributes;
    private CyAttributes networkAttributes;
    private Map<String, String> header;
    private String name;
    private InputStream inputStream;

    public OBOFlatFileReader(String fileName, String name) throws FileNotFoundException {
        this(new FileInputStream(fileName), name);
    }

    public OBOFlatFileReader(URL dataSource, String name) throws IOException {
        this(dataSource.openStream(), name);
    }

    public OBOFlatFileReader(InputStream oboStream, String name) {
        this.inputStream = oboStream;
        this.name = name;
        this.initialize();
    }

    private void initialize() {
        this.interactionList = new ArrayList();
        this.header = new HashMap<String, String>();
        this.networkAttributes = Cytoscape.getNetworkAttributes();
        this.termAttributes = Cytoscape.getNodeAttributes();
        if (this.name == null) {
            this.name = DEF_ONTOLOGY_NAME;
        }
        this.networkAttributes.setAttribute(this.name, "Is_Ontology", true);
        this.networkAttributes.setUserVisible("Is_Ontology", false);
        this.networkAttributes.setUserEditable("Is_Ontology", false);
        String rootID = Cytoscape.getOntologyRootID();
        if (rootID == null) {
            Set networkSet = Cytoscape.getNetworkSet();
            for (CyNetwork net : networkSet) {
                if (!net.getTitle().equals(ONTOLOGY_DAG_ROOT)) continue;
                rootID = net.getIdentifier();
            }
            if (rootID == null) {
                rootID = Cytoscape.createNetwork(ONTOLOGY_DAG_ROOT, false).getIdentifier();
                Cytoscape.setOntologyRootID(rootID);
            }
        }
        this.ontologyDAG = Cytoscape.createNetwork(this.name, Cytoscape.getNetwork(rootID), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readOntology() throws IOException {
        String line;
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(this.inputStream));
        while ((line = bufRd.readLine()) != null) {
            if (line.startsWith(TERM_TAG)) {
                this.readEntry(bufRd);
                break;
            }
            if (line.length() == 0) continue;
            int colonInx = line.indexOf(58);
            String key = line.substring(0, colonInx).trim();
            String val = line.substring(colonInx + 1).trim();
            this.header.put(key, val);
        }
        while ((line = bufRd.readLine()) != null) {
            if (!line.startsWith(TERM_TAG)) continue;
            this.readEntry(bufRd);
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.inputStream = null;
        }
        this.buildDag();
        this.setAttributeDescriptions();
    }

    private void readEntry(BufferedReader rd) throws IOException {
        String id = "";
        String line = null;
        while ((line = rd.readLine().trim()).length() != 0) {
            int colonInx = line.indexOf(58);
            String key = line.substring(0, colonInx).trim();
            String val = line.substring(colonInx + 1).trim();
            CyNode source = null;
            if (key.equals(OBOTags.ID.toString())) {
                id = val;
                continue;
            }
            if (key.equals(OBOTags.DEF.toString())) {
                String[] definitionParts = val.split("\"");
                this.termAttributes.setAttribute(id, "ontology." + key, definitionParts[1]);
                List<String> originList = this.getReferences(val.substring(definitionParts[1].length() + 2));
                if (originList == null) continue;
                this.termAttributes.setListAttribute(id, "ontology.def_origin", originList);
                continue;
            }
            if (key.equals(OBOTags.EXACT_SYNONYM.toString()) || key.equals(OBOTags.RELATED_SYNONYM.toString()) || key.equals(OBOTags.BROAD_SYNONYM.toString()) || key.equals(OBOTags.NARROW_SYNONYM.toString()) || key.equals(OBOTags.SYNONYM.toString())) {
                String[] synonymParts = val.split("\"");
                HashMap<String, String> synoMap = this.termAttributes.getMapAttribute(id, "ontology." + OBOTags.SYNONYM.toString());
                if (synoMap == null) {
                    synoMap = new HashMap<String, String>();
                }
                if (key.equals(OBOTags.SYNONYM.toString())) {
                    synoMap.put(synonymParts[1], synonymParts[2].trim());
                } else {
                    synoMap.put(synonymParts[1], key);
                }
                this.termAttributes.setMapAttribute(id, "ontology." + OBOTags.SYNONYM.toString(), synoMap);
                continue;
            }
            if (key.equals(OBOTags.RELATIONSHIP.toString())) {
                if (source == null) {
                    source = Cytoscape.getCyNode(id, true);
                    this.ontologyDAG.addNode(source);
                }
                String[] entry = val.split(" ");
                String[] itr = new String[]{id, entry[1], entry[0]};
                this.interactionList.add(itr);
                continue;
            }
            if (key.equals(OBOTags.IS_A.toString())) {
                int colonidx;
                if (source == null) {
                    source = Cytoscape.getCyNode(id, true);
                    this.ontologyDAG.addNode(source);
                }
                String targetId = (colonidx = val.indexOf(33)) == -1 ? val.trim() : val.substring(0, colonidx).trim();
                CyNode target = Cytoscape.getCyNode(targetId, true);
                this.ontologyDAG.addNode(target);
                String[] itr = new String[]{id, targetId, "is_a"};
                this.interactionList.add(itr);
                continue;
            }
            if (key.equals(OBOTags.IS_OBSOLETE.toString())) {
                this.termAttributes.setAttribute(id, "ontology." + key, Boolean.parseBoolean(val));
                continue;
            }
            if (key.equals(OBOTags.XREF.toString()) || key.equals(OBOTags.XREF_ANALOG.toString())) {
                ArrayList<String> xrefAnalog = this.termAttributes.getListAttribute(id, "ontology." + OBOTags.XREF.toString());
                if (xrefAnalog == null) {
                    xrefAnalog = new ArrayList<String>();
                }
                if (val != null) {
                    xrefAnalog.add(val.toString());
                }
                this.termAttributes.setListAttribute(id, "ontology." + OBOTags.XREF.toString(), xrefAnalog);
                continue;
            }
            this.termAttributes.setAttribute(id, "ontology." + key, val);
        }
    }

    @Override
    public Map<String, String> getHeader() {
        return this.header;
    }

    private void buildDag() {
        for (String[] interaction : this.interactionList) {
            CyEdge isA = Cytoscape.getCyEdge(Cytoscape.getCyNode(interaction[0], true), Cytoscape.getCyNode(interaction[1], true), "interaction", interaction[2], true, true);
            this.ontologyDAG.addEdge(isA);
        }
    }

    public CyAttributes getTermsAttributes() {
        return this.termAttributes;
    }

    @Override
    public CyNetwork getDag() {
        return this.ontologyDAG;
    }

    private List<String> getReferences(String list) {
        String trimed = list.trim();
        if ((trimed = trimed.substring(trimed.indexOf("[") + 1, trimed.indexOf("]"))).length() == 0) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (String entry : trimed.split(",")) {
            entries.add(entry.trim());
        }
        return entries;
    }

    private void setAttributeDescriptions() {
        String[] attrNames = this.termAttributes.getAttributeNames();
        TreeSet<String> attrNameSet = new TreeSet<String>();
        for (String string : attrNames) {
            attrNameSet.add(string);
        }
        for (OBOTags oBOTags : OBOTags.values()) {
            if (!attrNameSet.contains(OBOTags.getPrefix() + "." + oBOTags.toString())) continue;
            this.termAttributes.setAttributeDescription(OBOTags.getPrefix() + "." + oBOTags.toString(), oBOTags.getDescription());
        }
    }
}

