/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.Serializable;

public class LineType
implements Serializable {
    public static final LineType LINE_1 = new LineType("LINE_1");
    public static final LineType LINE_2 = new LineType("LINE_2");
    public static final LineType LINE_3 = new LineType("LINE_3");
    public static final LineType LINE_4 = new LineType("LINE_4");
    public static final LineType LINE_5 = new LineType("LINE_5");
    public static final LineType LINE_6 = new LineType("LINE_6");
    public static final LineType LINE_7 = new LineType("LINE_7");
    public static final LineType DASHED_1 = new LineType("DASHED_1");
    public static final LineType DASHED_2 = new LineType("DASHED_2");
    public static final LineType DASHED_3 = new LineType("DASHED_3");
    public static final LineType DASHED_4 = new LineType("DASHED_4");
    public static final LineType DASHED_5 = new LineType("DASHED_5");
    String name;
    Stroke stroke;

    public LineType(String name) {
        this.name = name;
        this.stroke = name.equals("LINE_2") ? new BasicStroke(2.0f) : (name.equals("LINE_3") ? new BasicStroke(3.0f) : (name.equals("LINE_4") ? new BasicStroke(4.0f) : (name.equals("LINE_5") ? new BasicStroke(5.0f) : (name.equals("LINE_6") ? new BasicStroke(6.0f) : (name.equals("LINE_7") ? new BasicStroke(7.0f) : (name.equals("DASHED_1") ? this.makeDashedStroke(1.0f) : (name.equals("DASHED_2") ? this.makeDashedStroke(2.0f) : (name.equals("DASHED_3") ? this.makeDashedStroke(3.0f) : (name.equals("DASHED_4") ? this.makeDashedStroke(4.0f) : (name.equals("DASHED_5") ? this.makeDashedStroke(5.0f) : new BasicStroke()))))))))));
    }

    public static LineType parseLineTypeText(String text) {
        String lttext = text.trim();
        if ((lttext = lttext.replaceAll("_", "")).equalsIgnoreCase("dashed1")) {
            return DASHED_1;
        }
        if (lttext.equalsIgnoreCase("dashed2")) {
            return DASHED_2;
        }
        if (lttext.equalsIgnoreCase("dashed3")) {
            return DASHED_3;
        }
        if (lttext.equalsIgnoreCase("dashed4")) {
            return DASHED_4;
        }
        if (lttext.equalsIgnoreCase("dashed5")) {
            return DASHED_5;
        }
        if (lttext.equalsIgnoreCase("line1")) {
            return LINE_1;
        }
        if (lttext.equalsIgnoreCase("line2")) {
            return LINE_2;
        }
        if (lttext.equalsIgnoreCase("line3")) {
            return LINE_3;
        }
        if (lttext.equalsIgnoreCase("line4")) {
            return LINE_4;
        }
        if (lttext.equalsIgnoreCase("line5")) {
            return LINE_5;
        }
        if (lttext.equalsIgnoreCase("line6")) {
            return LINE_6;
        }
        if (lttext.equalsIgnoreCase("line7")) {
            return LINE_7;
        }
        return LINE_1;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof LineType) {
            LineType other = (LineType)o;
            return this.name.equals(other.getName());
        }
        return false;
    }

    private Stroke makeDashedStroke(float width) {
        float[] dash = new float[]{5.0f, 3.0f};
        return new BasicStroke(width, 0, 0, 1.0f, dash, 0.0f);
    }
}

