/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.AllTests;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationXmlReader;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AnnotationAndOntologyFullTest
extends TestCase {
    public AnnotationAndOntologyFullTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testHaloKegg() throws Exception {
        AllTests.standardOut("testHaloKegg");
        String filename = "testData/haloMetabolicPathway.xml";
        AnnotationXmlReader reader = new AnnotationXmlReader(new File(filename));
        Annotation keggHalo = reader.getAnnotation();
        AllTests.standardOut(keggHalo.toString());
        String orf = "VNG0606G";
        int[] terms = keggHalo.getClassifications(orf);
        Ontology ontology = keggHalo.getOntology();
        AnnotationAndOntologyFullTest.assertTrue((terms.length == 3 ? 1 : 0) != 0);
        for (int i = 0; i < terms.length; ++i) {
            int[][] paths = ontology.getAllHierarchyPaths(terms[i]);
            AllTests.standardOut(orf + ": " + terms[i] + " paths: " + paths.length + ":  ");
            for (int p = 0; p < paths.length; ++p) {
                AnnotationAndOntologyFullTest.assertTrue((paths[p].length == 3 ? 1 : 0) != 0);
                for (int q = 0; q < paths[p].length; ++q) {
                    AllTests.standardOut(paths[p][q] + "  ");
                }
            }
            AllTests.standardOut("\n");
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(AnnotationAndOntologyFullTest.class));
    }
}

