/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.dialogs.preferences.PreferenceTableModel;
import cytoscape.dialogs.preferences.PreferenceValueDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PreferencesDialog
extends JDialog
implements PropertyChangeListener {
    int[] selection = null;
    JScrollPane propsTablePane = new JScrollPane();
    JTable prefsTable = new JTable();
    JPanel propBtnPane = new JPanel(new FlowLayout());
    JPanel okButtonPane = new JPanel(new FlowLayout());
    JPanel vizmapPane = new JPanel(new FlowLayout());
    JPanel cyPropsPane = new JPanel(new FlowLayout());
    JCheckBox saveVizmapBtn = new JCheckBox("Make Current Visual Styles Default", false);
    JCheckBox saveCyPropsBtn = new JCheckBox("Make Current Cytoscape Properties Default", false);
    JTextArea vizmapText = new JTextArea("Only check this option if you want the current visual styles to be defaults in ALL future cytoscape sessions.  Your current visual styles are automatically saved in your Cytoscape session file and won't be lost.");
    JTextArea cyPropsText = new JTextArea("Only check this option if you want the current Cytoscape properties to be defaults in ALL future cytoscape sessions.  Your current Cytoscape properties are automatically saved in your Cytoscape session file and won't be lost.");
    JButton addPropBtn = new JButton("Add");
    JButton deletePropBtn = new JButton("Delete");
    JButton modifyPropBtn = new JButton("Modify");
    JButton okButton = new JButton("OK");
    JButton cancelButton = new JButton("Cancel");
    public PreferenceTableModel prefsTM = null;
    private ListSelectionModel lsm = null;
    private ListSelectionModel lsmA = null;
    private boolean saveCyPropsAsDefault = false;
    private boolean saveVizmapAsDefault = false;

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("PREFERENCE_MODIFIED")) {
            System.out.println("Cytoscape Prop. has changed: ");
            System.out.println(" - Old value is " + e.getOldValue());
            System.out.println(" - New value is " + e.getNewValue());
            String propName = null;
            if (CytoscapeInit.getProperties().getProperty("defaultSpeciesName") == e.getOldValue() || CytoscapeInit.getProperties().getProperty("defaultSpeciesName") == e.getNewValue()) {
                propName = "defaultSpeciesName";
            } else if (CytoscapeInit.getProperties().getProperty("defaultWebBrowser") == e.getOldValue() || CytoscapeInit.getProperties().getProperty("defaultWebBrowser") == e.getNewValue()) {
                propName = "defaultWebBrowser";
            }
            if (propName != null) {
                CytoscapeInit.getProperties().setProperty(propName, (String)e.getNewValue());
                this.prefsTM.setProperty(propName, (String)e.getNewValue());
                System.out.println(propName + " updated to " + CytoscapeInit.getProperties().getProperty(propName));
            }
        }
    }

    public void setParameter(TableModel tm, String preferenceName, String preferenceValue) {
        if (tm == this.prefsTM) {
            Cytoscape.firePropertyChange("PREFERENCE_MODIFIED", this.prefsTM.getProperty(preferenceName), preferenceValue);
            this.prefsTM.setProperty(preferenceName, preferenceValue);
        }
        this.refresh();
        this.modifyPropBtn.setEnabled(false);
        this.deletePropBtn.setEnabled(false);
    }

    public void refresh() {
        this.prefsTable.setModel(this.prefsTM);
        this.prefsTable.clearSelection();
        this.prefsTable.revalidate();
        this.prefsTable.repaint();
    }

    private void initButtonPane() {
        this.propBtnPane.add(this.addPropBtn);
        this.propBtnPane.add(this.modifyPropBtn);
        this.propBtnPane.add(this.deletePropBtn);
        this.okButtonPane.add(this.okButton);
        this.okButtonPane.add(this.cancelButton);
        this.modifyPropBtn.setEnabled(false);
        this.deletePropBtn.setEnabled(false);
        this.addPropBtn.addActionListener(new AddPropertyListener(this));
        this.modifyPropBtn.addActionListener(new ModifyPropertyListener(this));
        this.deletePropBtn.addActionListener(new DeletePropertyListener(this));
        this.okButton.addActionListener(new OkButtonListener(this));
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.saveVizmapBtn.addItemListener(new CheckBoxListener());
        this.saveCyPropsBtn.addItemListener(new CheckBoxListener());
    }

    public PreferenceTableModel getPTM() {
        return this.prefsTM;
    }

    private void initTable() {
        this.prefsTM = new PreferenceTableModel();
        this.prefsTable.setAutoCreateColumnsFromModel(false);
        this.prefsTable.setRowSelectionAllowed(true);
        this.lsm = this.prefsTable.getSelectionModel();
        this.lsm.setSelectionMode(0);
        this.lsm.addListSelectionListener(new TableListener(this, this.lsm));
        this.prefsTable.setModel(this.prefsTM);
        for (int i = 0; i < PreferenceTableModel.columnHeader.length; ++i) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(PreferenceTableModel.alignment[i]);
            TableColumn Column = new TableColumn(i, PreferenceTableModel.columnWidth[i], renderer, null);
            Column.setIdentifier(PreferenceTableModel.columnHeader[i]);
            this.prefsTable.addColumn(Column);
        }
    }

    public PreferencesDialog(Frame owner) {
        super(owner);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.initButtonPane();
        this.initTable();
        try {
            this.prefPopupInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Cytoscape Preferences Editor");
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void prefPopupInit() throws Exception {
        Box outerBox = Box.createVerticalBox();
        outerBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 8, 10));
        Box propsTableBox = Box.createVerticalBox();
        this.propsTablePane.setBorder(BorderFactory.createEmptyBorder(2, 9, 4, 9));
        this.propsTablePane.getViewport().add((Component)this.prefsTable, null);
        this.prefsTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        propsTableBox.add(this.propsTablePane);
        propsTableBox.add(Box.createVerticalStrut(5));
        propsTableBox.add(this.propBtnPane);
        propsTableBox.setBorder(BorderFactory.createTitledBorder("Properties"));
        outerBox.add(propsTableBox);
        outerBox.add(Box.createVerticalStrut(10));
        outerBox.add(Box.createVerticalStrut(10));
        JTextArea textArea = new JTextArea("NOTE: Changes to these properties are used in the current session ONLY unless otherwise specified below.");
        textArea.setBackground(outerBox.getBackground());
        textArea.setEditable(false);
        textArea.setDragEnabled(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        outerBox.add(textArea);
        outerBox.add(Box.createVerticalStrut(10));
        Box vizmapBox = Box.createVerticalBox();
        vizmapBox.setBorder(BorderFactory.createTitledBorder("Default Visual Styles"));
        this.vizmapText.setBackground(outerBox.getBackground());
        this.vizmapText.setEditable(false);
        this.vizmapText.setDragEnabled(false);
        this.vizmapText.setLineWrap(true);
        this.vizmapText.setWrapStyleWord(true);
        vizmapBox.add(this.vizmapText);
        vizmapBox.add(Box.createVerticalStrut(5));
        this.vizmapPane.add(this.saveVizmapBtn);
        vizmapBox.add(this.vizmapPane);
        outerBox.add(vizmapBox);
        outerBox.add(Box.createVerticalStrut(10));
        Box cyPropsBox = Box.createVerticalBox();
        cyPropsBox.setBorder(BorderFactory.createTitledBorder("Default Cytoscape Properties"));
        this.cyPropsText.setBackground(outerBox.getBackground());
        this.cyPropsText.setEditable(false);
        this.cyPropsText.setDragEnabled(false);
        this.cyPropsText.setLineWrap(true);
        this.cyPropsText.setWrapStyleWord(true);
        cyPropsBox.add(this.cyPropsText);
        cyPropsBox.add(Box.createVerticalStrut(5));
        this.cyPropsPane.add(this.saveCyPropsBtn);
        cyPropsBox.add(this.cyPropsPane);
        outerBox.add(cyPropsBox);
        outerBox.add(Box.createVerticalStrut(8));
        outerBox.add(this.okButtonPane);
        this.getContentPane().add((Component)outerBox, "Center");
    }

    class TableListener
    implements ListSelectionListener {
        private ListSelectionModel model = null;
        private PreferencesDialog motherRef = null;

        public TableListener(PreferencesDialog mother, ListSelectionModel lsm) {
            this.motherRef = mother;
            this.model = lsm;
        }

        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                StringBuffer buf = new StringBuffer();
                PreferencesDialog.this.selection = this.getSelectedIndices(this.model.getMinSelectionIndex(), this.model.getMaxSelectionIndex());
                if (PreferencesDialog.this.selection.length != 0) {
                    PreferencesDialog.this.modifyPropBtn.setEnabled(true);
                    PreferencesDialog.this.deletePropBtn.setEnabled(true);
                }
            }
        }

        protected int[] getSelectedIndices(int start, int stop) {
            if (start == -1 || stop == -1) {
                return new int[0];
            }
            int[] guesses = new int[stop - start + 1];
            int index = 0;
            for (int i = start; i <= stop; ++i) {
                if (!this.model.isSelectedIndex(i)) continue;
                guesses[index++] = i;
            }
            int[] realthing = new int[index];
            System.arraycopy(guesses, 0, realthing, 0, index);
            return realthing;
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PreferencesDialog callerRef = null;

        public CancelButtonListener(PreferencesDialog caller) {
            this.callerRef = caller;
        }

        public void actionPerformed(ActionEvent e) {
            Properties oldProps = CytoscapeInit.getProperties();
            this.callerRef.prefsTM.restore(oldProps);
            this.callerRef.setVisible(false);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (e.getStateChange() == 1) {
                if (source == PreferencesDialog.this.saveVizmapBtn) {
                    PreferencesDialog.this.saveVizmapAsDefault = true;
                }
                if (source == PreferencesDialog.this.saveCyPropsBtn) {
                    PreferencesDialog.this.saveCyPropsAsDefault = true;
                }
            }
        }
    }

    class OkButtonListener
    implements ActionListener {
        PreferencesDialog callerRef = null;

        public OkButtonListener(PreferencesDialog caller) {
            this.callerRef = caller;
        }

        public void actionPerformed(ActionEvent e) {
            Properties newProps = new Properties();
            this.callerRef.prefsTM.save(newProps);
            CytoscapeInit.getProperties().clear();
            CytoscapeInit.getProperties().putAll((Map<?, ?>)newProps);
            this.callerRef.setVisible(false);
            if (PreferencesDialog.this.saveVizmapAsDefault) {
                Cytoscape.firePropertyChange(Cytoscape.SAVE_VIZMAP_PROPS, null, null);
                PreferencesDialog.this.saveVizmapAsDefault = false;
                PreferencesDialog.this.saveVizmapBtn.setSelected(false);
            }
            if (PreferencesDialog.this.saveCyPropsAsDefault) {
                try {
                    File file = CytoscapeInit.getConfigFile("cytoscape.props");
                    FileOutputStream output = new FileOutputStream(file);
                    CytoscapeInit.getProperties().store(output, "Cytoscape Property File");
                    System.out.println("wrote Cytoscape properties file to: " + file.getAbsolutePath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.out.println("Could not write cytoscape.props file!");
                }
                PreferencesDialog.this.saveCyPropsAsDefault = false;
                PreferencesDialog.this.saveCyPropsBtn.setSelected(false);
            }
            Cytoscape.firePropertyChange("PREFERENCES_UPDATED", null, null);
        }
    }

    class DeletePropertyListener
    implements ActionListener {
        PreferencesDialog callerRef = null;

        public DeletePropertyListener(PreferencesDialog caller) {
            this.callerRef = caller;
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < PreferencesDialog.this.selection.length; ++i) {
                String name = new String((String)PreferencesDialog.this.prefsTM.getValueAt(PreferencesDialog.this.selection[i], 0));
                PreferencesDialog.this.prefsTM.deleteProperty(name);
            }
            PreferencesDialog.this.refresh();
        }
    }

    class ModifyPropertyListener
    implements ActionListener {
        PreferencesDialog callerRef = null;

        public ModifyPropertyListener(PreferencesDialog caller) {
            this.callerRef = caller;
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < PreferencesDialog.this.selection.length; ++i) {
                String name = new String((String)PreferencesDialog.this.prefsTM.getValueAt(PreferencesDialog.this.selection[i], 0));
                String value = new String((String)PreferencesDialog.this.prefsTM.getValueAt(PreferencesDialog.this.selection[i], 1));
                PreferenceValueDialog pd = new PreferenceValueDialog(PreferencesDialog.this, name, value, this.callerRef, PreferencesDialog.this.prefsTM, "Modify value...", false);
            }
        }
    }

    class AddPropertyListener
    implements ActionListener {
        PreferencesDialog callerRef = null;

        public AddPropertyListener(PreferencesDialog caller) {
            this.callerRef = caller;
        }

        public void actionPerformed(ActionEvent e) {
            String value;
            String key = JOptionPane.showInputDialog(PreferencesDialog.this.addPropBtn, "Enter property name:", "Add Property", 3);
            if (key != null && (value = JOptionPane.showInputDialog(PreferencesDialog.this.addPropBtn, "Enter value for property " + key + ":", "Add Property Value", 3)) != null) {
                String[] vals = new String[]{key, value};
                PreferencesDialog.this.prefsTM.addProperty(vals);
                PreferencesDialog.this.refresh();
            }
        }
    }
}

