/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.Category;
import cytoscape.bookmarks.DataSource;
import cytoscape.data.readers.BookmarkReader;
import cytoscape.util.BookmarksUtil;
import java.util.List;
import junit.framework.TestCase;

public class BookmarksUtilTest
extends TestCase {
    private Bookmarks bk;

    protected void setUp() throws Exception {
        super.setUp();
        BookmarkReader reader = new BookmarkReader();
        reader.readBookmarks();
        this.bk = reader.getBookmarks();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetCategory() {
        List<Category> rootCat = this.bk.getCategory();
        BookmarksUtilTest.assertNotNull(rootCat);
        System.out.println("#### Number of bookmarks in the root category = " + rootCat.size());
        Category cat1 = BookmarksUtil.getCategory("annotation", rootCat);
        BookmarksUtilTest.assertNotNull((Object)cat1);
        BookmarksUtilTest.assertEquals((String)"annotation", (String)cat1.getName());
        System.out.println("===============================================");
        Category cat2 = BookmarksUtil.getCategory("network", rootCat);
        BookmarksUtilTest.assertNotNull((Object)cat2);
        BookmarksUtilTest.assertEquals((String)"network", (String)cat2.getName());
        System.out.println("===============================================");
        Category cat4 = BookmarksUtil.getCategory("aaa", rootCat);
        BookmarksUtilTest.assertNull((Object)cat4);
    }

    public void testGetDataSourceList() {
        List<Category> rootCat = this.bk.getCategory();
        List<DataSource> sources = BookmarksUtil.getDataSourceList("ontology", this.bk.getCategory());
        BookmarksUtilTest.assertNotNull(sources);
        BookmarksUtilTest.assertEquals((int)10, (int)sources.size());
        List<DataSource> sources2 = BookmarksUtil.getDataSourceList("annotation", this.bk.getCategory());
        BookmarksUtilTest.assertNotNull(sources2);
        BookmarksUtilTest.assertEquals((int)33, (int)sources2.size());
        List<DataSource> sources3 = BookmarksUtil.getDataSourceList("network", this.bk.getCategory());
        BookmarksUtilTest.assertNotNull(sources3);
        BookmarksUtilTest.assertEquals((int)6, (int)sources3.size());
    }
}

