/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.Label;
import giny.view.NodeView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GraphSetUtils {
    protected static final int UNION = 0;
    protected static final int INTERSECTION = 1;
    protected static final int DIFFERENCE = 2;

    public static CyNetwork createUnionGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 0, copyView, title);
    }

    public static CyNetwork createIntersectionGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 1, copyView, title);
    }

    public static CyNetwork createDifferenceGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 2, copyView, title);
    }

    protected static CyNetwork performNetworkOperation(List networkList, int operation, boolean copyView, String title) {
        if (networkList.size() == 0) {
            throw new IllegalArgumentException("Must have at least one network in the list");
        }
        int[] new_nodes = null;
        int[] new_edges = null;
        switch (operation) {
            case 0: {
                new_nodes = GraphSetUtils.unionizeNodes(networkList);
                new_edges = GraphSetUtils.unionizeEdges(networkList);
                break;
            }
            case 1: {
                new_nodes = GraphSetUtils.intersectNodes(networkList);
                new_edges = GraphSetUtils.intersectEdges(networkList);
                System.err.println("number of intersecting nodes is " + new_nodes.length);
                break;
            }
            case 2: {
                new_edges = GraphSetUtils.differenceEdges(networkList);
                new_nodes = GraphSetUtils.differenceNodes(networkList, new_edges);
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified invalid graph set operation");
            }
        }
        CyNetwork newNetwork = Cytoscape.createNetwork(new_nodes, new_edges, title);
        if (copyView && Cytoscape.viewExists(newNetwork.getIdentifier())) {
            NodeView newView;
            Vector<NodeView> nodeViews = new Vector<NodeView>();
            block5: for (int idx = 0; idx < new_nodes.length; ++idx) {
                int current_node = new_nodes[idx];
                for (CyNetwork cyNetwork : networkList) {
                    if (!Cytoscape.viewExists(cyNetwork.getIdentifier())) continue;
                    CyNetworkView view = Cytoscape.getNetworkView(cyNetwork.getIdentifier());
                    nodeViews.add(view.getNodeView(current_node));
                    continue block5;
                }
            }
            Vector<EdgeView> edgeViews = new Vector<EdgeView>();
            block7: for (int idx = 0; idx < new_edges.length; ++idx) {
                int current_node = new_edges[idx];
                for (CyNetwork currentNetwork : networkList) {
                    if (!Cytoscape.viewExists(currentNetwork.getIdentifier())) continue;
                    CyNetworkView view = Cytoscape.getNetworkView(currentNetwork.getIdentifier());
                    edgeViews.add(view.getEdgeView(current_node));
                    continue block7;
                }
            }
            CyNetworkView newNetworkView = Cytoscape.getNetworkView(newNetwork.getIdentifier());
            for (NodeView nodeView : nodeViews) {
                if (nodeView == null) {
                    System.err.println("Unexpected null nodeview");
                    continue;
                }
                Node node = nodeView.getNode();
                newView = newNetworkView.getNodeView(node);
                newView.setBorder(nodeView.getBorder());
                newView.setBorderPaint(nodeView.getBorderPaint());
                newView.setBorderWidth(nodeView.getBorderWidth());
                newView.setHeight(nodeView.getHeight());
                newView.setSelectedPaint(nodeView.getSelectedPaint());
                newView.setShape(nodeView.getShape());
                newView.setTransparency(nodeView.getTransparency());
                newView.setUnselectedPaint(nodeView.getUnselectedPaint());
                newView.setWidth(nodeView.getWidth());
                newView.setXPosition(nodeView.getXPosition());
                newView.setYPosition(nodeView.getYPosition());
                Label oldLabel = nodeView.getLabel();
                Label newLabel = newView.getLabel();
                newLabel.setFont(oldLabel.getFont());
                newLabel.setGreekThreshold(oldLabel.getGreekThreshold());
                newLabel.setText(oldLabel.getText());
                newLabel.setTextPaint(oldLabel.getTextPaint());
            }
            for (EdgeView edgeView : edgeViews) {
                if (edgeView == null) {
                    System.err.println("Unexpected null edgeview");
                    continue;
                }
                Edge edge = edgeView.getEdge();
                newView = newNetworkView.getEdgeView(edge);
                newView.setLineType(edgeView.getLineType());
                newView.setSelectedPaint(edgeView.getSelectedPaint());
                newView.setSourceEdgeEndPaint(edgeView.getSourceEdgeEndPaint());
                newView.setSourceEdgeEndSelectedPaint(edgeView.getSourceEdgeEndSelectedPaint());
                newView.setStroke(edgeView.getStroke());
                newView.setStrokeWidth(edgeView.getStrokeWidth());
                newView.setTargetEdgeEndPaint(edgeView.getTargetEdgeEndPaint());
                newView.setTargetEdgeEndSelectedPaint(edgeView.getTargetEdgeEndSelectedPaint());
            }
        }
        return newNetwork;
    }

    protected static int[] differenceEdges(List networkList) {
        Vector<Edge> edges = new Vector<Edge>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator edgeIt = firstNetwork.edgesIterator();
        block0: while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsEdge(currentEdge)) continue block0;
            }
            edges.add(currentEdge);
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        for (Edge currentEdge : edges) {
            result[idx] = currentEdge.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] differenceNodes(List networkList, int[] edges) {
        HashSet<Node> nodes = new HashSet<Node>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator nodeIt = firstNetwork.nodesIterator();
        block0: while (nodeIt.hasNext()) {
            Node currentNode = (Node)nodeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsNode(currentNode)) continue block0;
            }
            nodes.add(currentNode);
        }
        for (int idx = 0; idx < edges.length; ++idx) {
            nodes.add(firstNetwork.getNode(firstNetwork.getEdgeSourceIndex(edges[idx])));
            nodes.add(firstNetwork.getNode(firstNetwork.getEdgeTargetIndex(edges[idx])));
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        for (Node currentNode : nodes) {
            result[idx] = currentNode.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] intersectNodes(List networkList) {
        Vector<Node> nodes = new Vector<Node>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator nodeIt = firstNetwork.nodesIterator();
        block0: while (nodeIt.hasNext()) {
            Node currentNode = (Node)nodeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (!currentNetwork.containsNode(currentNode)) continue block0;
            }
            nodes.add(currentNode);
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        for (Node currentNode : nodes) {
            result[idx] = currentNode.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] intersectEdges(List networkList) {
        Vector<Edge> edges = new Vector<Edge>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator edgeIt = firstNetwork.edgesIterator();
        block0: while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (!currentNetwork.containsEdge(currentEdge)) continue block0;
            }
            edges.add(currentEdge);
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        for (Edge currentEdge : edges) {
            result[idx] = currentEdge.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] unionizeNodes(List networkList) {
        Iterator nodeIt;
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (CyNetwork currentNetwork : networkList) {
            nodeIt = currentNetwork.nodesIterator();
            while (nodeIt.hasNext()) {
                nodes.add(new Integer(((Node)nodeIt.next()).getRootGraphIndex()));
            }
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        nodeIt = nodes.iterator();
        while (nodeIt.hasNext()) {
            result[idx] = (Integer)nodeIt.next();
            ++idx;
        }
        return result;
    }

    protected static int[] unionizeEdges(List networkList) {
        Iterator edgeIt;
        HashSet<Integer> edges = new HashSet<Integer>();
        for (CyNetwork currentNetwork : networkList) {
            edgeIt = currentNetwork.edgesIterator();
            while (edgeIt.hasNext()) {
                edges.add(new Integer(((Edge)edgeIt.next()).getRootGraphIndex()));
            }
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        edgeIt = edges.iterator();
        while (edgeIt.hasNext()) {
            result[idx] = (Integer)edgeIt.next();
            ++idx;
        }
        return result;
    }
}

