/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.OrderNDistributionFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDistributionReader
extends DefaultHandler {
    private Alphabet alpha = null;
    private Distribution dist = null;
    private DistributionFactory fact = null;
    private SymbolTokenization nameParser = null;
    private Symbol sym = null;
    private Alphabet conditioningAlpha = null;
    private AtomicSymbol conditioningSymbol = null;
    private SymbolTokenization conditioningTok = null;
    private Alphabet conditionedAlpha = null;
    private AtomicSymbol conditionedSymbol = null;
    private SymbolTokenization conditionedTok = null;

    private Distribution getDist() {
        return this.dist;
    }

    public Distribution parseXML(InputStream is) throws IOException, SAXException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setNamespaceAware(true);
        try {
            SAXParser parser = fact.newSAXParser();
            InputSource xml = null;
            xml = new InputSource(new InputStreamReader(is));
            parser.parse(xml, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot make SAXParser", ex);
        }
        return this.getDist();
    }

    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        if (localName.equals("Distribution") || localName.equals("OrderNDistribution")) {
            this.processDistElement(attributes);
        } else if (localName.equals("alphabet")) {
            this.processAlphabetElement(attributes);
        } else if (localName.equals("conditioning_symbol")) {
            this.processConditioningSymbol(attributes);
        } else if (localName.equals("weight")) {
            this.processWeightElement(attributes);
        }
    }

    private void processConditioningSymbol(Attributes attr) throws SAXException {
        String name = attr.getValue("name");
        try {
            this.conditioningSymbol = (AtomicSymbol)this.conditioningTok.parseToken(name);
        }
        catch (IllegalSymbolException ex) {
            throw new SAXException(ex);
        }
    }

    private void processWeightElement(Attributes attr) throws SAXException {
        double weight = 0.0;
        try {
            weight = Double.parseDouble(attr.getValue("prob"));
        }
        catch (NumberFormatException ex) {
            weight = 0.0;
        }
        if (!(this.dist instanceof OrderNDistribution)) {
            try {
                this.nameParser = this.dist.getAlphabet().getTokenization("name");
            }
            catch (BioException ex) {
                throw new SAXException("Couldn't get tokenization for " + this.dist.getAlphabet().getName(), ex);
            }
            try {
                this.sym = this.nameParser.parseToken(attr.getValue("sym"));
                this.dist.setWeight(this.sym, weight);
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException("Illegal symbol found", ex);
            }
            catch (ChangeVetoException ex) {
                throw new SAXException("Distribution has been locked, possible synchronization problem !?", ex);
            }
        }
        if (this.dist instanceof OrderNDistribution) {
            try {
                weight = Double.parseDouble(attr.getValue("prob"));
            }
            catch (NumberFormatException ex) {
                weight = 0.0;
            }
            String name = attr.getValue("sym");
            try {
                this.conditionedSymbol = (AtomicSymbol)this.conditionedTok.parseToken(name);
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException(ex);
            }
            ArrayList<AtomicSymbol> l = new ArrayList<AtomicSymbol>();
            l.add(this.conditioningSymbol);
            l.add(this.conditionedSymbol);
            try {
                this.sym = this.alpha.getSymbol(l);
                this.dist.setWeight(this.sym, weight);
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException("Illegal symbol found", ex);
            }
            catch (ChangeVetoException ex) {
                throw new SAXException("Distribution has been locked, possible synchronization problem !?", ex);
            }
        }
    }

    private void processAlphabetElement(Attributes attr) throws SAXException {
        String alphaName = attr.getValue("name");
        this.alpha = AlphabetManager.alphabetForName(alphaName);
        try {
            this.dist = this.fact.createDistribution(this.alpha);
            if (this.dist instanceof OrderNDistribution) {
                this.conditionedAlpha = ((OrderNDistribution)this.dist).getConditionedAlphabet();
                this.conditionedTok = this.conditionedAlpha.getTokenization("name");
                this.conditioningAlpha = ((OrderNDistribution)this.dist).getConditioningAlphabet();
                this.conditioningTok = this.conditioningAlpha.getTokenization("name");
            }
        }
        catch (IllegalAlphabetException ex) {
            throw new SAXException(ex);
        }
        catch (BioException ex) {
            throw new SAXException(ex);
        }
    }

    private void processDistElement(Attributes attr) throws SAXException {
        if (attr.getValue("type").equals("Distribution")) {
            this.fact = DistributionFactory.DEFAULT;
        } else if (attr.getValue("type").equals("OrderNDistribution")) {
            this.fact = OrderNDistributionFactory.DEFAULT;
        } else {
            throw new SAXException("Element must be a distribution");
        }
    }

    private boolean one_element(String s) {
        return s.indexOf(" ") <= 0;
    }
}

