/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class TextLogoPainter
implements LogoPainter {
    private static final Comparator COMP = new ResValComparator();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Font logoFont = new Font("Tahoma", 0, 12);

    public Font getLogoFont() {
        return this.logoFont;
    }

    public void setLogoFont(Font logoFont) {
        this.firePropertyChange("logoFont", this.logoFont, logoFont);
        this.logoFont = logoFont;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public void paintLogo(LogoContext ctxt) {
        Graphics2D g2 = ctxt.getGraphics();
        Distribution dist = ctxt.getDistribution();
        SymbolStyle style = ctxt.getStyle();
        SymbolTokenization toke = null;
        try {
            toke = dist.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
        Rectangle bounds = ctxt.getBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double base = bounds.getY() + bounds.getHeight();
        TreeSet<ResVal> info = new TreeSet<ResVal>(COMP);
        try {
            Iterator i = ((FiniteAlphabet)dist.getAlphabet()).iterator();
            while (i.hasNext()) {
                Symbol s = (Symbol)i.next();
                info.add(new ResVal(s, dist.getWeight(s) * height));
            }
        }
        catch (IllegalSymbolException ire) {
            throw new BioError("Symbol distsapeared from dist alphabet", ire);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        Iterator i = info.iterator();
        while (i.hasNext()) {
            ResVal rv = (ResVal)i.next();
            String s = null;
            try {
                s = toke.tokenizeSymbol(rv.getToken());
            }
            catch (IllegalSymbolException ex) {
                throw new BioRuntimeException(ex);
            }
            GlyphVector gv = this.logoFont.createGlyphVector(frc, s);
            Shape outline = gv.getOutline();
            Rectangle2D oBounds = outline.getBounds2D();
            AffineTransform at = new AffineTransform();
            at.setToTranslation(0.0, base - rv.getValue());
            at.scale(width / oBounds.getWidth(), rv.getValue() / oBounds.getHeight());
            at.translate(-oBounds.getMinX(), -oBounds.getMinY());
            outline = at.createTransformedShape(outline);
            try {
                g2.setPaint(style.fillPaint(rv.getToken()));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.black);
            }
            g2.fill(outline);
            try {
                g2.setPaint(style.outlinePaint(rv.getToken()));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.gray);
            }
            g2.draw(outline);
            base -= rv.getValue();
        }
    }

    private static class ResValComparator
    implements Comparator {
        private ResValComparator() {
        }

        public final int compare(Object o1, Object o2) {
            ResVal rv1 = (ResVal)o1;
            ResVal rv2 = (ResVal)o2;
            double diff = rv1.getValue() - rv2.getValue();
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return rv1.getToken().getName().compareTo(rv2.getToken().getName());
        }
    }

    private static class ResVal {
        private Symbol symbol;
        private double value;

        public final Symbol getToken() {
            return this.symbol;
        }

        public final double getValue() {
            return this.value;
        }

        public ResVal(Symbol sym, double val) {
            this.symbol = sym;
            this.value = val;
        }
    }
}

