/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.program.das.dasalignment.Alignment;
import org.biojava.bio.program.das.dasalignment.DASAlignmentXMLResponseParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DASAlignmentCall {
    String serverurl;

    public DASAlignmentCall() {
        this.serverurl = "";
    }

    public DASAlignmentCall(String url) {
        this.serverurl = url;
    }

    public void setServerurl(String s) {
        this.serverurl = s;
    }

    public String getServerurl() {
        return this.serverurl;
    }

    public Alignment[] getAlignments() throws IOException {
        URL dasUrl = null;
        try {
            dasUrl = new URL(this.serverurl);
        }
        catch (Exception e) {
            throw new IOException("error during creation of URL " + e.getMessage());
        }
        System.out.println("connecting to " + this.serverurl);
        InputStream inStream = this.connectDASServer(dasUrl);
        Alignment[] ali = null;
        try {
            ali = this.parseDASResponse(inStream);
        }
        catch (Exception e) {
            throw new IOException("error during creation of URL " + e.getMessage());
        }
        return ali;
    }

    public Alignment[] getAlignments(String query) throws IOException {
        String connstr = this.serverurl + query;
        URL dasUrl = null;
        try {
            dasUrl = new URL(connstr);
        }
        catch (Exception e) {
            throw new IOException("error during creation of URL " + e.getMessage());
        }
        System.out.println("connecting to " + connstr);
        InputStream inStream = this.connectDASServer(dasUrl);
        Alignment[] ali = null;
        try {
            ali = this.parseDASResponse(inStream);
        }
        catch (Exception e) {
            throw new IOException("error during creation of URL " + e.getMessage());
        }
        return ali;
    }

    private InputStream connectDASServer(URL url) throws IOException {
        InputStream inStream = null;
        System.out.println("opening connection to " + url);
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        huc.setRequestProperty("Accept-Encoding", "gzip");
        System.out.println("response code " + huc.getResponseCode());
        String contentEncoding = huc.getContentEncoding();
        System.out.println("getting InputStream");
        inStream = huc.getInputStream();
        if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
            inStream = new GZIPInputStream(inStream);
            System.out.println("using gzip encoding!");
        }
        System.out.println("got InputStream from  DAS Alignment server");
        System.out.println("encoding: " + contentEncoding);
        return inStream;
    }

    public Alignment[] parseDASResponse(InputStream inStream) throws IOException, SAXException {
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(true);
        SAXParser saxParser = null;
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XMLReader xmlreader = saxParser.getXMLReader();
        try {
            xmlreader.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (SAXException e) {
            System.err.println("Cannot activate validation.");
        }
        try {
            xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        DASAlignmentXMLResponseParser cont_handle = new DASAlignmentXMLResponseParser();
        xmlreader.setContentHandler(cont_handle);
        xmlreader.setErrorHandler(new DefaultHandler());
        InputSource insource = new InputSource();
        insource.setByteStream(inStream);
        xmlreader.parse(insource);
        return cont_handle.getAlignments();
    }
}

