/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff3;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFErrorHandler;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.program.gff.IgnoreRecordException;
import org.biojava.bio.program.gff3.GFF3DocumentHandler;
import org.biojava.bio.program.gff3.GFF3Record;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.Term;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParserException;

public class GFF3Parser {
    private GFFErrorHandler errors = GFFErrorHandler.ABORT_PARSING;

    public void setErrorHandler(GFFErrorHandler errors) {
        this.errors = errors;
    }

    public GFFErrorHandler getErrorHandler() {
        return this.errors;
    }

    public void parse(BufferedReader bReader, GFF3DocumentHandler handler, Ontology ontology) throws IOException, BioException, ParserException {
        this.parse(bReader, handler, ontology, "unknown:");
    }

    public void parse(BufferedReader bReader, GFF3DocumentHandler handler, Ontology ontology, String locator) throws IOException, BioException, ParserException {
        Ontology fallBack;
        HashSet featureIDs = new HashSet();
        try {
            fallBack = OntoTools.getDefaultFactory().createOntology("Unknown in " + locator, "");
        }
        catch (OntologyException ex) {
            throw new ParserException("Couldn't create fallback ontology", ex);
        }
        handler.startDocument(locator);
        ArrayList<String> aList = new ArrayList<String>();
        int lineNum = 0;
        String line = bReader.readLine();
        while (line != null) {
            block12: {
                ++lineNum;
                try {
                    int ci;
                    aList.clear();
                    if (line.startsWith("#")) {
                        handler.commentLine(line.substring(1));
                        break block12;
                    }
                    if (line.length() == 0) break block12;
                    StringTokenizer st = new StringTokenizer(line, "\t", false);
                    while (st.hasMoreTokens() && aList.size() < 8) {
                        String token = st.nextToken();
                        aList.add(token);
                    }
                    String rest = null;
                    String comment = null;
                    if (st.hasMoreTokens()) {
                        try {
                            rest = st.nextToken("\u0000");
                        }
                        catch (NoSuchElementException nsee) {
                            // empty catch block
                        }
                    }
                    if (rest != null && (ci = rest.indexOf("#")) != -1) {
                        comment = rest.substring(ci);
                        rest = rest.substring(0, ci);
                    }
                    GFF3Record record = this.createRecord(handler, aList, rest, comment, ontology, fallBack);
                    handler.recordLine(record);
                }
                catch (ParserException ex) {
                    throw new ParserException(ex, "", locator, lineNum, line);
                }
                catch (IgnoreRecordException ex) {
                    // empty catch block
                }
            }
            line = bReader.readLine();
        }
        handler.endDocument();
    }

    protected GFF3Record createRecord(GFF3DocumentHandler handler, List aList, String rest, String comment, Ontology ontology, Ontology fallBack) throws BioException, ParserException, IgnoreRecordException {
        Term tt;
        Term st;
        GFF3Record.Impl record = new GFF3Record.Impl();
        record.setSequenceID((String)aList.get(0));
        String stn = (String)aList.get(1);
        if (ontology.containsTerm(stn)) {
            st = ontology.getTerm(stn);
        } else if (fallBack.containsTerm(stn)) {
            st = fallBack.getTerm(stn);
        } else {
            try {
                st = fallBack.createTerm(stn, "");
            }
            catch (AlreadyExistsException te) {
                throw new BioError("Assertion Failure: Term should not yet exist", te);
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Unable to create term", cve);
            }
        }
        record.setSource(st);
        String ttn = (String)aList.get(2);
        if (ontology.containsTerm(ttn)) {
            tt = ontology.getTerm(ttn);
        } else if (fallBack.containsTerm(ttn)) {
            tt = fallBack.getTerm(ttn);
        } else {
            try {
                tt = fallBack.createTerm(ttn, "");
            }
            catch (AlreadyExistsException te) {
                throw new BioError("Assertion Failure: Term should not yet exist", te);
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Unable to create term", cve);
            }
        }
        record.setSource(tt);
        int start = -1;
        try {
            start = Integer.parseInt((String)aList.get(3));
        }
        catch (NumberFormatException nfe) {
            start = this.errors.invalidStart((String)aList.get(3));
        }
        record.setStart(start);
        int end = -1;
        try {
            end = Integer.parseInt((String)aList.get(4));
        }
        catch (NumberFormatException nfe) {
            end = this.errors.invalidEnd((String)aList.get(3));
        }
        record.setEnd(end);
        String score = (String)aList.get(5);
        if (score == null || score.equals("") || score.equals(".") || score.equals("0")) {
            record.setScore(GFFTools.NO_SCORE);
        } else {
            double sc = 0.0;
            try {
                sc = Double.parseDouble(score);
            }
            catch (NumberFormatException nfe) {
                sc = this.errors.invalidScore(score);
            }
            record.setScore(sc);
        }
        String strand = (String)aList.get(6);
        if (strand == null || strand.equals("") || strand.equals(".")) {
            record.setStrand(StrandedFeature.UNKNOWN);
        } else if (strand.equals("+")) {
            record.setStrand(StrandedFeature.POSITIVE);
        } else if (strand.equals("-")) {
            record.setStrand(StrandedFeature.NEGATIVE);
        } else {
            record.setStrand(this.errors.invalidStrand(strand));
        }
        String frame = (String)aList.get(7);
        if (frame.equals(".")) {
            record.setPhase(GFFTools.NO_FRAME);
        } else {
            int fr = 0;
            try {
                fr = Integer.parseInt(frame);
            }
            catch (NumberFormatException nfe) {
                fr = this.errors.invalidFrame(frame);
            }
            record.setPhase(fr);
        }
        if (rest != null) {
            try {
                this.parseAttribute(rest, record.getAnnotation(), ontology, fallBack);
            }
            catch (ChangeVetoException cve) {
                throw new BioException("Unable to populate annotations", cve);
            }
        }
        return record;
    }

    protected void parseAttribute(String attValList, Annotation anno, Ontology onto, Ontology fallBack) throws ChangeVetoException {
        StringTokenizer sTok = new StringTokenizer(attValList, ";", false);
        while (sTok.hasMoreTokens()) {
            Term key;
            String attName;
            String attVal = sTok.nextToken().trim();
            ArrayList<String> valList = new ArrayList<String>();
            int spaceIndx = attVal.indexOf("=");
            if (spaceIndx == -1) {
                attName = attVal;
            } else {
                attName = attVal.substring(0, spaceIndx);
                attValList = attVal.substring(spaceIndx).trim();
                while (attValList.length() > 0) {
                    if (attValList.startsWith("\"")) {
                        int quoteIndx = 0;
                        do {
                            ++quoteIndx;
                        } while ((quoteIndx = attValList.indexOf("\"", quoteIndx)) != -1 && attValList.charAt(quoteIndx - 1) == '\\');
                        if (quoteIndx > 0) {
                            valList.add(attValList.substring(1, quoteIndx));
                            attValList = attValList.substring(quoteIndx + 1).trim();
                            continue;
                        }
                        valList.add(attValList);
                        attValList = "";
                        continue;
                    }
                    int commaIndx = attValList.indexOf(",");
                    if (commaIndx == -1) {
                        valList.add(attValList);
                        attValList = "";
                        continue;
                    }
                    valList.add(attValList.substring(0, commaIndx));
                    attValList = attValList.substring(commaIndx + 1).trim();
                }
            }
            if (onto.containsTerm(attName)) {
                key = onto.getTerm(attName);
            } else if (fallBack.containsTerm(attName)) {
                key = fallBack.getTerm(attName);
            } else {
                try {
                    key = fallBack.createTerm(attName, "");
                }
                catch (AlreadyExistsException te) {
                    throw new BioError("Assertion Failure: Term should not be there yet", te);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError("Assertion Failure: Unable to create term", cve);
                }
            }
            anno.setProperty(key, valList);
        }
    }
}

