/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.search.BlastLikeSearchFilter;
import org.biojava.bio.search.SearchContentAdapter;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.utils.TriState;
import org.biojava.utils.walker.Visitor;
import org.biojava.utils.walker.Walker;
import org.biojava.utils.walker.WalkerFactory;

public class FilteringContentHandler
extends SearchContentAdapter
implements BlastLikeSearchFilter.Node {
    private Map searchProperty = new HashMap();
    private Map hitProperty = new HashMap();
    private Map subHitProperty = new HashMap();
    private String databaseId;
    private List searchFilters = new ArrayList();
    private List hitFilters = new ArrayList();
    private List subHitFilters = new ArrayList();
    private static final int UNINITTED = 0;
    private static final int IN_HEADER = 1;
    private static final int IN_SEARCH = 2;
    private static final int IN_HIT = 3;
    private static final int IN_SUBHIT = 4;
    private static final int OUT_SUBHIT = 5;
    private static final int OUT_HIT = 6;
    private boolean parsingError = false;
    private boolean emittedStartHeader;
    private boolean emittedStartSearch;
    private boolean emittedStartHit;
    private boolean emittedStartSubHit;
    private boolean skipHits = false;
    private boolean skipSubHits = false;
    private int matchedSubHit = 0;
    private int matchedHit = 0;
    private int matchedSearch = 0;
    private boolean firstSubHit = true;
    private boolean firstHit = true;
    private boolean firstSearch = true;
    private int state = 0;
    private static final WalkerFactory walkerFactory = WalkerFactory.getInstance(BlastLikeSearchFilter.class);
    private BlastLikeSearchFilter filter;
    private SearchContentHandler delegate;

    public Object getSearchProperty(Object key) {
        return this.searchProperty.get(key);
    }

    public Object getHitProperty(Object key) {
        return this.hitProperty.get(key);
    }

    public Object getSubHitProperty(Object key) {
        return this.subHitProperty.get(key);
    }

    public FilteringContentHandler(BlastLikeSearchFilter filter, SearchContentHandler delegate) throws BioException {
        this.construct(filter);
        this.setSearchContentHandler(delegate);
    }

    public FilteringContentHandler(BlastLikeSearchFilter filter) throws BioException {
        this.construct(filter);
    }

    private void construct(BlastLikeSearchFilter filter) throws BioException {
        this.filter = filter;
        FilterVisitor visitor = new FilterVisitor();
        Walker walker = walkerFactory.getWalker(visitor);
        walker.walk(filter, visitor);
    }

    public void setSearchContentHandler(SearchContentHandler delegate) {
        this.delegate = delegate;
    }

    public void startHeader() {
        this.state = 1;
        this.delegate.startHeader();
    }

    public void setDatabaseID(String id) {
        if (this.state != 1) {
            this.parsingError = true;
        }
        this.databaseId = id;
        this.delegate.setDatabaseID(id);
        this.emittedStartHeader = false;
    }

    public void endHeader() {
        this.state = 0;
        this.delegate.endHeader();
    }

    public void startSearch() {
        this.state = 2;
        this.emittedStartSearch = false;
        this.firstHit = true;
    }

    public void setQueryID(String queryID) {
        if (this.state != 2) {
            this.parsingError = true;
        }
        this.addSearchProperty("___QUERY_ID___", queryID);
    }

    public void addSearchProperty(Object key, Object value) {
        if (this.state != 2) {
            this.parsingError = true;
        }
        this.searchProperty.put(key, value);
    }

    public void startHit() {
        this.state = 3;
        this.emittedStartHit = false;
        this.firstSubHit = true;
        if (this.firstHit) {
            Iterator searchFilterI = this.searchFilters.iterator();
            while (searchFilterI.hasNext()) {
                BlastLikeSearchFilter sf = (BlastLikeSearchFilter)searchFilterI.next();
                sf.evaluate(this);
            }
            TriState filterStatus = this.filter.accept();
            if (filterStatus == TriState.FALSE) {
                this.skipHits = true;
                this.skipSubHits = true;
            }
            this.firstHit = false;
        }
    }

    public void addHitProperty(Object key, Object value) {
        if (this.skipHits) {
            return;
        }
        if (this.state != 3) {
            this.parsingError = true;
        }
        this.hitProperty.put(key, value);
    }

    public void startSubHit() {
        BlastLikeSearchFilter sf;
        if (this.skipSubHits) {
            return;
        }
        this.state = 4;
        this.emittedStartSubHit = false;
        Iterator subHitFilterI = this.hitFilters.iterator();
        while (subHitFilterI.hasNext()) {
            sf = (BlastLikeSearchFilter)subHitFilterI.next();
            sf.reset();
        }
        if (this.firstSubHit) {
            Iterator hitFilterI = this.hitFilters.iterator();
            while (hitFilterI.hasNext()) {
                sf = (BlastLikeSearchFilter)hitFilterI.next();
                sf.evaluate(this);
            }
            TriState filterStatus = this.filter.accept();
            if (filterStatus == TriState.FALSE) {
                this.skipSubHits = true;
            }
            this.firstSubHit = false;
        }
    }

    public void addSubHitProperty(Object key, Object value) {
        if (this.skipSubHits) {
            return;
        }
        if (this.state != 4) {
            this.parsingError = true;
        }
        this.subHitProperty.put(key, value);
    }

    public void endSubHit() {
        this.state = 5;
        if (!this.skipSubHits) {
            Iterator subHitFilterI = this.subHitFilters.iterator();
            while (subHitFilterI.hasNext()) {
                BlastLikeSearchFilter sf = (BlastLikeSearchFilter)subHitFilterI.next();
                sf.evaluate(this);
            }
            if (this.filter.accept() == TriState.TRUE) {
                Map.Entry entry;
                if (!this.emittedStartSearch) {
                    this.delegate.startSearch();
                    String queryId = (String)this.searchProperty.get("___QUERY_ID___");
                    if (queryId != null) {
                        this.delegate.setQueryID(queryId);
                    }
                    Iterator searchPropertyI = this.searchProperty.entrySet().iterator();
                    while (searchPropertyI.hasNext()) {
                        Map.Entry entry2 = searchPropertyI.next();
                        if ("___QUERY_ID___".equals(entry2.getKey())) continue;
                        this.delegate.addSearchProperty(entry2.getKey(), entry2.getValue());
                    }
                    this.emittedStartSearch = true;
                }
                if (!this.emittedStartHit) {
                    this.delegate.startHit();
                    Iterator hitPropertyI = this.hitProperty.entrySet().iterator();
                    while (hitPropertyI.hasNext()) {
                        entry = hitPropertyI.next();
                        this.delegate.addSearchProperty(entry.getKey(), entry.getValue());
                    }
                    this.emittedStartHit = true;
                }
                this.delegate.startSubHit();
                Iterator subHitPropertyI = this.subHitProperty.entrySet().iterator();
                while (subHitPropertyI.hasNext()) {
                    entry = subHitPropertyI.next();
                    this.delegate.addSearchProperty(entry.getKey(), entry.getValue());
                }
                this.delegate.endSubHit();
            }
        }
    }

    public void endHit() {
        this.state = 6;
        if (this.emittedStartHit) {
            this.delegate.endHit();
            this.emittedStartHit = false;
        }
    }

    public void endSearch() {
        this.state = 0;
        if (this.emittedStartSearch) {
            this.delegate.endSearch();
            this.emittedStartSearch = false;
        }
    }

    public class FilterVisitor
    implements Visitor {
        public void bySearchProperty(BlastLikeSearchFilter.BySearchProperty sf) {
            FilteringContentHandler.this.searchFilters.add(sf);
        }

        public void byHitProperty(BlastLikeSearchFilter.ByHitProperty sf) {
            FilteringContentHandler.this.hitFilters.add(sf);
        }

        public void bySubHitProperty(BlastLikeSearchFilter.BySubHitProperty sf) {
            FilteringContentHandler.this.subHitFilters.add(sf);
        }
    }
}

