/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.symbol.Location;

public interface RemoteFeature
extends StrandedFeature {
    public List getRegions();

    public Feature getRemoteFeature() throws BioException;

    public Resolver getResolver();

    public static final class Region {
        private final Location location;
        private final String seqID;
        private final boolean isRemote;

        public Region(Location location, String seqID, boolean isRemote) {
            this.location = location;
            this.seqID = seqID;
            this.isRemote = isRemote;
        }

        public Location getLocation() {
            return this.location;
        }

        public String getSeqID() {
            return this.seqID;
        }

        public boolean isRemote() {
            return this.isRemote;
        }
    }

    public static interface Resolver {
        public Feature resolve(RemoteFeature var1) throws IllegalIDException, BioException;
    }

    public static class Template
    extends StrandedFeature.Template {
        public List regions;
        public Resolver resolver;

        public Template() {
            this.location = Location.empty;
            this.regions = new ArrayList();
            this.resolver = null;
        }

        public Template(Feature.Template theTemplate) {
            this.location = theTemplate.location;
            if (this.location == null) {
                this.location = Location.empty;
            }
            this.type = theTemplate.type;
            this.source = theTemplate.source;
            this.annotation = theTemplate.annotation;
            this.strand = theTemplate instanceof StrandedFeature.Template ? ((StrandedFeature.Template)theTemplate).strand : StrandedFeature.UNKNOWN;
            this.resolver = null;
            this.regions = null;
        }
    }
}

