/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.Symbol;

public class SimilarityMatrix {
    static final int BLOSUM62 = 1;
    static final int DRUKE = 100;
    private double[][] matrix = null;
    private double scaleFactor = 0.0;
    final String aaList = "ACDEFGHIKLMNPQRSTVWY";

    public SimilarityMatrix(int type) {
        switch (type) {
            case 1: {
                this.matrix = this.getBlosum62();
                this.scaleFactor = Math.log(2.0) / 2.0;
                break;
            }
            case 100: {
                this.matrix = this.getDrukeFactors();
                this.scaleFactor = 1.0;
            }
        }
    }

    private String symbol2string(Symbol s) {
        String symbolToken = null;
        try {
            symbolToken = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(s);
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return symbolToken;
    }

    public double getSimilarityScore(Symbol aSymbol, Symbol bSymbol) {
        String a = this.symbol2string(aSymbol);
        String b = this.symbol2string(bSymbol);
        return this.matrix["ACDEFGHIKLMNPQRSTVWY".indexOf(a)]["ACDEFGHIKLMNPQRSTVWY".indexOf(b)];
    }

    public double getSimilarityScore(String a, String b) {
        return this.matrix["ACDEFGHIKLMNPQRSTVWY".indexOf(a)]["ACDEFGHIKLMNPQRSTVWY".indexOf(b)];
    }

    public double getRawSimilarityScore(Symbol aSymbol, Symbol bSymbol) {
        double score = this.getSimilarityScore(aSymbol, bSymbol);
        double rawScore = Math.exp(score *= this.scaleFactor);
        return rawScore;
    }

    private double[][] getBlosum62() {
        double[][] matrix = new double[][]{{4.0, 0.0, -2.0, -1.0, -2.0, 0.0, -2.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, -1.0, -1.0, 1.0, 0.0, 0.0, -3.0, -2.0}, {0.0, 9.0, -3.0, -4.0, -2.0, -3.0, -3.0, -1.0, -3.0, -1.0, -1.0, -3.0, -3.0, -3.0, -3.0, -1.0, -1.0, -1.0, -2.0, -2.0}, {-2.0, -3.0, 6.0, 2.0, -3.0, -1.0, -1.0, -3.0, -1.0, -4.0, -3.0, 1.0, -1.0, 0.0, -2.0, 0.0, -1.0, -3.0, -4.0, -3.0}, {-1.0, -4.0, 2.0, 5.0, -3.0, -2.0, 0.0, -3.0, 1.0, -3.0, -2.0, 0.0, -1.0, 2.0, 0.0, 0.0, -1.0, -2.0, -3.0, -2.0}, {-2.0, -2.0, -3.0, -3.0, 6.0, -3.0, -1.0, 0.0, -3.0, 0.0, 0.0, -3.0, -4.0, -3.0, -3.0, -2.0, -2.0, -1.0, 1.0, 3.0}, {0.0, -3.0, -1.0, -2.0, -3.0, 6.0, -2.0, -4.0, -2.0, -4.0, -3.0, 0.0, -2.0, -2.0, -2.0, 0.0, -2.0, -3.0, -2.0, -3.0}, {-2.0, -3.0, -1.0, 0.0, -1.0, -2.0, 8.0, -3.0, -1.0, -3.0, -2.0, 1.0, -2.0, 0.0, 0.0, -1.0, -2.0, -3.0, -2.0, 2.0}, {-1.0, -1.0, -3.0, -3.0, 0.0, -4.0, -3.0, 4.0, -3.0, 2.0, 1.0, -3.0, -3.0, -3.0, -3.0, -2.0, -1.0, 3.0, -3.0, -1.0}, {-1.0, -3.0, -1.0, 1.0, -3.0, -2.0, -1.0, -3.0, 5.0, -2.0, -1.0, 0.0, -1.0, 1.0, 2.0, 0.0, -1.0, -2.0, -3.0, -2.0}, {-1.0, -1.0, -4.0, -3.0, 0.0, -4.0, -3.0, 2.0, -2.0, 4.0, 2.0, -3.0, -3.0, -2.0, -2.0, -2.0, -1.0, 1.0, -2.0, -1.0}, {-1.0, -1.0, -3.0, -2.0, 0.0, -3.0, -2.0, 1.0, -1.0, 2.0, 5.0, -2.0, -2.0, 0.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0}, {-2.0, -3.0, 1.0, 0.0, -3.0, 0.0, 1.0, -3.0, 0.0, -3.0, -2.0, 6.0, -2.0, 0.0, 0.0, 1.0, 0.0, -3.0, -4.0, -2.0}, {-1.0, -3.0, -1.0, -1.0, -4.0, -2.0, -2.0, -3.0, -1.0, -3.0, -2.0, -2.0, 7.0, -1.0, -2.0, -1.0, -1.0, -2.0, -4.0, -3.0}, {-1.0, -3.0, 0.0, 2.0, -3.0, -2.0, 0.0, -3.0, 1.0, -2.0, 0.0, 0.0, -1.0, 5.0, 1.0, 0.0, -1.0, -2.0, -2.0, -1.0}, {-1.0, -3.0, -2.0, 0.0, -3.0, -2.0, 0.0, -3.0, 2.0, -2.0, -1.0, 0.0, -2.0, 1.0, 5.0, -1.0, -1.0, -3.0, -3.0, -2.0}, {1.0, -1.0, 0.0, 0.0, -2.0, 0.0, -1.0, -2.0, 0.0, -2.0, -1.0, 1.0, -1.0, 0.0, -1.0, 4.0, 1.0, -2.0, -3.0, -2.0}, {0.0, -1.0, -1.0, -1.0, -2.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, 0.0, -1.0, -1.0, -1.0, 1.0, 5.0, 0.0, -2.0, -2.0}, {0.0, -1.0, -3.0, -2.0, -1.0, -3.0, -3.0, 3.0, -2.0, 1.0, 1.0, -3.0, -2.0, -2.0, -3.0, -2.0, 0.0, 4.0, -3.0, -1.0}, {-3.0, -2.0, -4.0, -3.0, 1.0, -2.0, -2.0, -3.0, -3.0, -2.0, -1.0, -4.0, -4.0, -2.0, -3.0, -3.0, -2.0, -3.0, 11.0, 2.0}, {-2.0, -2.0, -3.0, -2.0, 3.0, -3.0, 2.0, -1.0, -2.0, -1.0, -1.0, -2.0, -3.0, -1.0, -2.0, -2.0, -2.0, -1.0, 2.0, 7.0}};
        return matrix;
    }

    public double[] getDrukeFactor(String aa) {
        return this.matrix["ACDEFGHIKLMNPQRSTVWY".indexOf(aa)];
    }

    public double[] getDrukeFactor(Symbol aa) {
        String aaString = null;
        try {
            aaString = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(aa);
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        if (aaString == null) {
            return null;
        }
        return this.matrix["ACDEFGHIKLMNPQRSTVWY".indexOf(aaString)];
    }

    private double[][] getDrukeFactors() {
        double[][] matrix = new double[][]{{-0.591, -1.302, -0.733, 1.57, -0.146}, {-1.343, 0.465, -0.862, -1.02, -0.255}, {1.05, 0.302, -3.656, -0.259, -3.242}, {1.357, -1.453, 1.477, 0.113, -0.837}, {-1.006, -0.59, 1.891, -0.397, 0.412}, {-0.384, 1.652, 1.33, 1.045, 2.064}, {0.336, -0.417, -1.673, -1.474, -0.078}, {-1.239, -0.547, 2.131, 0.393, 0.816}, {1.831, -0.561, 0.533, -0.277, 1.648}, {-1.019, -0.987, -1.505, 1.266, -0.912}, {-0.663, -1.524, 2.219, -1.005, 1.212}, {0.945, 0.828, 1.299, -0.169, 0.933}, {0.189, 2.081, -1.628, 0.421, -1.392}, {0.931, -0.179, -3.005, -0.503, -1.853}, {1.538, -0.055, 1.502, 0.44, 2.897}, {-0.228, 1.399, -4.76, 0.67, -2.647}, {-0.032, 0.326, 2.213, 0.908, 1.313}, {-1.337, -0.279, -0.544, 1.242, -1.262}, {-0.595, 0.009, 0.672, -2.128, -0.184}, {0.26, 0.83, 3.097, -0.838, 1.512}};
        return matrix;
    }
}

