/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandTarget;

class Dumper {
    private boolean started;
    private Set sources;

    Dumper(boolean started, Set sources, Set targets) {
        this.started = started;
        this.sources = sources;
    }

    void dump(PrintStream out) {
        out.println("Dump of CommandTargetManager state...");
        if (!this.started) {
            out.println("   CommandTargetManager not Started.");
        } else {
            DebugCommandState state = new DebugCommandState();
            out.println("   Sources:");
            LinkedList l = new LinkedList(this.sources);
            Collections.sort(l, new SourceComparator());
            Iterator i = l.iterator();
            while (i.hasNext()) {
                CommandSource source = (CommandSource)i.next();
                out.print("      " + source.getCommand());
                CommandTarget target = source.getTarget();
                if (target != null) {
                    out.print("->" + target);
                    target.enable(state);
                    if (state.isEnabled()) {
                        out.print(" (enabled) ");
                    } else {
                        out.print(" (disabled) ");
                    }
                }
                out.println();
            }
        }
    }

    private static class DebugCommandState
    implements BooleanCommandState {
        private boolean enabled;

        private DebugCommandState() {
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean state) {
            this.enabled = state;
        }

        public void setSelected(boolean check) {
        }

        public void setText(String text) {
        }

        public void setToolTipText(String text) {
        }
    }

    private static class SourceComparator
    implements Comparator {
        private SourceComparator() {
        }

        public int compare(Object o1, Object o2) {
            CommandSource s1 = (CommandSource)o1;
            CommandSource s2 = (CommandSource)o2;
            return s1.getCommand().compareTo(s2.getCommand());
        }
    }
}

