/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.BiNGOAnnotationDefaultReader;
import BiNGO.BiNGOAnnotationFlatFileReader;
import BiNGO.BiNGOOntologyDefaultReader;
import BiNGO.BiNGOOntologyFlatFileReader;
import BiNGO.ChooseAnnotationPanel;
import BiNGO.ChooseOntologyPanel;
import BiNGO.MonitorableTask;
import BiNGO.SettingsPanel;
import BiNGO.SwingWorker;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyTerm;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class AnnotationParser
implements MonitorableTask {
    private final String LOADCORRECT = "LOADCORRECT";
    private String bingoDir;
    private String fullGoPath;
    private String processGoPath;
    private String functionGoPath;
    private String componentGoPath;
    private SettingsPanel settingsPanel;
    private Annotation annotation;
    private Annotation parsedAnnotation;
    private Ontology ontology;
    private Ontology fullOntology;
    private HashMap synonymHash;
    private String idOption;
    private ChooseAnnotationPanel annotationPanel;
    private ChooseOntologyPanel ontologyPanel;
    private boolean status = true;
    private boolean orphansFound = false;
    private boolean consistency = false;
    protected int currentProgress;
    protected int lengthOfTask = -1;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;
    private HashSet parentsSet;

    public AnnotationParser(ChooseAnnotationPanel annotationPanel, ChooseOntologyPanel ontologyPanel, String idOption, SettingsPanel settingsPanel, String bingoDir) {
        this.annotationPanel = annotationPanel;
        this.ontologyPanel = ontologyPanel;
        this.settingsPanel = settingsPanel;
        this.idOption = idOption;
        this.bingoDir = bingoDir;
        File tmp = new File(bingoDir, "BiNGO");
        this.fullGoPath = new File(tmp, "GO_Full").toString();
        this.processGoPath = new File(tmp, "GO_Biological_Process").toString();
        this.functionGoPath = new File(tmp, "GO_Molecular_Function").toString();
        this.componentGoPath = new File(tmp, "GO_Cellular_Component").toString();
        this.currentProgress = 0;
        this.lengthOfTask = -1;
        this.done = false;
        this.canceled = false;
    }

    public void calculate() {
        this.currentProgress = 0;
        this.lengthOfTask = -1;
        this.done = false;
        this.canceled = false;
        if (!this.ontologyPanel.getDefault()) {
            String loadOntologyString = this.setCustomOntology();
            if (!loadOntologyString.equals("LOADCORRECT")) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "Your ontology file contains errors " + loadOntologyString);
            }
            this.checkOntology(this.ontology);
            String loadAnnotationString = !this.annotationPanel.getDefault() ? this.setCustomAnnotation() : this.setDefaultAnnotation(this.idOption);
            if (!loadAnnotationString.equals("LOADCORRECT")) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "Your annotation file contains errors " + loadAnnotationString);
            }
            if (this.status && !this.consistency) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "None of the labels in your annotation match with the chosen ontology, please check their compatibility.");
            }
            if (this.status) {
                this.parsedAnnotation = this.customRemap(this.annotation, this.ontology);
            }
        } else {
            String loadFullOntologyString = this.setFullOntology();
            if (!loadFullOntologyString.equals("LOADCORRECT")) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "Your full ontology file contains errors " + loadFullOntologyString);
            }
            this.checkOntology(this.fullOntology);
            String loadOntologyString = this.setDefaultOntology(this.synonymHash);
            if (!loadOntologyString.equals("LOADCORRECT")) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, loadOntologyString);
            }
            this.checkOntology(this.ontology);
            String loadAnnotationString = !this.annotationPanel.getDefault() ? this.setCustomAnnotation() : this.setDefaultAnnotation(this.idOption);
            if (!loadAnnotationString.equals("LOADCORRECT")) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, loadAnnotationString);
            }
            if (this.status && !this.consistency) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "None of the labels in your annotation match with the chosen ontology, please check their compatibility.");
            }
            if (this.status) {
                this.parsedAnnotation = this.ontologyPanel.getFile().toString().equals(this.fullGoPath) || this.ontologyPanel.getFile().toString().equals(this.processGoPath) || this.ontologyPanel.getFile().toString().equals(this.functionGoPath) || this.ontologyPanel.getFile().toString().equals(this.componentGoPath) ? this.customRemap(this.annotation, this.ontology) : this.remap(this.annotation, this.ontology);
            }
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
    }

    public String setCustomAnnotation() {
        String fileString = this.annotationPanel.getFile().toString();
        this.annotation = null;
        String resultString = "";
        try {
            BiNGOAnnotationFlatFileReader readerAnnotation = new BiNGOAnnotationFlatFileReader(new File(fileString), this.synonymHash, (Component)this.settingsPanel);
            this.annotation = readerAnnotation.getAnnotation();
            if (readerAnnotation.getOrphans()) {
                this.orphansFound = true;
            }
            if (readerAnnotation.getConsistency()) {
                this.consistency = true;
            }
            resultString = "LOADCORRECT";
        }
        catch (IllegalArgumentException e) {
            resultString = "ANNOTATION FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + e;
        }
        catch (IOException e) {
            resultString = "Annotation file could not be located...\n";
        }
        catch (Exception e) {
            resultString = "" + e;
        }
        return resultString;
    }

    public String setDefaultAnnotation(String idOption) {
        String fileString = this.annotationPanel.getFile().toString();
        this.annotation = null;
        String resultString = "";
        try {
            BiNGOAnnotationDefaultReader readerAnnotation = new BiNGOAnnotationDefaultReader(new File(fileString), this.synonymHash, (Component)this.settingsPanel, idOption, this.annotationPanel.getSelection(), this.ontologyPanel.getSelection(), "GO");
            this.annotation = readerAnnotation.getAnnotation();
            if (readerAnnotation.getOrphans()) {
                this.orphansFound = true;
            }
            if (readerAnnotation.getConsistency()) {
                this.consistency = true;
            }
            resultString = "LOADCORRECT";
        }
        catch (IllegalArgumentException e) {
            resultString = "ANNOTATION FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + e;
        }
        catch (IOException e) {
            resultString = "Annotation file could not be located...\nPossibly, you unzipped BiNGO in the wrong place (See FAQ on website)\n";
        }
        catch (Exception e) {
            resultString = "" + e;
        }
        return resultString;
    }

    public String setCustomOntology() {
        String fileString = this.ontologyPanel.getFile().toString();
        this.ontology = null;
        this.synonymHash = null;
        String resultString = "";
        try {
            BiNGOOntologyFlatFileReader readerOntology = new BiNGOOntologyFlatFileReader(new File(fileString));
            this.ontology = readerOntology.getOntology();
            this.synonymHash = readerOntology.getSynonymHash();
            resultString = "LOADCORRECT";
        }
        catch (IllegalArgumentException e) {
            resultString = "ONTOLOGY FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + e;
        }
        catch (IOException e) {
            resultString = "Ontology file could not be located...\n";
        }
        catch (Exception e) {
            resultString = "" + e;
        }
        return resultString;
    }

    public String setDefaultOntology(HashMap synonymHash) {
        String fileString = this.ontologyPanel.getFile().toString();
        this.ontology = null;
        String resultString = "";
        try {
            BiNGOOntologyDefaultReader readerOntology = new BiNGOOntologyDefaultReader(new File(fileString), synonymHash);
            this.ontology = readerOntology.getOntology();
            resultString = "LOADCORRECT";
        }
        catch (IllegalArgumentException e) {
            resultString = "ONTOLOGY FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + e;
        }
        catch (IOException e) {
            resultString = "Ontology file could not be located...\nPossibly, you unzipped BiNGO in the wrong place (See FAQ on website)\n";
        }
        catch (Exception e) {
            resultString = "" + e;
        }
        return resultString;
    }

    public String setFullOntology() {
        this.fullOntology = null;
        this.synonymHash = null;
        String resultString = "";
        try {
            BiNGOOntologyFlatFileReader readerOntology = new BiNGOOntologyFlatFileReader(new File(this.fullGoPath));
            this.fullOntology = readerOntology.getOntology();
            this.synonymHash = readerOntology.getSynonymHash();
            resultString = "LOADCORRECT";
        }
        catch (IllegalArgumentException e) {
            resultString = "ONTOLOGY FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + e;
        }
        catch (IOException e) {
            resultString = "Ontology file could not be located...\nPossibly, you unzipped BiNGO in the wrong place (See FAQ on website)\n";
        }
        catch (Exception e) {
            resultString = "" + e;
        }
        return resultString;
    }

    public void checkOntology(Ontology ontology) {
        HashMap ontMap = ontology.getTerms();
        Iterator it = ontMap.keySet().iterator();
        while (it.hasNext()) {
            this.parentsSet = new HashSet();
            int childNode = new Integer(it.next().toString());
            this.up_go(childNode, childNode, ontology);
        }
    }

    public Annotation remap(Annotation annotation, Ontology ontology) {
        Annotation parsedAnnotation = new Annotation(annotation.getSpecies(), annotation.getType(), annotation.getCurator());
        HashMap annMap = annotation.getMap();
        Iterator it = annMap.keySet().iterator();
        this.lengthOfTask = annMap.keySet().size();
        while (it.hasNext()) {
            ++this.currentProgress;
            this.parentsSet = new HashSet();
            String node = it.next() + "";
            int[] goID = annotation.getClassifications(node);
            for (int t = 0; t < goID.length; ++t) {
                if (ontology.getTerm(goID[t]) != null) {
                    parsedAnnotation.add(node, goID[t]);
                }
                if (this.fullOntology.getTerm(goID[t]) != null) {
                    this.up(node, goID[t], parsedAnnotation, ontology, this.fullOntology);
                    continue;
                }
                this.orphansFound = true;
            }
        }
        return parsedAnnotation;
    }

    public Annotation customRemap(Annotation annotation, Ontology ontology) {
        Annotation parsedAnnotation = new Annotation(annotation.getSpecies(), annotation.getType(), annotation.getCurator());
        HashMap annMap = annotation.getMap();
        Iterator it = annMap.keySet().iterator();
        this.lengthOfTask = annMap.keySet().size();
        while (it.hasNext()) {
            ++this.currentProgress;
            this.parentsSet = new HashSet();
            String node = it.next() + "";
            int[] goID = annotation.getClassifications(node);
            for (int t = 0; t < goID.length; ++t) {
                if (ontology.getTerm(goID[t]) == null) continue;
                parsedAnnotation.add(node, goID[t]);
                this.up(node, goID[t], parsedAnnotation, ontology, ontology);
            }
        }
        return parsedAnnotation;
    }

    public void up(String node, int goID, Annotation parsedAnnotation, Ontology ontology, Ontology flOntology) {
        OntologyTerm child = flOntology.getTerm(goID);
        int[] parents = child.getParentsAndContainers();
        for (int t = 0; t < parents.length; ++t) {
            if (this.parentsSet.contains(new Integer(parents[t]))) continue;
            this.parentsSet.add(new Integer(parents[t]));
            if (ontology.getTerm(parents[t]) != null) {
                parsedAnnotation.add(node, parents[t]);
            }
            this.up(node, parents[t], parsedAnnotation, ontology, flOntology);
        }
    }

    public void up_go(int startID, int goID, Ontology ontology) {
        OntologyTerm child = ontology.getTerm(goID);
        int[] parents = child.getParentsAndContainers();
        for (int t = 0; t < parents.length; ++t) {
            if (parents[t] == startID) {
                this.status = false;
                this.done = true;
                JOptionPane.showMessageDialog(this.settingsPanel, "Your ontology file contains a cycle at ID " + startID);
                continue;
            }
            if (this.parentsSet.contains(new Integer(parents[t]))) continue;
            this.parentsSet.add(new Integer(parents[t]));
            this.up_go(startID, parents[t], ontology);
        }
    }

    public Annotation getAnnotation() {
        return this.parsedAnnotation;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public boolean getOrphans() {
        return this.orphansFound;
    }

    public boolean getStatus() {
        return this.status;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Parsing Annotation...";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new DoTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class DoTask {
        DoTask() {
            AnnotationParser.this.calculate();
        }
    }
}

