/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

public class SignificantFigures
extends Number {
    private String original;
    private StringBuffer digits;
    private int mantissa = -1;
    private boolean sign = true;
    private boolean isZero = false;
    private static final int INITIAL = 0;
    private static final int LEADZEROS = 1;
    private static final int MIDZEROS = 2;
    private static final int DIGITS = 3;
    private static final int LEADZEROSDOT = 4;
    private static final int DIGITSDOT = 5;
    private static final int MANTISSA = 6;
    private static final int MANTISSADIGIT = 7;

    public SignificantFigures(String number) throws NumberFormatException {
        this.original = number;
        this.parse(this.original);
    }

    public SignificantFigures(byte number) {
        this.original = Byte.toString(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(short number) {
        this.original = Short.toString(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(int number) {
        this.original = String.valueOf(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(long number) {
        this.original = Long.toString(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(float number) {
        this.original = Float.toString(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(double number) {
        this.original = Double.toString(number);
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public SignificantFigures(Number number) {
        this.original = number.toString();
        try {
            this.parse(this.original);
        }
        catch (NumberFormatException nfe) {
            this.digits = null;
        }
    }

    public int getNumberSignificantFigures() {
        if (this.digits == null) {
            return 0;
        }
        return this.digits.length();
    }

    public SignificantFigures setLSD(int place) {
        this.setLMSD(place, Integer.MIN_VALUE);
        return this;
    }

    public SignificantFigures setLMSD(int leastPlace, int mostPlace) {
        if (this.digits != null && leastPlace != Integer.MIN_VALUE) {
            int current;
            int significantFigures = this.digits.length();
            int newLength = significantFigures - leastPlace + (current = this.mantissa - significantFigures + 1);
            if (newLength <= 0) {
                if (mostPlace == Integer.MIN_VALUE) {
                    this.original = "NaN";
                    this.digits = null;
                } else {
                    newLength = mostPlace - leastPlace + 1;
                    this.digits.setLength(newLength);
                    this.mantissa = leastPlace;
                    for (int i = 0; i < newLength; ++i) {
                        this.digits.setCharAt(i, '0');
                    }
                    this.isZero = true;
                    this.sign = true;
                }
            } else {
                this.digits.setLength(newLength);
                for (int i = significantFigures; i < newLength; ++i) {
                    this.digits.setCharAt(i, '0');
                }
            }
        }
        return this;
    }

    public int getLSD() {
        if (this.digits == null) {
            return Integer.MIN_VALUE;
        }
        return this.mantissa - this.digits.length() + 1;
    }

    public int getMSD() {
        if (this.digits == null) {
            return Integer.MIN_VALUE;
        }
        return this.mantissa + 1;
    }

    public String toString() {
        if (this.digits == null) {
            return this.original;
        }
        StringBuffer digits = new StringBuffer(this.digits.toString());
        int length = digits.length();
        if (this.mantissa <= -4 || this.mantissa >= 7 || this.mantissa >= length && digits.charAt(digits.length() - 1) == '0' || this.isZero && this.mantissa != 0) {
            if (length > 1) {
                digits.insert(1, '.');
            }
            if (this.mantissa != 0) {
                digits.append("E" + this.mantissa);
            }
        } else if (this.mantissa <= -1) {
            digits.insert(0, "0.");
            for (int i = this.mantissa; i < -1; ++i) {
                digits.insert(2, '0');
            }
        } else if (this.mantissa + 1 == length) {
            if (length > 1 && digits.charAt(digits.length() - 1) == '0') {
                digits.append('.');
            }
        } else if (this.mantissa < length) {
            digits.insert(this.mantissa + 1, '.');
        } else {
            for (int i = length; i <= this.mantissa; ++i) {
                digits.append('0');
            }
        }
        if (!this.sign) {
            digits.insert(0, '-');
        }
        return digits.toString();
    }

    public String toScientificNotation() {
        if (this.digits == null) {
            return this.original;
        }
        StringBuffer digits = new StringBuffer(this.digits.toString());
        int length = digits.length();
        if (length > 1) {
            digits.insert(1, '.');
        }
        if (this.mantissa != 0) {
            digits.append("E" + this.mantissa);
        }
        if (!this.sign) {
            digits.insert(0, '-');
        }
        return digits.toString();
    }

    private void parse(String number) throws NumberFormatException {
        int length = number.length();
        this.digits = new StringBuffer(length);
        int state = 0;
        int mantissaStart = -1;
        boolean foundMantissaDigit = false;
        int zeroCount = 0;
        int leadZeroCount = 0;
        block37: for (int i = 0; i < length; ++i) {
            char c = number.charAt(i);
            switch (c) {
                case '.': {
                    int j;
                    switch (state) {
                        case 0: 
                        case 1: {
                            state = 4;
                            continue block37;
                        }
                        case 2: {
                            for (j = 0; j < zeroCount; ++j) {
                                this.digits.append('0');
                            }
                            zeroCount = 0;
                            state = 5;
                            continue block37;
                        }
                        case 3: {
                            state = 5;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                case '+': {
                    switch (state) {
                        case 0: {
                            this.sign = true;
                            state = 1;
                            continue block37;
                        }
                        case 6: {
                            state = 7;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                case '-': {
                    switch (state) {
                        case 0: {
                            this.sign = false;
                            state = 1;
                            continue block37;
                        }
                        case 6: {
                            state = 7;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                case '0': {
                    switch (state) {
                        case 0: 
                        case 1: {
                            ++zeroCount;
                            ++leadZeroCount;
                            state = 1;
                            continue block37;
                        }
                        case 2: 
                        case 3: {
                            ++this.mantissa;
                            ++zeroCount;
                            state = 2;
                            continue block37;
                        }
                        case 4: {
                            --this.mantissa;
                            ++zeroCount;
                            state = 4;
                            continue block37;
                        }
                        case 5: {
                            this.digits.append(c);
                            continue block37;
                        }
                        case 6: 
                        case 7: {
                            foundMantissaDigit = true;
                            state = 7;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int j;
                    switch (state) {
                        case 0: 
                        case 1: 
                        case 3: {
                            zeroCount = 0;
                            this.digits.append(c);
                            ++this.mantissa;
                            state = 3;
                            continue block37;
                        }
                        case 2: {
                            for (j = 0; j < zeroCount; ++j) {
                                this.digits.append('0');
                            }
                            zeroCount = 0;
                            this.digits.append(c);
                            ++this.mantissa;
                            state = 3;
                            continue block37;
                        }
                        case 4: 
                        case 5: {
                            zeroCount = 0;
                            this.digits.append(c);
                            state = 5;
                            continue block37;
                        }
                        case 6: 
                        case 7: {
                            state = 7;
                            foundMantissaDigit = true;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                case 'E': 
                case 'e': {
                    switch (state) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            mantissaStart = i + 1;
                            state = 6;
                            continue block37;
                        }
                    }
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
                default: {
                    throw new NumberFormatException("Unexpected character '" + c + "' at position " + i);
                }
            }
        }
        if (mantissaStart != -1) {
            if (!foundMantissaDigit) {
                throw new NumberFormatException("No digits in mantissa.");
            }
            this.mantissa += Integer.parseInt(number.substring(mantissaStart));
        }
        if (this.digits.length() == 0) {
            if (zeroCount > 0) {
                for (int j = 0; j < zeroCount; ++j) {
                    this.digits.append('0');
                }
                this.mantissa += leadZeroCount;
                this.isZero = true;
                this.sign = true;
            } else {
                throw new NumberFormatException("No digits in number.");
            }
        }
    }

    public SignificantFigures setNumberSignificantFigures(int significantFigures) {
        if (significantFigures <= 0) {
            throw new IllegalArgumentException("Desired number of significant figures must be positive.");
        }
        if (this.digits != null) {
            int length = this.digits.length();
            if (length < significantFigures) {
                for (int i = length; i < significantFigures; ++i) {
                    this.digits.append('0');
                }
            } else if (length > significantFigures) {
                int i;
                boolean addOne;
                char firstInSig = this.digits.charAt(significantFigures);
                if (firstInSig < '5') {
                    addOne = false;
                } else if (firstInSig == '5') {
                    addOne = false;
                    for (i = significantFigures + 1; !addOne && i < length; ++i) {
                        if (this.digits.charAt(i) == '0') continue;
                        addOne = true;
                    }
                    if (!addOne) {
                        addOne = (this.digits.charAt(significantFigures - 1) & '\u0001') == 1;
                    }
                } else {
                    addOne = true;
                }
                for (i = significantFigures - 1; addOne && i >= 0; --i) {
                    char digit = this.digits.charAt(i);
                    if (digit < '9') {
                        this.digits.setCharAt(i, (char)(digit + '\u0001'));
                        addOne = false;
                        continue;
                    }
                    this.digits.setCharAt(i, '0');
                }
                if (addOne) {
                    this.digits.insert(0, '1');
                    ++this.mantissa;
                }
                this.digits.setLength(significantFigures);
            }
        }
        return this;
    }

    public byte byteValue() throws NumberFormatException {
        return Byte.parseByte(this.original);
    }

    public double doubleValue() throws NumberFormatException {
        return Double.parseDouble(this.original);
    }

    public float floatValue() throws NumberFormatException {
        return Float.parseFloat(this.original);
    }

    public int intValue() throws NumberFormatException {
        return Integer.parseInt(this.original);
    }

    public long longValue() throws NumberFormatException {
        return Long.parseLong(this.original);
    }

    public short shortValue() throws NumberFormatException {
        return Short.parseShort(this.original);
    }

    public static String format(byte number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(double number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(float number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(int number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(long number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(Number number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(short number, int significantFigures) {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String format(String number, int significantFigures) throws NumberFormatException {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toString();
    }

    public static String sci_format(String number, int significantFigures) throws NumberFormatException {
        SignificantFigures sf = new SignificantFigures(number);
        sf.setNumberSignificantFigures(significantFigures);
        return sf.toScientificNotation();
    }
}

