/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola;

import java.io.File;

public class LolaParameterSet {
    private File profileFile = null;
    private File codonBiasFile = null;
    private boolean uniquePeptides;
    private File outputPath = null;
    private int logoStartIndex;
    private int logoHeight;
    private double logoTrimPercentage;
    private String logoImageFormat;
    private String logoColorStyle;
    private String treeTitle;
    private String treeImageFormat;
    private String treeFilename;

    public LolaParameterSet() {
        this.profileFile = null;
        this.codonBiasFile = null;
        this.uniquePeptides = true;
        this.outputPath = null;
        this.logoStartIndex = 1;
        this.logoHeight = 180;
        this.logoTrimPercentage = 0.1;
        this.logoImageFormat = "PDF";
        this.logoColorStyle = "WebLogo";
        this.treeTitle = "Sequence Logo Tree";
        this.treeImageFormat = "PDF";
        this.treeFilename = null;
    }

    public LolaParameterSet(File profileFile, File biasFile, boolean uniquePeptides, File outputPath, int logoStartIndex, int logoHeight, double logoTrimPercentage, String logoImageFormat, String logoColorStyle, String treeTitle, String treeImageFormat, String treeFilename) {
        this.profileFile = profileFile;
        this.codonBiasFile = biasFile;
        this.uniquePeptides = uniquePeptides;
        this.outputPath = outputPath;
        this.logoStartIndex = logoStartIndex;
        this.logoHeight = logoHeight;
        this.logoTrimPercentage = logoTrimPercentage;
        this.logoImageFormat = logoImageFormat;
        this.logoColorStyle = logoColorStyle;
        this.treeTitle = treeTitle;
        this.treeImageFormat = treeImageFormat;
        this.treeFilename = treeFilename;
    }

    public LolaParameterSet(File profileFile, File biasFile, boolean uniquePeptides, File outputPath, int logoStartIndex, int logoHeight, double logoTrimPercentage, String logoImageFormat, String logoColorStyle) {
        this.profileFile = profileFile;
        this.codonBiasFile = biasFile;
        this.uniquePeptides = uniquePeptides;
        this.outputPath = outputPath;
        this.logoStartIndex = logoStartIndex;
        this.logoHeight = logoHeight;
        this.logoTrimPercentage = logoTrimPercentage;
        this.logoImageFormat = logoImageFormat;
        this.logoColorStyle = logoColorStyle;
    }

    public LolaParameterSet copy() {
        LolaParameterSet newParamSet = new LolaParameterSet(this.getProfileFile(), this.getCodonBiasFile(), this.getUniquePeptides(), this.getOutputPath(), this.getLogoStartIndex(), this.getLogoHeight(), this.getLogoTrimPercentage(), this.getLogoImageFileFormat(), this.getLogoColorStyle(), this.getTreeTitle(), this.getTreeImageFormat(), this.getTreeFilename());
        return newParamSet;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(File file) {
        this.profileFile = file;
    }

    public File getCodonBiasFile() {
        return this.codonBiasFile;
    }

    public void setCodonBiasFile(File file) {
        this.codonBiasFile = file;
    }

    public boolean getUniquePeptides() {
        return this.uniquePeptides;
    }

    public void setUniquePeptides(boolean value) {
        this.uniquePeptides = value;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(File path) {
        this.outputPath = path;
    }

    public int getLogoStartIndex() {
        return this.logoStartIndex;
    }

    public void setLogoStartIndex(int index) {
        this.logoStartIndex = index;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public void setLogoHeight(int height) {
        this.logoHeight = height;
    }

    public double getLogoTrimPercentage() {
        return this.logoTrimPercentage;
    }

    public void setLogoTrimPercentage(double percentage) {
        this.logoTrimPercentage = percentage;
    }

    public String getLogoImageFileFormat() {
        return this.logoImageFormat;
    }

    public void setLogoImageFormat(String imageFormat) {
        this.logoImageFormat = imageFormat;
    }

    public String getLogoColorStyle() {
        return this.logoColorStyle;
    }

    public void setLogoColorStyle(String colorStyle) {
        this.logoColorStyle = colorStyle;
    }

    public String getTreeTitle() {
        return this.treeTitle;
    }

    public void setTreeTitle(String treeTitle) {
        this.treeTitle = treeTitle;
    }

    public String getTreeImageFormat() {
        return this.treeImageFormat;
    }

    public void setTreeImageFormat(String treeImageFormat) {
        this.treeImageFormat = treeImageFormat;
    }

    public String getTreeFilename() {
        return this.treeFilename;
    }

    public void setTreeFilename(String treeFilename) {
        this.treeFilename = treeFilename;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("Profile File: " + this.profileFile.toString() + lineSep);
        return sb.toString();
    }
}

