/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.model;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class LogoTree {
    private String outputFilePath;
    private boolean isSaved;
    private BufferedImage treeImage;

    public void LogoTree() {
        this.outputFilePath = null;
        this.isSaved = false;
        this.treeImage = null;
    }

    public void setOutputFilePath(String path) {
        this.outputFilePath = path;
    }

    public String getOutputPath() {
        return this.outputFilePath;
    }

    public void setIsSaved(boolean flag) {
        this.isSaved = flag;
    }

    public boolean getIsSaved() {
        return this.isSaved;
    }

    public void setImage(BufferedImage image) {
        this.treeImage = image;
    }

    public BufferedImage getImage() {
        return this.treeImage;
    }

    public Image imageFromPDF() {
        try {
            if (this.isSaved) {
                PdfReader reader = new PdfReader(this.outputFilePath);
                PdfObject pdfObject = reader.getPdfObject(1);
                if (!pdfObject.isStream()) {
                    throw new Exception("Tyring to read image from a non-stream PDF file: " + this.outputFilePath);
                }
                PdfStream stream = (PdfStream)pdfObject;
                PdfObject pdfsubtype = stream.get(PdfName.SUBTYPE);
                if (pdfsubtype == null) {
                    throw new Exception("Not an image stream");
                }
                if (!pdfsubtype.toString().equals(PdfName.IMAGE.toString())) {
                    throw new Exception("Not an image stream");
                }
                byte[] img = PdfReader.getStreamBytesRaw((PRStream)stream);
                Image i = Toolkit.getDefaultToolkit().createImage(img);
                return i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

