/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import cytoscape.util.OpenBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import org.baderlab.brain.util.JMultiLineToolTip;
import org.baderlab.lola.LolaCurrentParameters;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.resources.LolaResources;
import org.baderlab.lola.view.MakeLogosFromProfileSetAction;
import org.baderlab.lola.view.actions.MakeLogoTreeAction;
import org.baderlab.lola.view.actions.SaveLogoTreeToFile;
import org.baderlab.lola.view.actions.SaveLogosToFileAction;

public class LolaMainFrame
implements Runnable {
    private ProfileSet allProfiles = new ProfileSet();
    private ProfileSet selectedProfiles = new ProfileSet();
    private LolaParameterSet currentParamsCopy;
    private JTabbedPane tabbedPane;
    private JTextField profileFileNameTextField;
    private JTextField biasFileNameTextField;
    private JTextField outputPathTextField;
    private JCheckBox uniquePeptidesCheckBox;
    private JButton openProfileButton;
    private JButton drawLogoButton;
    private JButton saveLogoButton;
    private JButton closeSelectedProfilesButton;
    private JButton closeAllProfilesButton;
    private JButton quitButton;
    private JPanel logoPanel;
    private JFormattedTextField logoStartIndexTextField;
    private JFormattedTextField logoHeightTextField;
    private JFormattedTextField logoTrimPercentageTextField;
    private JComboBox logoFormatComboBox;
    private JComboBox logoColorComboBox;
    private JPanel treePanel;
    private JTextField logoTreeTitle;
    private JTextField logoTreeOutputFilename;
    private JButton createLogoTreeButton;
    private JButton saveLogoTreeButton;
    JList profileList;
    private JScrollPane logoPane;
    private static final JFrame mainFrame = new JFrame("LOLA 1.1 beta");

    public LolaMainFrame() {
        this.allProfiles.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                LolaMainFrame.this.drawLogoButton.setEnabled(true);
                LolaMainFrame.this.saveLogoButton.setEnabled(true);
                if (LolaMainFrame.this.allProfiles.size() > 1) {
                    LolaMainFrame.this.createLogoTreeButton.setEnabled(true);
                    LolaMainFrame.this.saveLogoTreeButton.setEnabled(true);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (LolaMainFrame.this.allProfiles.size() == 0) {
                    LolaMainFrame.this.drawLogoButton.setEnabled(false);
                    LolaMainFrame.this.saveLogoButton.setEnabled(false);
                    LolaMainFrame.this.createLogoTreeButton.setEnabled(false);
                    LolaMainFrame.this.saveLogoTreeButton.setEnabled(false);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
    }

    public void run() {
        mainFrame.setDefaultCloseOperation(3);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        JSplitPane leftSplitPane = new JSplitPane(0);
        leftSplitPane.setContinuousLayout(true);
        leftSplitPane.setOneTouchExpandable(true);
        JScrollPane paramPane = new JScrollPane(this.getParameterPanel());
        this.profileList = new JList(this.allProfiles);
        JPanel profilePanel = new JPanel(new BorderLayout());
        JScrollPane profilePane = new JScrollPane(this.profileList);
        profilePane.setBorder(BorderFactory.createEtchedBorder());
        this.profileList.setSelectionMode(2);
        this.profileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objs = ((JList)listSelectionEvent.getSource()).getSelectedValues();
                if (objs.length < 1) {
                    return;
                }
                LolaMainFrame.this.selectedProfiles.removeAllElements();
                for (int i = 0; i < objs.length; ++i) {
                    Profile profile = null;
                    if (objs[i] != null) {
                        profile = (Profile)objs[i];
                        LolaMainFrame.this.selectedProfiles.addElement(profile);
                    }
                    ImageIcon icon = new ImageIcon(profile.getImage());
                    LolaMainFrame.this.logoPane.setViewportView(new JLabel(icon));
                }
                LolaMainFrame.this.closeSelectedProfilesButton.setEnabled(true);
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.closeSelectedProfilesButton = new JButton("Close Selected");
        this.closeSelectedProfilesButton.addActionListener(new closeSelectedProfilesAction());
        this.closeSelectedProfilesButton.setEnabled(false);
        bottomPanel.add(this.closeSelectedProfilesButton);
        this.closeAllProfilesButton = new JButton("Close All");
        this.closeAllProfilesButton.addActionListener(new closeAllProfilesAction());
        this.closeAllProfilesButton.setEnabled(true);
        bottomPanel.add(this.closeAllProfilesButton);
        this.quitButton = new JButton("Quit");
        this.quitButton.addActionListener(new quitAction());
        this.quitButton.setEnabled(true);
        bottomPanel.add(this.quitButton);
        profilePanel.add((Component)profilePane, "Center");
        profilePanel.add((Component)bottomPanel, "Last");
        leftSplitPane.setTopComponent(paramPane);
        leftSplitPane.setBottomComponent(profilePanel);
        ImageIcon icon = null;
        URL imageURL = LolaMainFrame.class.getResource("/org/baderlab/lola/resources/lola_logo.png");
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        }
        JLabel imageLabel = new JLabel(icon);
        this.logoPane = new JScrollPane(imageLabel);
        this.logoPane.setBorder(BorderFactory.createEtchedBorder());
        splitPane.setLeftComponent(leftSplitPane);
        splitPane.setRightComponent(this.logoPane);
        mainFrame.add((Component)splitPane, "Center");
        mainFrame.setSize(1400, 900);
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
    }

    private JPanel getParameterPanel() {
        this.currentParamsCopy = LolaCurrentParameters.getInstance().getParamsCopy();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Files", null, this.getFilesPanel(), "Set parameters that affect how sequence logos are generated.");
        this.logoPanel = this.getLogoGenerationParamsPanel();
        this.tabbedPane.addTab("Logo Options", null, this.logoPanel);
        this.treePanel = this.getLogoTreeParamsPanel();
        this.tabbedPane.addTab("Logo Tree", null, this.treePanel);
        this.tabbedPane.addTab("About", null, this.getAboutPanel());
        this.tabbedPane.addMouseListener(new tabbedPaneMouseListener());
        mainPanel.add((Component)this.tabbedPane, "Center");
        return mainPanel;
    }

    private JPanel getFilesPanel() {
        JPanel filesPanel = new JPanel(new BorderLayout());
        JPanel profileSelectionPanel = new JPanel(new BorderLayout());
        profileSelectionPanel.setBorder(BorderFactory.createTitledBorder("Profile Selection"));
        JPanel profileChooserPanel = new JPanel();
        this.profileFileNameTextField = new JTextField();
        this.profileFileNameTextField.setToolTipText("The file name of the profile or list of profiles.");
        if (this.currentParamsCopy.getProfileFile() != null) {
            this.profileFileNameTextField.setText(this.currentParamsCopy.getProfileFile().toString());
        }
        this.profileFileNameTextField.setColumns(30);
        this.profileFileNameTextField.addActionListener(new profileFileNameAction());
        this.profileFileNameTextField.getDocument().addDocumentListener(new profileFileNameAction());
        profileChooserPanel.add(this.profileFileNameTextField);
        JButton profileChooseFileButton = new JButton("Browse...");
        profileChooseFileButton.addActionListener(new chooseProfileAction());
        profileChooserPanel.add(profileChooseFileButton);
        profileSelectionPanel.add((Component)profileChooserPanel, "North");
        JPanel profileChooserSubSubPanel = new JPanel();
        this.uniquePeptidesCheckBox = new JCheckBox("Unique peptides", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.uniquePeptidesCheckBox.addItemListener(new uniquePeptidesCheckBoxAction());
        this.uniquePeptidesCheckBox.setToolTipText("If checked, only unique peptide sequences will be loaded from the profile.");
        this.uniquePeptidesCheckBox.setSelected(this.currentParamsCopy.getUniquePeptides());
        profileChooserSubSubPanel.add(this.uniquePeptidesCheckBox);
        profileSelectionPanel.add((Component)profileChooserSubSubPanel, "South");
        JPanel biasSelectionPanel = new JPanel(new BorderLayout());
        biasSelectionPanel.setBorder(BorderFactory.createTitledBorder("Codon Bias File"));
        JPanel biasFileChooserPanel = new JPanel();
        this.biasFileNameTextField = new JTextField();
        this.biasFileNameTextField.setToolTipText("The file name of the codon bias file specification.");
        if (this.currentParamsCopy.getCodonBiasFile() != null) {
            this.biasFileNameTextField.setText(this.currentParamsCopy.getCodonBiasFile().toString());
        }
        this.biasFileNameTextField.setColumns(30);
        this.biasFileNameTextField.addActionListener(new codonBiasFileNameAction());
        this.biasFileNameTextField.getDocument().addDocumentListener(new codonBiasFileNameAction());
        biasFileChooserPanel.add(this.biasFileNameTextField);
        JButton biasFileChooseFileButton = new JButton("Browse...");
        biasFileChooseFileButton.addActionListener(new chooseCodonBiasAction());
        biasFileChooserPanel.add(biasFileChooseFileButton);
        biasSelectionPanel.add((Component)biasFileChooserPanel, "North");
        JPanel outputPathSelectionPanel = new JPanel(new BorderLayout());
        outputPathSelectionPanel.setBorder(BorderFactory.createTitledBorder("Output Directory"));
        JPanel outputPathChooserPanel = new JPanel();
        this.outputPathTextField = new JTextField();
        this.outputPathTextField.setToolTipText("The directory path where output files will be saved.");
        if (this.currentParamsCopy.getOutputPath() != null) {
            this.outputPathTextField.setText(this.currentParamsCopy.getOutputPath().toString());
        }
        this.outputPathTextField.setColumns(30);
        this.outputPathTextField.addActionListener(new outputPathAction());
        this.outputPathTextField.getDocument().addDocumentListener(new outputPathAction());
        outputPathChooserPanel.add(this.outputPathTextField);
        JButton outputPathChooseFileButton = new JButton("Browse...");
        outputPathChooseFileButton.addActionListener(new chooseOutputPathAction());
        outputPathChooserPanel.add(outputPathChooseFileButton);
        outputPathSelectionPanel.add((Component)outputPathChooserPanel, "North");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.openProfileButton = new JButton("Open");
        this.openProfileButton.addActionListener(new MakeLogosFromProfileSetAction(this.allProfiles, this.currentParamsCopy));
        this.openProfileButton.setEnabled(false);
        bottomPanel.add(this.openProfileButton);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new clearFileFieldsAction());
        bottomPanel.add(clearButton);
        JPanel tab1Panel = new JPanel();
        tab1Panel.setMinimumSize(new Dimension(100, 200));
        tab1Panel.setLayout(new BoxLayout(tab1Panel, 1));
        tab1Panel.add(profileSelectionPanel);
        tab1Panel.add(biasSelectionPanel);
        tab1Panel.add(outputPathSelectionPanel);
        tab1Panel.add(bottomPanel);
        filesPanel.add((Component)tab1Panel, "North");
        return tab1Panel;
    }

    private JPanel old_getAboutPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new FlowLayout());
        JTextArea aboutTextArea = new JTextArea();
        aboutTextArea.setText("\n\nLOLA - LOgos Look Amazing!\nVersion 1.1 beta(August 22, 2007)\n\nMoyez Dharsee\nGary Bader\n\nwww.baderlab.org");
        aboutTextArea.setAlignmentX(0.5f);
        aboutTextArea.setAlignmentY(0.5f);
        aboutTextArea.setEditable(false);
        aboutTextArea.setRows(10);
        aboutTextArea.setOpaque(false);
        aboutPanel.setAlignmentX(0.5f);
        aboutPanel.add(aboutTextArea);
        return aboutPanel;
    }

    private JPanel getAboutPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new FlowLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.setOpaque(false);
        editorPane.setMargin(new Insets(10, 10, 10, 10));
        editorPane.setEditable(false);
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.addHyperlinkListener(new HyperlinkAction(editorPane));
        editorPane.setText("<html><body><P align=center><b>LOLA - LOgos Look Amazing!</b><BR>Version 1.1 beta<BR>August 22, 2007<BR><BR>Moyez Dharsee<BR>Gary Bader<BR><BR><a href='http://www.baderlab.org'>Bader Lab<BR>www.baderlab.org</a>");
        aboutPanel.add(editorPane);
        return aboutPanel;
    }

    private JPanel getLogoTreeParamsPanel() {
        JPanel logoTreeOutputPanel = new JPanel();
        logoTreeOutputPanel.setAlignmentX(0.0f);
        logoTreeOutputPanel.setLayout(new BorderLayout());
        logoTreeOutputPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel leftOutputPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        leftOutputPanel.setLayout(layout);
        leftOutputPanel.setAlignmentX(0.0f);
        JPanel titlePanel = new JPanel();
        BoxLayout titleLayout = new BoxLayout(titlePanel, 0);
        titlePanel.setLayout(titleLayout);
        JLabel treeTitleLabel = new JLabel("Title: ");
        treeTitleLabel.setAlignmentX(0.0f);
        this.logoTreeTitle = new JFormattedTextField();
        this.logoTreeTitle.setAlignmentX(0.0f);
        this.logoTreeTitle.setToolTipText("Title to be displayed at the top of the logo tree image.");
        this.logoTreeTitle.setColumns(30);
        this.logoTreeTitle.addPropertyChangeListener("value", new textFieldChangeListener());
        String title = this.currentParamsCopy.getTreeTitle();
        if (title != null) {
            this.logoTreeTitle.setText(title);
        }
        LolaMainFrame.addGridBagComponent(leftOutputPanel, treeTitleLabel, 0, 0, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoTreeTitle, 1, 0, 1, 1, 10, 1);
        JPanel outputPanel = new JPanel();
        BoxLayout outputLayout = new BoxLayout(outputPanel, 0);
        outputPanel.setLayout(outputLayout);
        JLabel outputNameLabel = new JLabel();
        outputNameLabel.setText("Output Filename: ");
        outputNameLabel.setAlignmentX(0.0f);
        this.logoTreeOutputFilename = new JFormattedTextField();
        this.logoTreeOutputFilename.setAlignmentX(0.0f);
        this.logoTreeOutputFilename.setToolTipText("Name of logo tree output file. DIRECTORY PATH IS NOT REQUIRED.   The file will be saved in the Output Directory set in the Files panel.");
        this.logoTreeOutputFilename.setColumns(30);
        this.logoTreeOutputFilename.addPropertyChangeListener("value", new textFieldChangeListener());
        LolaMainFrame.addGridBagComponent(leftOutputPanel, outputNameLabel, 0, 1, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoTreeOutputFilename, 1, 1, 1, 1, 10, 1);
        JPanel rightOutputPanel = new JPanel();
        rightOutputPanel.setLayout(new FlowLayout());
        JPanel logoFormatPanel = new JPanel();
        JLabel logoFormatLabel = new JLabel();
        logoFormatLabel.setText("Output Format:");
        this.logoFormatComboBox = new JComboBox<String>(LolaResources.TREE_IMAGE_FORMAT_STRINGS);
        this.logoFormatComboBox.setToolTipText("Ouput file format of logo tree.");
        String currentFormat = this.currentParamsCopy.getLogoImageFileFormat();
        if (currentFormat != null) {
            for (int i = 0; i < LolaResources.TREE_IMAGE_FORMAT_STRINGS.length; ++i) {
                if (!currentFormat.equalsIgnoreCase(LolaResources.TREE_IMAGE_FORMAT_STRINGS[i])) continue;
                this.logoFormatComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.logoFormatComboBox.addActionListener(new selectLogoTreeFormatAction());
        LolaMainFrame.addGridBagComponent(leftOutputPanel, logoFormatLabel, 0, 2, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoFormatComboBox, 1, 2, 1, 1, 21, 0);
        logoTreeOutputPanel.add((Component)leftOutputPanel, "First");
        logoTreeOutputPanel.add((Component)rightOutputPanel, "Last");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.createLogoTreeButton = new JButton("Generate");
        this.createLogoTreeButton.addActionListener(new generateLogoTreeAction());
        this.createLogoTreeButton.setEnabled(false);
        bottomPanel.add(this.createLogoTreeButton);
        this.saveLogoTreeButton = new JButton("Save");
        this.saveLogoTreeButton.addActionListener(new SaveLogoTreeToFile(this.allProfiles, this.currentParamsCopy));
        this.saveLogoTreeButton.setEnabled(false);
        bottomPanel.add(this.saveLogoTreeButton);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)logoTreeOutputPanel, "North");
        thePanel.add((Component)bottomPanel, "South");
        return thePanel;
    }

    private static void addGridBagComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        Insets insets = new Insets(5, 0, 0, 5);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 1, 0);
        container.add(component, gbc);
    }

    private JPanel getLogoGenerationParamsPanel() {
        JPanel logoSettingsPanel = new JPanel();
        logoSettingsPanel.setLayout(new FlowLayout());
        logoSettingsPanel.setBorder(BorderFactory.createTitledBorder("Logo Settings"));
        JPanel leftSettingsPanel = new JPanel();
        leftSettingsPanel.setLayout(new BoxLayout(leftSettingsPanel, 1));
        JPanel startIndexPanel = new JPanel(new BorderLayout());
        JLabel startIndexLabel = new JLabel();
        startIndexLabel.setText("Start Index:");
        this.logoStartIndexTextField = new JFormattedTextField();
        this.logoStartIndexTextField.setToolTipText("The first index on the X-axis of the logo graph.");
        this.logoStartIndexTextField.setValue(this.currentParamsCopy.getLogoStartIndex());
        this.logoStartIndexTextField.setColumns(3);
        this.logoStartIndexTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        startIndexPanel.add((Component)startIndexLabel, "West");
        startIndexPanel.add((Component)this.logoStartIndexTextField, "East");
        startIndexPanel.setAlignmentX(1.0f);
        leftSettingsPanel.add(startIndexPanel);
        JPanel logoHeightPanel = new JPanel(new BorderLayout());
        JLabel logoHeightLabel = new JLabel();
        logoHeightLabel.setText("Height:");
        this.logoHeightTextField = new JFormattedTextField();
        this.logoHeightTextField.setToolTipText("The height of the logo image, in pixels.");
        this.logoHeightTextField.setValue(this.currentParamsCopy.getLogoHeight());
        this.logoHeightTextField.setColumns(3);
        this.logoHeightTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        logoHeightPanel.add((Component)logoHeightLabel, "West");
        logoHeightPanel.add((Component)this.logoHeightTextField, "East");
        logoHeightPanel.setAlignmentX(1.0f);
        leftSettingsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        leftSettingsPanel.add(logoHeightPanel);
        JPanel logoTrimPercentagePanel = new JPanel(new BorderLayout());
        JLabel logoTrimPercentageLabel = new JLabel();
        logoTrimPercentageLabel.setText("Trim Percentage:");
        this.logoTrimPercentageTextField = new JFormattedTextField(){

            public JToolTip createToolTip() {
                JMultiLineToolTip t = new JMultiLineToolTip();
                t.setColumns(40);
                return t;
            }
        };
        this.logoTrimPercentageTextField.setToolTipText("If columns on either end of the profile are not above this height (in terms of percentage of total possible column height), they will be trimmed. This has the effect of highlighting the most informative contiguous region. The value must be between 0 and 1, inclusively.");
        this.logoTrimPercentageTextField.setValue(this.currentParamsCopy.getLogoTrimPercentage());
        this.logoTrimPercentageTextField.setColumns(3);
        this.logoTrimPercentageTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        logoTrimPercentagePanel.add((Component)logoTrimPercentageLabel, "West");
        logoTrimPercentagePanel.add((Component)this.logoTrimPercentageTextField, "East");
        logoTrimPercentagePanel.setAlignmentX(1.0f);
        leftSettingsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        leftSettingsPanel.add(logoTrimPercentagePanel);
        JPanel rightSettingsPanel = new JPanel();
        rightSettingsPanel.setLayout(new BoxLayout(rightSettingsPanel, 1));
        JPanel logoColorPanel = new JPanel();
        JLabel logoColorLabel = new JLabel();
        logoColorLabel.setText("Color Style: ");
        this.logoColorComboBox = new JComboBox<String>(LolaResources.COLOR_STYLES);
        this.logoColorComboBox.setToolTipText("Residue coloring scheme");
        String currentColor = this.currentParamsCopy.getLogoColorStyle();
        if (currentColor != null) {
            for (int i = 0; i < LolaResources.COLOR_STYLES.length; ++i) {
                if (!currentColor.equalsIgnoreCase(LolaResources.COLOR_STYLES[i])) continue;
                this.logoColorComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.logoColorComboBox.addActionListener(new selectColorStyleAction());
        logoColorPanel.add(logoColorLabel);
        logoColorPanel.add(this.logoColorComboBox);
        logoColorPanel.setAlignmentX(0.0f);
        rightSettingsPanel.add(logoColorPanel);
        JPanel logoFormatPanel = new JPanel();
        JLabel logoFormatLabel = new JLabel();
        logoFormatLabel.setText("Output Format:");
        this.logoFormatComboBox = new JComboBox<String>(LolaResources.IMAGE_FORMAT_STRINGS);
        this.logoFormatComboBox.setToolTipText("Ouput file format of logo image.");
        String currentFormat = this.currentParamsCopy.getLogoImageFileFormat();
        if (currentFormat != null) {
            for (int i = 0; i < LolaResources.IMAGE_FORMAT_STRINGS.length; ++i) {
                if (!currentFormat.equalsIgnoreCase(LolaResources.IMAGE_FORMAT_STRINGS[i])) continue;
                this.logoFormatComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.logoFormatComboBox.addActionListener(new selectLogoFormatAction());
        logoFormatPanel.add(logoFormatLabel);
        logoFormatPanel.add(this.logoFormatComboBox);
        logoFormatPanel.setAlignmentX(0.0f);
        rightSettingsPanel.add(logoFormatPanel);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.drawLogoButton = new JButton("Redraw All");
        this.drawLogoButton.addActionListener(new MakeLogosFromProfileSetAction(this.allProfiles, this.currentParamsCopy));
        this.drawLogoButton.setEnabled(false);
        bottomPanel.add(this.drawLogoButton);
        this.saveLogoButton = new JButton("Save All");
        this.saveLogoButton.addActionListener(new SaveLogosToFileAction(this.allProfiles, this.currentParamsCopy));
        this.saveLogoButton.setEnabled(false);
        bottomPanel.add(this.saveLogoButton);
        logoSettingsPanel.add(leftSettingsPanel);
        logoSettingsPanel.add(Box.createRigidArea(new Dimension(0, 50)));
        logoSettingsPanel.add(rightSettingsPanel);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)logoSettingsPanel, "North");
        thePanel.add((Component)bottomPanel, "South");
        return thePanel;
    }

    private File browseDirectory(String title, boolean directoryOnly) {
        JFileChooser fileDialog = new JFileChooser();
        if (directoryOnly) {
            fileDialog.setFileSelectionMode(1);
        }
        fileDialog.setDialogTitle(title);
        fileDialog.setVisible(true);
        fileDialog.showDialog(mainFrame, "OK");
        File file = fileDialog.getSelectedFile();
        return file;
    }

    private File browseFile(String title, boolean directoryOnly) {
        FileDialog fileDialog = new FileDialog((Frame)mainFrame, title, 0);
        fileDialog.setTitle(title);
        fileDialog.setVisible(true);
        String filePath = fileDialog.getFile();
        if (filePath != null) {
            return new File(fileDialog.getDirectory() + "/" + fileDialog.getFile());
        }
        return null;
    }

    private void displayLogoTree() {
        block3: {
            try {
                LogoTree tree = this.allProfiles.getLogoTree();
                if (tree == null) break block3;
                BufferedImage image = tree.getImage();
                if (image != null) {
                    ImageIcon icon = new ImageIcon(image);
                    this.logoPane.setViewportView(new JLabel(icon));
                    break block3;
                }
                throw new Exception("Could not obtain logo tree image.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void displaySelectedLogo() {
        Object[] objs = this.profileList.getSelectedValues();
        if (objs.length < 1) {
            return;
        }
        Profile profile = (Profile)objs[objs.length - 1];
        ImageIcon icon = new ImageIcon(profile.getImage());
        this.logoPane.setViewportView(new JLabel(icon));
    }

    private class generateLogoTreeAction
    implements ActionListener {
        private generateLogoTreeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MakeLogoTreeAction action = new MakeLogoTreeAction(LolaMainFrame.this.allProfiles, LolaMainFrame.this.currentParamsCopy);
            action.actionPerformed(actionEvent);
            LolaMainFrame.this.displayLogoTree();
        }
    }

    private class tabbedPaneMouseListener
    implements MouseListener {
        private tabbedPaneMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component selectedComponent = LolaMainFrame.this.tabbedPane.getSelectedComponent();
            if (selectedComponent.equals(LolaMainFrame.this.treePanel)) {
                LolaMainFrame.this.displayLogoTree();
            } else if (selectedComponent.equals(LolaMainFrame.this.logoPanel)) {
                LolaMainFrame.this.displaySelectedLogo();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class quitAction
    implements ActionListener {
        private quitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runtime.getRuntime().exit(0);
        }
    }

    private class closeAllProfilesAction
    implements ActionListener {
        private closeAllProfilesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LolaMainFrame.this.allProfiles.removeAllElements();
            LolaMainFrame.this.closeSelectedProfilesButton.setEnabled(false);
            LolaMainFrame.this.logoPane.setViewportView(null);
        }
    }

    private class closeSelectedProfilesAction
    implements ActionListener {
        private closeSelectedProfilesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            while (LolaMainFrame.this.selectedProfiles.size() > 0) {
                Profile p = (Profile)LolaMainFrame.this.selectedProfiles.get(0);
                LolaMainFrame.this.allProfiles.removeElement(p);
            }
            LolaMainFrame.this.selectedProfiles.removeAllElements();
            LolaMainFrame.this.closeSelectedProfilesButton.setEnabled(false);
            LolaMainFrame.this.logoPane.setViewportView(null);
        }
    }

    private class clearFileFieldsAction
    extends AbstractAction {
        clearFileFieldsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            LolaMainFrame.this.profileFileNameTextField.setText(null);
            LolaMainFrame.this.biasFileNameTextField.setText(null);
            LolaMainFrame.this.outputPathTextField.setText(null);
            LolaMainFrame.this.logoTreeOutputFilename.setText(null);
            LolaMainFrame.this.openProfileButton.setEnabled(false);
            LolaMainFrame.this.createLogoTreeButton.setEnabled(false);
            LolaMainFrame.this.saveLogoTreeButton.setEnabled(false);
        }
    }

    private class selectLogoTreeFormatAction
    extends AbstractAction {
        selectLogoTreeFormatAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String formatName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setTreeImageFormat(formatName);
            }
        }
    }

    private class selectColorStyleAction
    extends AbstractAction {
        selectColorStyleAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String colorName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setLogoColorStyle(colorName);
            }
        }
    }

    private class selectLogoFormatAction
    extends AbstractAction {
        selectLogoFormatAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String formatName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setLogoImageFormat(formatName);
            }
        }
    }

    private class textFieldChangeListener
    implements PropertyChangeListener {
        private textFieldChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JTextField textField;
            String text;
            Object obj = event.getSource();
            if (obj instanceof JTextField && (text = (textField = (JTextField)obj).getText()) != null) {
                Number value;
                boolean isNegative = false;
                if (text.length() > 1 && text.substring(0, 1).equals("-")) {
                    isNegative = true;
                    value = Integer.valueOf(text);
                }
                if (textField == LolaMainFrame.this.logoStartIndexTextField) {
                    value = (Number)LolaMainFrame.this.logoStartIndexTextField.getValue();
                    if (value != null) {
                        LolaMainFrame.this.currentParamsCopy.setLogoStartIndex(value.intValue());
                    } else {
                        LolaMainFrame.this.logoStartIndexTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoStartIndex());
                    }
                } else if (textField == LolaMainFrame.this.logoHeightTextField) {
                    value = (Number)LolaMainFrame.this.logoHeightTextField.getValue();
                    if (value != null && value.intValue() >= 10 && value.intValue() <= 2000) {
                        LolaMainFrame.this.currentParamsCopy.setLogoHeight(value.intValue());
                    } else {
                        LolaMainFrame.this.logoHeightTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoHeight());
                    }
                } else if (textField == LolaMainFrame.this.logoTrimPercentageTextField) {
                    value = (Number)LolaMainFrame.this.logoTrimPercentageTextField.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        LolaMainFrame.this.currentParamsCopy.setLogoTrimPercentage(value.doubleValue());
                    } else {
                        LolaMainFrame.this.logoTrimPercentageTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoTrimPercentage());
                    }
                } else if (textField == LolaMainFrame.this.logoTreeTitle) {
                    if (text != null && text.length() > 0) {
                        LolaMainFrame.this.currentParamsCopy.setTreeTitle(text);
                    } else {
                        LolaMainFrame.this.currentParamsCopy.setTreeTitle("");
                    }
                } else if (textField == LolaMainFrame.this.logoTreeOutputFilename && text != null && text.length() > 0) {
                    LolaMainFrame.this.currentParamsCopy.setTreeFilename(text);
                }
            }
        }
    }

    private class logoStartIndexTextFieldAction
    extends AbstractAction
    implements DocumentListener {
        logoStartIndexTextFieldAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.logoStartIndexTextField.getText();
            if (value != null) {
                try {
                    LolaMainFrame.this.currentParamsCopy.setLogoStartIndex(Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class chooseOutputPathAction
    extends AbstractAction {
        chooseOutputPathAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseDirectory("Select Output Path", true);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setOutputPath(chosenFile);
                LolaMainFrame.this.outputPathTextField.setText(chosenFile.toString());
            }
        }
    }

    private class outputPathAction
    extends AbstractAction
    implements DocumentListener {
        outputPathAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.outputPathTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setOutputPath(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class chooseCodonBiasAction
    extends AbstractAction {
        chooseCodonBiasAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseFile("Select Codon Bias Specification File", false);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setCodonBiasFile(chosenFile);
                LolaMainFrame.this.biasFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class codonBiasFileNameAction
    extends AbstractAction
    implements DocumentListener {
        codonBiasFileNameAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.biasFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setCodonBiasFile(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class uniquePeptidesCheckBoxAction
    implements ItemListener {
        private uniquePeptidesCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                LolaMainFrame.this.currentParamsCopy.setUniquePeptides(false);
            } else if (e.getStateChange() == 1) {
                LolaMainFrame.this.currentParamsCopy.setUniquePeptides(true);
            }
        }
    }

    private class chooseProfileAction
    extends AbstractAction {
        chooseProfileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseFile("Select Profile File", false);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setProfileFile(chosenFile);
                LolaMainFrame.this.profileFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class profileFileNameAction
    extends AbstractAction
    implements DocumentListener {
        profileFileNameAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.profileFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setProfileFile(file);
                LolaMainFrame.this.openProfileButton.setEnabled(true);
                String parentPath = file.getParent();
                if (parentPath != null) {
                    LolaMainFrame.this.outputPathTextField.setText(parentPath);
                }
                String fileName = file.getName() + ".LogoTree" + LolaResources.getFileExtension(LolaMainFrame.this.currentParamsCopy.getTreeImageFormat());
                LolaMainFrame.this.logoTreeOutputFilename.setText(fileName);
                LolaMainFrame.this.currentParamsCopy.setTreeFilename(fileName);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    class numericalTextVerifier
    extends InputVerifier {
        numericalTextVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                String text = ((JTextField)jComponent).getText();
                if (text != null) {
                    try {
                        int i = Integer.valueOf(text);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }

        public boolean shouldYieldFocus() {
            return false;
        }
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        JEditorPane pane;

        public HyperlinkAction(JEditorPane pane) {
            this.pane = pane;
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.openURL(event.getURL().toString());
            }
        }
    }
}

