/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.ui.LabelPlacerGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class IconSupport {
    private ImageIcon currentIcon;
    private ImageIcon[] icons;
    private HashMap sToI;
    private static Font defaultFont = new Font("SansSerif", 0, 8);

    public IconSupport() {
    }

    public IconSupport(Object o) {
        if (o instanceof Arrow) {
            this.init(o, (byte)2);
        } else if (o instanceof Byte) {
            this.init(o, (byte)5);
        } else if (o instanceof LineType) {
            this.init(o, (byte)1);
        }
    }

    public IconSupport(Object startObject, byte type) {
        this.init(startObject, type);
    }

    private void init(Object startObject, byte type) {
        this.icons = null;
        this.sToI = null;
        HashMap iToS = null;
        switch (type) {
            case 2: {
                this.icons = IconSupport.getArrowIcons();
                iToS = IconSupport.getArrowToStringHashMap(25);
                this.sToI = IconSupport.getStringToArrowHashMap(25);
                break;
            }
            case 5: {
                this.icons = IconSupport.getShapeIcons();
                iToS = IconSupport.getShapeByteToStringHashMap();
                this.sToI = IconSupport.getStringToShapeByteHashMap();
                break;
            }
            case 1: {
                this.icons = IconSupport.getLineTypeIcons();
                iToS = IconSupport.getLineTypeToStringHashMap();
                this.sToI = IconSupport.getStringToLineTypeHashMap();
            }
        }
        this.currentIcon = null;
        if (startObject != null) {
            int iconIndex;
            String ltName = (String)iToS.get(startObject);
            for (iconIndex = 0; iconIndex < this.icons.length && !this.icons[iconIndex].getDescription().equals(ltName); ++iconIndex) {
            }
            if (iconIndex == this.icons.length) {
                System.err.println("Icon for object " + startObject + " not found!");
                iconIndex = 0;
            }
            this.currentIcon = this.icons[iconIndex];
        }
    }

    public ImageIcon[] getIcons() {
        return this.icons;
    }

    public ImageIcon getCurrentIcon() {
        return this.currentIcon;
    }

    public Object getIconType(ImageIcon i) {
        if (i != null) {
            return this.sToI.get(i.getDescription());
        }
        return null;
    }

    public static HashMap getStringToArrowHashMap(int nodeSize) {
        HashMap<String, Arrow> h = new HashMap<String, Arrow>();
        h.put("NONE", Arrow.NONE);
        h.put("WHITE_DIAMOND", Arrow.WHITE_DIAMOND);
        h.put("BLACK_DIAMOND", Arrow.BLACK_DIAMOND);
        h.put("COLOR_DIAMOND", Arrow.COLOR_DIAMOND);
        h.put("WHITE_DELTA", Arrow.WHITE_DELTA);
        h.put("BLACK_DELTA", Arrow.BLACK_DELTA);
        h.put("COLOR_DELTA", Arrow.COLOR_DELTA);
        h.put("WHITE_T", Arrow.WHITE_T);
        h.put("BLACK_T", Arrow.BLACK_T);
        h.put("COLOR_T", Arrow.COLOR_T);
        h.put("WHITE_CIRCLE", Arrow.WHITE_CIRCLE);
        h.put("BLACK_CIRCLE", Arrow.BLACK_CIRCLE);
        h.put("COLOR_CIRCLE", Arrow.COLOR_CIRCLE);
        h.put("WHITE_ARROW", Arrow.WHITE_ARROW);
        h.put("BLACK_ARROW", Arrow.BLACK_ARROW);
        h.put("COLOR_ARROW", Arrow.COLOR_ARROW);
        return h;
    }

    public static HashMap getArrowToStringHashMap(int nodeSize) {
        HashMap<Arrow, String> h = new HashMap<Arrow, String>();
        h.put(Arrow.NONE, "NONE");
        h.put(Arrow.WHITE_DIAMOND, "WHITE_DIAMOND");
        h.put(Arrow.BLACK_DIAMOND, "BLACK_DIAMOND");
        h.put(Arrow.COLOR_DIAMOND, "COLOR_DIAMOND");
        h.put(Arrow.WHITE_DELTA, "WHITE_DELTA");
        h.put(Arrow.BLACK_DELTA, "BLACK_DELTA");
        h.put(Arrow.COLOR_DELTA, "COLOR_DELTA");
        h.put(Arrow.WHITE_CIRCLE, "WHITE_CIRCLE");
        h.put(Arrow.BLACK_CIRCLE, "BLACK_CIRCLE");
        h.put(Arrow.COLOR_CIRCLE, "COLOR_CIRCLE");
        h.put(Arrow.WHITE_T, "WHITE_T");
        h.put(Arrow.BLACK_T, "BLACK_T");
        h.put(Arrow.COLOR_T, "COLOR_T");
        h.put(Arrow.WHITE_ARROW, "WHITE_ARROW");
        h.put(Arrow.BLACK_ARROW, "BLACK_ARROW");
        h.put(Arrow.COLOR_ARROW, "COLOR_ARROW");
        return h;
    }

    public static ImageIcon[] getArrowIcons() {
        ImageIcon[] arrowIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/arrow_none.jpg"), "NONE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/WHITE_DIAMOND.jpg"), "WHITE_DIAMOND"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/BLACK_DIAMOND.jpg"), "BLACK_DIAMOND"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_DIAMOND.jpg"), "COLOR_DIAMOND"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/WHITE_DELTA.jpg"), "WHITE_DELTA"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/BLACK_DELTA.jpg"), "BLACK_DELTA"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_DELTA.jpg"), "COLOR_DELTA"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/WHITE_CIRCLE.jpg"), "WHITE_CIRCLE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/BLACK_CIRCLE.jpg"), "BLACK_CIRCLE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_CIRCLE.jpg"), "COLOR_CIRCLE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/WHITE_ARROW.jpg"), "WHITE_ARROW"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/BLACK_ARROW.jpg"), "BLACK_ARROW"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_ARROW.jpg"), "COLOR_ARROW"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/WHITE_T.jpg"), "WHITE_T"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/BLACK_T.jpg"), "BLACK_T"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_T.jpg"), "COLOR_T")};
        return arrowIcons;
    }

    public static HashMap getStringToShapeByteHashMap() {
        HashMap<String, Byte> h = new HashMap<String, Byte>();
        h.put("ELLIPSE", new Byte(8));
        h.put("ROUND_RECT", new Byte(1));
        h.put("RECTANGLE", new Byte(0));
        h.put("DIAMOND", new Byte(7));
        h.put("HEXAGON", new Byte(9));
        h.put("OCTAGON", new Byte(10));
        h.put("PARALLELOGRAM", new Byte(6));
        h.put("TRIANGLE", new Byte(5));
        return h;
    }

    public static HashMap getShapeByteToStringHashMap() {
        HashMap<Byte, String> h = new HashMap<Byte, String>();
        h.put(new Byte(8), "ELLIPSE");
        h.put(new Byte(1), "ROUND_RECT");
        h.put(new Byte(0), "RECTANGLE");
        h.put(new Byte(7), "DIAMOND");
        h.put(new Byte(9), "HEXAGON");
        h.put(new Byte(10), "OCTAGON");
        h.put(new Byte(6), "PARALLELOGRAM");
        h.put(new Byte(5), "TRIANGLE");
        return h;
    }

    public static ImageIcon[] getShapeIcons() {
        ImageIcon[] shapeIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("images/ellipse.jpg"), "ELLIPSE"), new ImageIcon(IconSupport.locateImage("images/round_rect.jpg"), "ROUND_RECT"), new ImageIcon(IconSupport.locateImage("images/rect.jpg"), "RECTANGLE"), new ImageIcon(IconSupport.locateImage("images/diamond.jpg"), "DIAMOND"), new ImageIcon(IconSupport.locateImage("images/hexagon.jpg"), "HEXAGON"), new ImageIcon(IconSupport.locateImage("images/octagon.jpg"), "OCTAGON"), new ImageIcon(IconSupport.locateImage("images/parallelogram.jpg"), "PARALLELOGRAM"), new ImageIcon(IconSupport.locateImage("images/triangle.jpg"), "TRIANGLE")};
        return shapeIcons;
    }

    public static HashMap getStringToLineTypeHashMap() {
        HashMap<String, LineType> h = new HashMap<String, LineType>();
        h.put("DASHED_1", LineType.DASHED_1);
        h.put("DASHED_2", LineType.DASHED_2);
        h.put("DASHED_3", LineType.DASHED_3);
        h.put("DASHED_4", LineType.DASHED_4);
        h.put("DASHED_5", LineType.DASHED_5);
        h.put("LINE_1", LineType.LINE_1);
        h.put("LINE_2", LineType.LINE_2);
        h.put("LINE_3", LineType.LINE_3);
        h.put("LINE_4", LineType.LINE_4);
        h.put("LINE_5", LineType.LINE_5);
        h.put("LINE_6", LineType.LINE_6);
        h.put("LINE_7", LineType.LINE_7);
        return h;
    }

    public static HashMap getLineTypeToStringHashMap() {
        HashMap<LineType, String> h = new HashMap<LineType, String>();
        h.put(LineType.DASHED_1, "DASHED_1");
        h.put(LineType.DASHED_2, "DASHED_2");
        h.put(LineType.DASHED_3, "DASHED_3");
        h.put(LineType.DASHED_4, "DASHED_4");
        h.put(LineType.DASHED_5, "DASHED_5");
        h.put(LineType.LINE_1, "LINE_1");
        h.put(LineType.LINE_2, "LINE_2");
        h.put(LineType.LINE_3, "LINE_3");
        h.put(LineType.LINE_4, "LINE_4");
        h.put(LineType.LINE_5, "LINE_5");
        h.put(LineType.LINE_6, "LINE_6");
        h.put(LineType.LINE_7, "LINE_7");
        return h;
    }

    public static ImageIcon[] getLineTypeIcons() {
        ImageIcon[] lineTypeIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("images/line_1.jpg"), "LINE_1"), new ImageIcon(IconSupport.locateImage("images/line_2.jpg"), "LINE_2"), new ImageIcon(IconSupport.locateImage("images/line_3.jpg"), "LINE_3"), new ImageIcon(IconSupport.locateImage("images/line_4.jpg"), "LINE_4"), new ImageIcon(IconSupport.locateImage("images/line_5.jpg"), "LINE_5"), new ImageIcon(IconSupport.locateImage("images/line_6.jpg"), "LINE_6"), new ImageIcon(IconSupport.locateImage("images/line_7.jpg"), "LINE_7"), new ImageIcon(IconSupport.locateImage("images/dashed_1.jpg"), "DASHED_1"), new ImageIcon(IconSupport.locateImage("images/dashed_2.jpg"), "DASHED_2"), new ImageIcon(IconSupport.locateImage("images/dashed_3.jpg"), "DASHED_3"), new ImageIcon(IconSupport.locateImage("images/dashed_4.jpg"), "DASHED_4"), new ImageIcon(IconSupport.locateImage("images/dashed_5.jpg"), "DASHED_5")};
        return lineTypeIcons;
    }

    private static URL locateImage(String imageFilename) {
        IconSupport is = new IconSupport();
        return is.getClass().getResource(imageFilename);
    }

    public static ImageIcon getColorIcon(Color c) {
        int size = 30;
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setPaint(c);
        g2.fillRect(0, 0, size, size);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeWidthIcon(Double d) {
        int w = d.intValue();
        int bound = 4;
        int edgeHeight = 4;
        int height = 30;
        String s = Integer.toString(w);
        BufferedImage bi = new BufferedImage(w + bound + bound, height, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        int stringWidth = g2.getFontMetrics().stringWidth(s);
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, w + bound + bound, height);
        g2.setPaint(Color.black);
        g2.drawLine(bound, height / 2 + edgeHeight, bound, height / 2 - edgeHeight);
        g2.drawLine(w + bound, height / 2 + edgeHeight, w + bound, height / 2 - edgeHeight);
        g2.drawLine(bound, height / 2, w + bound, height / 2);
        g2.setPaint(Color.black);
        g2.drawString(s, w / 2 + bound - stringWidth / 2, height / 2 - edgeHeight);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeHeightIcon(Double d) {
        int h = d.intValue();
        int bound = 4;
        int edgeWidth = 4;
        int width = 40;
        String s = Integer.toString(h);
        BufferedImage bi = new BufferedImage(width, h + bound + bound, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        int stringHeight = g2.getFontMetrics().getMaxAscent();
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, width, h + bound + bound);
        g2.setPaint(Color.black);
        g2.drawLine(bound, bound, bound + edgeWidth + edgeWidth, bound);
        g2.drawLine(bound, h + bound, bound + edgeWidth + edgeWidth, h + bound);
        g2.drawLine(bound + edgeWidth, bound, bound + edgeWidth, h + bound);
        g2.setPaint(Color.black);
        g2.drawString(s, bound + edgeWidth + edgeWidth, (h + bound + bound) / 2 + stringHeight / 2);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeSizeIcon(Double d) {
        int size = d.intValue();
        int bound = 4;
        String s = Integer.toString(size);
        BufferedImage bi = new BufferedImage(size + bound + bound, size + bound + bound, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, size + bound + bound, size + bound + bound);
        g2.setPaint(Color.black);
        g2.drawLine(bound, bound, bound, size + bound);
        g2.drawLine(bound, size + bound, size + bound, size + bound);
        g2.setPaint(Color.black);
        g2.drawString(s, bound + bound, size);
        return new ImageIcon(bi);
    }

    public static ImageIcon getLabelPositionIcon(LabelPosition pos) {
        int size = 60;
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D g2 = bi.createGraphics();
        LabelPlacerGraphic lp = new LabelPlacerGraphic(pos, size, false);
        lp.paint(g2);
        return new ImageIcon(bi);
    }
}

