/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class TypedProperties
extends Properties {
    public static final String DEFAULT_DELIMITERS = ",;\t";

    public TypedProperties() {
    }

    public TypedProperties(Properties defaults) {
        super(defaults);
    }

    public void load(String fileName) throws FileNotFoundException, IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName not null");
        }
        this.load(new BufferedInputStream(new FileInputStream(fileName)));
    }

    public void load(Class clazz, String resourceName) throws IOException {
        InputStream is = null;
        if (clazz == null) {
            is = ClassLoader.getSystemResourceAsStream(resourceName);
            if (is == null) {
                throw new IllegalArgumentException("system reource " + resourceName + " must exist");
            }
        } else {
            is = clazz.getResourceAsStream(resourceName);
            if (is == null) {
                throw new IllegalArgumentException("resource " + resourceName + " associated with class " + clazz + " must exist");
            }
        }
        this.load(is);
    }

    public Integer getPropertyAsInteger(String key) throws NumberFormatException {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        return new Integer(v);
    }

    public Long getPropertyAsLong(String key) throws NumberFormatException {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        return new Long(v);
    }

    public Double getPropertyAsDouble(String key) throws NumberFormatException {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        return new Double(v);
    }

    public Boolean getPropertyAsBoolean(String key) throws RuntimeException {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (v.equalsIgnoreCase("false") || v.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("property value " + v + " is not parseable as a boolean");
    }

    public List getPropertyAsStringList(String key, String delims) {
        if (delims == null || delims.length() == 0) {
            throw new IllegalArgumentException("delims != null && delims.length() > 0");
        }
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        if ((v = v.trim()).length() > 0) {
            StringTokenizer st = new StringTokenizer(v, delims, false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token == null || token.length() <= 0) continue;
                l.add(token);
            }
        }
        return l;
    }

    public List getPropertyAsStringList(String key) {
        return this.getPropertyAsStringList(key, DEFAULT_DELIMITERS);
    }

    public String toString() {
        return "TypedProperties";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int hc = super.hashCode();
        return hc;
    }

    public Object clone() {
        TypedProperties o = (TypedProperties)super.clone();
        return o;
    }
}

