/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.biojava.utils.xml.XMLWriter;

public class PrettyXMLWriter
implements XMLWriter {
    private int indentUnit = 2;
    private PrintWriter writer;
    private boolean isOpeningTag = false;
    private boolean afterNewline = true;
    private int indent = 0;
    private Map namespacePrefixes = new HashMap();
    private int namespaceSeed = 0;
    private LinkedList namespaceBindings = new LinkedList();
    private List namespacesDeclared = new ArrayList();

    public PrettyXMLWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void declareNamespace(String nsURI, String prefixHint) throws IOException {
        if (!this.namespacePrefixes.containsKey(nsURI)) {
            if (this.isOpeningTag) {
                String prefix = this.allocPrefix(nsURI);
                this.attribute("xmlns:" + prefix, nsURI);
            } else {
                this.namespacesDeclared.add(nsURI);
            }
        }
    }

    private void handleDeclaredNamespaces() throws IOException {
        if (this.namespacesDeclared.size() == 0) {
            Iterator nsi = this.namespacesDeclared.iterator();
            while (nsi.hasNext()) {
                String nsURI = (String)nsi.next();
                if (this.namespacePrefixes.containsKey(nsURI)) continue;
                String prefix = this.allocPrefix(nsURI);
                this.attribute("xmlns:" + prefix, nsURI);
            }
            this.namespacesDeclared.clear();
        }
    }

    protected void writeIndent() throws IOException {
        for (int i = 0; i < this.indent * this.indentUnit; ++i) {
            this.writer.write(32);
        }
    }

    private void _openTag() throws IOException {
        if (this.isOpeningTag) {
            this.writer.println('>');
            this.afterNewline = true;
        }
        if (this.afterNewline) {
            this.writeIndent();
        }
        ++this.indent;
        this.isOpeningTag = true;
        this.afterNewline = false;
        this.namespaceBindings.add(null);
    }

    private String allocPrefix(String nsURI) {
        String prefix = "ns" + ++this.namespaceSeed;
        this.namespacePrefixes.put(nsURI, prefix);
        ArrayList<String> bindings = (ArrayList<String>)this.namespaceBindings.getLast();
        if (bindings == null) {
            bindings = new ArrayList<String>();
            this.namespaceBindings.removeLast();
            this.namespaceBindings.add(bindings);
        }
        bindings.add(nsURI);
        return prefix;
    }

    public void openTag(String nsURI, String localName) throws IOException {
        this._openTag();
        boolean alloced = false;
        String prefix = (String)this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            prefix = this.allocPrefix(nsURI);
            alloced = true;
        }
        this.writer.print('<');
        this.writer.print(prefix);
        this.writer.print(':');
        this.writer.print(localName);
        if (alloced) {
            this.attribute("xmlns:" + prefix, nsURI);
        }
        this.handleDeclaredNamespaces();
    }

    public void openTag(String qName) throws IOException {
        this._openTag();
        this.writer.print('<');
        this.writer.print(qName);
        this.handleDeclaredNamespaces();
    }

    public void attribute(String nsURI, String localName, String value) throws IOException {
        if (!this.isOpeningTag) {
            throw new IOException("attributes must follow an openTag");
        }
        String prefix = (String)this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            prefix = this.allocPrefix(nsURI);
            this.attribute("xmlns:" + prefix, nsURI);
        }
        this.writer.print(' ');
        this.writer.print(prefix);
        this.writer.print(':');
        this.writer.print(localName);
        this.writer.print("=\"");
        this.printAttributeValue(value);
        this.writer.print('\"');
    }

    public void attribute(String qName, String value) throws IOException {
        if (!this.isOpeningTag) {
            throw new IOException("attributes must follow an openTag");
        }
        this.writer.print(' ');
        this.writer.print(qName);
        this.writer.print("=\"");
        this.printAttributeValue(value);
        this.writer.print('\"');
    }

    private void _closeTag() {
        this.isOpeningTag = false;
        this.afterNewline = true;
        List hereBindings = (List)this.namespaceBindings.removeLast();
        if (hereBindings != null) {
            Iterator bi = hereBindings.iterator();
            while (bi.hasNext()) {
                this.namespacePrefixes.remove(bi.next());
            }
        }
    }

    public void closeTag(String nsURI, String localName) throws IOException {
        String prefix = (String)this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            throw new IOException("Assertion failed: unknown namespace when closing tag");
        }
        --this.indent;
        if (this.isOpeningTag) {
            this.writer.println(" />");
        } else {
            if (this.afterNewline) {
                this.writeIndent();
            }
            this.writer.print("</");
            this.writer.print(prefix);
            this.writer.print(':');
            this.writer.print(localName);
            this.writer.println('>');
        }
        this._closeTag();
    }

    public void closeTag(String qName) throws IOException {
        --this.indent;
        if (this.isOpeningTag) {
            this.writer.println(" />");
        } else {
            if (this.afterNewline) {
                this.writeIndent();
            }
            this.writer.print("</");
            this.writer.print(qName);
            this.writer.println('>');
        }
        this._closeTag();
    }

    public void println(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.println('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
        this.writer.println();
        this.afterNewline = true;
    }

    public void print(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.print('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
        this.afterNewline = false;
    }

    public void printRaw(String data) throws IOException {
        this.writer.println(data);
    }

    protected void printChars(String data) throws IOException {
        if (data == null) {
            this.printChars("null");
            return;
        }
        for (int pos = 0; pos < data.length(); ++pos) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&') {
                this.numericalEntity(c);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void printAttributeValue(String data) throws IOException {
        if (data == null) {
            this.printAttributeValue("null");
            return;
        }
        for (int pos = 0; pos < data.length(); ++pos) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                this.numericalEntity(c);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void numericalEntity(char c) throws IOException {
        this.writer.print("&#");
        this.writer.print((int)c);
        this.writer.print(';');
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

