/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SmallMap;

public interface AnnotationType {
    public static final AnnotationType ANY = new Impl(PropertyConstraint.ANY, CardinalityConstraint.ANY);
    public static final AnnotationType NONE = new Impl(PropertyConstraint.NONE, CardinalityConstraint.NONE);

    public boolean instanceOf(Annotation var1);

    public boolean subTypeOf(AnnotationType var1);

    public CollectionConstraint getConstraint(Object var1);

    public void setConstraints(Object var1, PropertyConstraint var2, Location var3);

    public void setConstraint(Object var1, CollectionConstraint var2);

    public void setDefaultConstraints(PropertyConstraint var1, Location var2);

    public void setDefaultConstraint(CollectionConstraint var1);

    public CollectionConstraint getDefaultConstraint();

    public Set getProperties();

    public void setProperty(Annotation var1, Object var2, Object var3) throws ChangeVetoException;

    public void addProperty(Annotation var1, Object var2, Object var3) throws ChangeVetoException;

    public Collection getProperty(Annotation var1, Object var2) throws ChangeVetoException;

    public void removeProperty(Annotation var1, Object var2, Object var3) throws ChangeVetoException;

    public void setComment(String var1);

    public String getComment();

    public void setComment(Object var1, String var2);

    public String getComment(Object var1);

    public static class Impl
    extends Abstract {
        private Map cons = new SmallMap();
        private CollectionConstraint unknown = CollectionConstraint.ANY;
        private String comment = "";
        private Map comments = new SmallMap();

        public Impl() {
        }

        public Impl(PropertyConstraint defaultPC, Location defaultCC) {
            this();
            this.setDefaultConstraints(defaultPC, defaultCC);
        }

        public Impl(CollectionConstraint unknown) {
            this();
            this.setDefaultConstraint(unknown);
        }

        public void setDefaultConstraint(CollectionConstraint cc) {
            this.unknown = cc;
        }

        public CollectionConstraint getDefaultConstraint() {
            return this.unknown;
        }

        public CollectionConstraint getConstraint(Object key) {
            CollectionConstraint pc = (CollectionConstraint)this.cons.get(key);
            if (pc == null) {
                pc = this.unknown;
            }
            return pc;
        }

        public void setConstraint(Object key, CollectionConstraint cc) {
            this.cons.put(key, cc);
        }

        public Set getProperties() {
            return this.cons.keySet();
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(Object key, String comment) {
            this.comments.put(key, comment);
        }

        public String getComment(Object key) {
            return (String)this.comments.get(key);
        }
    }

    public static abstract class Abstract
    implements AnnotationType {
        public void setConstraints(Object key, PropertyConstraint pc, Location cc) {
            this.setConstraint(key, new CollectionConstraint.AllValuesIn(pc, cc));
        }

        public void setDefaultConstraints(PropertyConstraint pc, Location cc) {
            this.setDefaultConstraint(new CollectionConstraint.AllValuesIn(pc, cc));
        }

        public boolean instanceOf(Annotation ann) {
            HashSet props = new HashSet();
            props.addAll(this.getProperties());
            props.addAll(ann.keys());
            Iterator i = this.getProperties().iterator();
            while (i.hasNext()) {
                Object value;
                Object key = i.next();
                CollectionConstraint con = this.getConstraint(key);
                if (con.accept(value = ann.containsProperty(key) ? ann.getProperty(key) : Collections.EMPTY_SET)) continue;
                return false;
            }
            return true;
        }

        public final void setProperty(Annotation ann, Object property, Object value) throws ChangeVetoException {
            CollectionConstraint cons = this.getConstraint(property);
            if (!cons.accept(value)) {
                throw new ChangeVetoException("Setting property " + property + " to " + value + " would violate constraints in " + cons);
            }
            ann.setProperty(property, value);
        }

        public final Collection getProperty(Annotation ann, Object property) throws ChangeVetoException {
            Object val;
            Collection<Object> vals = null;
            vals = !ann.containsProperty(property) ? Collections.EMPTY_SET : ((val = ann.getProperty(property)) instanceof Collection ? (Collection)val : Collections.singleton(val));
            return vals;
        }

        public final void addProperty(Annotation ann, Object key, Object value) throws ChangeVetoException {
            Collection<Object> oldValue;
            CollectionConstraint cons = this.getConstraint(key);
            if (ann.containsProperty(key)) {
                Object ov = ann.getProperty(key);
                if (ov instanceof Collection) {
                    oldValue = (Collection)ov;
                } else {
                    oldValue = new ArrayList();
                    oldValue.add(ov);
                }
            } else {
                oldValue = new ArrayList();
            }
            if (!cons.validateAddValue(oldValue, value)) {
                throw new ChangeVetoException("Adding value " + value + " to " + key + " would violate constraints");
            }
            oldValue.add(value);
            ann.setProperty(key, oldValue);
        }

        public final void removeProperty(Annotation ann, Object key, Object value) throws ChangeVetoException {
            Collection<Object> oldValue;
            CollectionConstraint cons = this.getConstraint(key);
            if (ann.containsProperty(key)) {
                Object ov = ann.getProperty(key);
                if (ov instanceof Collection) {
                    oldValue = (Collection)ov;
                } else {
                    oldValue = new ArrayList();
                    oldValue.add(ov);
                }
            } else {
                oldValue = new ArrayList();
            }
            if (!oldValue.contains(value)) {
                throw new ChangeVetoException("Property " + key + " does not have value " + value);
            }
            if (cons.validateRemoveValue(oldValue, value)) {
                oldValue.remove(value);
                if (oldValue.size() > 0) {
                    ann.setProperty(key, oldValue);
                } else {
                    ann.removeProperty(key);
                }
            } else {
                throw new ChangeVetoException("Adding value " + value + " to " + key + " would violate constraints");
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("AnnotationType: " + this.getComment() + " {");
            Iterator i = this.getProperties().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                CollectionConstraint cc = this.getConstraint(key);
                sb.append(" [, " + cc + " " + key + "]");
            }
            sb.append(" [*, " + this.getDefaultConstraint() + "]");
            sb.append(" }");
            return sb.toString();
        }

        public boolean subTypeOf(AnnotationType subType) {
            HashSet props = new HashSet();
            props.addAll(this.getProperties());
            props.addAll(subType.getProperties());
            Iterator i = props.iterator();
            while (i.hasNext()) {
                CollectionConstraint subPC;
                Object key = i.next();
                CollectionConstraint thisPC = this.getConstraint(key);
                if (thisPC.subConstraintOf(subPC = subType.getConstraint(key))) continue;
                return false;
            }
            return true;
        }
    }
}

