/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CytoscapeInit;
import cytoscape.actions.SaveSessionAction;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesImpl;
import cytoscape.data.ExpressionData;
import cytoscape.data.ImportHandler;
import cytoscape.data.readers.BookmarkReader;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.data.servers.OntologyServer;
import cytoscape.ding.CyGraphLOD;
import cytoscape.ding.DingNetworkView;
import cytoscape.giny.CytoscapeFingRootGraph;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.FileUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.VisualMappingManager;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.xml.bind.JAXBException;

public abstract class Cytoscape {
    public static String ATTRIBUTES_CHANGED = "ATTRIBUTES_CHANGED";
    public static String NETWORK_CREATED = "NETWORK_CREATED";
    public static String DATASERVER_CHANGED = "DATASERVER_CHANGED";
    public static String EXPRESSION_DATA_LOADED = "EXPRESSION_DATA_LOADED";
    public static String NETWORK_DESTROYED = "NETWORK_DESTROYED";
    public static String CYTOSCAPE_INITIALIZED = "CYTOSCAPE_INITIALIZED";
    public static String CYTOSCAPE_EXIT = "CYTOSCAPE_EXIT";
    public static String SESSION_SAVED = "SESSION_SAVED";
    public static String SESSION_LOADED = "SESSION_LOADED";
    public static String VIZMAP_RESTORED = "VIZMAP_RESTORED";
    public static String SAVE_VIZMAP_PROPS = "SAVE_VIZMAP_PROPS";
    public static String VIZMAP_LOADED = "VIZMAP_LOADED";
    public static final String SAVE_PLUGIN_STATE = "SAVE_PLUGIN_STATE";
    public static final String RESTORE_PLUGIN_STATE = "RESTORE_PLUGIN_STATE";
    public static final String NETWORK_MODIFIED = "NETWORK_MODIFIED";
    public static final String NETWORK_SAVED = "NETWORK_SAVED";
    public static final String NETWORK_LOADED = "NETWORK_LOADED";
    public static final String ONTOLOGY_ROOT = "ONTOLOGY_ROOT";
    public static final String PREFERENCE_MODIFIED = "PREFERENCE_MODIFIED";
    public static final String PREFERENCES_UPDATED = "PREFERENCES_UPDATED";
    public static int FILE_BY_SUFFIX = 0;
    public static int FILE_GML = 1;
    public static int FILE_SIF = 2;
    public static int FILE_SBML = 3;
    public static int FILE_XGMML = 4;
    public static int FILE_BIOPAX = 5;
    public static int FILE_PSI_MI = 6;
    public static final int SELECT_NODES_ONLY = 1;
    public static final int SELECT_EDGES_ONLY = 2;
    public static final int SELECT_NODES_AND_EDGES = 3;
    private static int currentSelectionMode = 1;
    public static final int SESSION_NEW = 0;
    public static final int SESSION_OPENED = 1;
    public static final int SESSION_CHANGED = 2;
    public static final int SESSION_CLOSED = 3;
    private static int sessionState = 0;
    private static BioDataServer bioDataServer;
    private static OntologyServer ontologyServer;
    private static String species;
    public static final String READER_CLIENT_KEY = "reader_client_key";
    private static boolean squiggleEnabled;
    protected static CytoscapeRootGraph cytoscapeRootGraph;
    private static CyAttributes nodeAttributes;
    private static CyAttributes edgeAttributes;
    private static CyAttributes networkAttributes;
    private static CyAttributes ontologyAttributes;
    protected static ExpressionData expressionData;
    protected static Object pcsO;
    protected static SwingPropertyChangeSupport pcs;
    protected static Object pcs2;
    protected static PropertyChangeSupport newPcs;
    protected static Map networkViewMap;
    protected static Map networkMap;
    protected static CytoscapeDesktop defaultDesktop;
    protected static String currentNetworkID;
    protected static String currentNetworkViewID;
    protected static String ontologyRootID;
    private static String currentSessionFileName;
    private static Bookmarks bookmarks;
    protected static CyNetwork nullNetwork;
    private static ImportHandler importHandler;
    protected static CyNetworkView nullNetworkView;
    protected static VisualMappingManager VMM;

    public static ImportHandler getImportHandler() {
        return importHandler;
    }

    public static CyNetworkView getNullNetworkView() {
        return nullNetworkView;
    }

    public static CyNetwork getNullNetwork() {
        return nullNetwork;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exit(int returnVal) {
        int mode = CytoscapeInit.getCyInitParams().getMode();
        if (mode == 4 || mode == 1) {
            if (!Cytoscape.confirmQuit()) return;
            try {
                Cytoscape.firePropertyChange(CYTOSCAPE_EXIT, null, "now");
            }
            catch (Exception e) {
                System.out.println("Errors on close, closed anyways.");
            }
            System.out.println("Cytoscape Exiting....");
            if (mode == 4) {
                Cytoscape.getDesktop().dispose();
                return;
            } else {
                System.exit(returnVal);
            }
            return;
        }
        System.out.println("Cytoscape Exiting....");
        System.exit(returnVal);
    }

    private static boolean confirmQuit() {
        String msg = "Do you want to save your session?";
        int networkCount = Cytoscape.getNetworkSet().size();
        if (networkCount == 0) {
            return true;
        }
        Object[] options = new Object[]{"Yes, save and quit", "No, just quit", "Cancel"};
        int n = JOptionPane.showOptionDialog(Cytoscape.getDesktop(), "Do you want to save your session?", "Save Networks Before Quitting?", 0, 3, null, options, options[0]);
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            SaveSessionAction saveAction = new SaveSessionAction();
            saveAction.actionPerformed(null);
            if (Cytoscape.getCurrentSessionFileName() == null) {
                return Cytoscape.confirmQuit();
            }
            return true;
        }
        return false;
    }

    public static SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return pcs;
    }

    public static PropertyChangeSupport getPropertyChangeSupport() {
        return newPcs;
    }

    public static VisualMappingManager getVisualMappingManager() {
        return VMM;
    }

    public static CytoscapeRootGraph getRootGraph() {
        if (cytoscapeRootGraph == null) {
            cytoscapeRootGraph = new CytoscapeFingRootGraph();
        }
        return cytoscapeRootGraph;
    }

    public static void ensureCapacity(int nodes, int edges) {
    }

    public static List getCyNodesList() {
        return Cytoscape.getRootGraph().nodesList();
    }

    public static List getCyEdgesList() {
        return Cytoscape.getRootGraph().edgesList();
    }

    public static CyNode getCyNode(String alias) {
        return Cytoscape.getCyNode(alias, false);
    }

    public static CyNode getCyNode(String nodeID, boolean create) {
        CyNode node = Cytoscape.getRootGraph().getNode(nodeID);
        if (node != null) {
            return node;
        }
        if (!create) {
            return null;
        }
        node = (CyNode)Cytoscape.getRootGraph().getNode(Cytoscape.getRootGraph().createNode());
        node.setIdentifier(nodeID);
        if (Cytoscape.getNodeAttributes().getStringAttribute(nodeID, "canonicalName") == null) {
            Cytoscape.getNodeAttributes().setAttribute(nodeID, "canonicalName", nodeID);
        }
        return node;
    }

    public static CyEdge getCyEdge(Node node_1, Node node_2, String attribute, Object attribute_value, boolean create) {
        return Cytoscape.getCyEdge(node_1, node_2, attribute, attribute_value, create, false);
    }

    public static CyEdge getCyEdge(Node source, Node target, String attribute, Object attribute_value, boolean create, boolean directed) {
        if (Cytoscape.getRootGraph().getEdgeCount() != 0) {
            int[] n1Edges = Cytoscape.getRootGraph().getAdjacentEdgeIndicesArray(source.getRootGraphIndex(), true, true, true);
            for (int i = 0; i < n1Edges.length; ++i) {
                CyEdge edge = (CyEdge)Cytoscape.getRootGraph().getEdge(n1Edges[i]);
                Object attValue = Cytoscape.private_getEdgeAttributeValue(edge, attribute);
                if (attValue == null || !attValue.equals(attribute_value)) continue;
                CyNode edgeTarget = (CyNode)edge.getTarget();
                CyNode edgeSource = (CyNode)edge.getSource();
                if (edgeTarget.getRootGraphIndex() == target.getRootGraphIndex() && edgeSource.getRootGraphIndex() == source.getRootGraphIndex()) {
                    return edge;
                }
                if (directed || edgeTarget.getRootGraphIndex() != source.getRootGraphIndex() || edgeSource.getRootGraphIndex() != target.getRootGraphIndex()) continue;
                return edge;
            }
        }
        if (create && attribute instanceof String && attribute.equals("interaction")) {
            CyEdge edge = (CyEdge)Cytoscape.getRootGraph().getEdge(Cytoscape.getRootGraph().createEdge(source, target));
            String edge_name = CyEdge.createIdentifier(source.getIdentifier(), (String)attribute_value, target.getIdentifier());
            edge.setIdentifier(edge_name);
            edgeAttributes.setAttribute(edge_name, "interaction", (String)attribute_value);
            return edge;
        }
        return null;
    }

    public static CyEdge getCyEdge(String source_alias, String edge_name, String target_alias, String interaction_type) {
        edge_name = Cytoscape.canonicalizeName(edge_name);
        CyEdge edge = Cytoscape.getRootGraph().getEdge(edge_name);
        if (edge != null) {
            return edge;
        }
        CyNode source = Cytoscape.getCyNode(source_alias);
        CyNode target = Cytoscape.getCyNode(target_alias);
        return Cytoscape.getCyEdge(source, target, "interaction", interaction_type, true, true);
    }

    private static Object private_getEdgeAttributeValue(Edge edge, String attribute) {
        CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
        String canonName = edge.getIdentifier();
        byte cyType = edgeAttrs.getType(attribute);
        if (cyType == 1) {
            return edgeAttrs.getBooleanAttribute(canonName, attribute);
        }
        if (cyType == 2) {
            return edgeAttrs.getDoubleAttribute(canonName, attribute);
        }
        if (cyType == 3) {
            return edgeAttrs.getIntegerAttribute(canonName, attribute);
        }
        if (cyType == 4) {
            return edgeAttrs.getStringAttribute(canonName, attribute);
        }
        if (cyType == -2) {
            return edgeAttrs.getListAttribute(canonName, attribute);
        }
        if (cyType == -3) {
            return edgeAttrs.getMapAttribute(canonName, attribute);
        }
        return null;
    }

    private static String canonicalizeName(String name) {
        String canonicalName = name;
        if (bioDataServer != null && (canonicalName = bioDataServer.getCanonicalName(species, name)) == null) {
            canonicalName = name;
        }
        return canonicalName;
    }

    public static void setSpecies() {
        species = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
    }

    public static CyNetwork getCurrentNetwork() {
        if (currentNetworkID == null || !Cytoscape.getNetworkMap().containsKey(currentNetworkID)) {
            return nullNetwork;
        }
        CyNetwork network = (CyNetwork)Cytoscape.getNetworkMap().get(currentNetworkID);
        return network;
    }

    public static Set getNetworkSet() {
        return new LinkedHashSet(((HashMap)Cytoscape.getNetworkMap()).values());
    }

    public static CyNetwork getNetwork(String id) {
        if (id != null && Cytoscape.getNetworkMap().containsKey(id)) {
            return (CyNetwork)Cytoscape.getNetworkMap().get(id);
        }
        return nullNetwork;
    }

    public static CyNetworkView getNetworkView(String network_id) {
        if (network_id == null || !Cytoscape.getNetworkViewMap().containsKey(network_id)) {
            return nullNetworkView;
        }
        CyNetworkView nview = (CyNetworkView)Cytoscape.getNetworkViewMap().get(network_id);
        return nview;
    }

    public static boolean viewExists(String network_id) {
        return Cytoscape.getNetworkViewMap().containsKey(network_id);
    }

    public static CyNetworkView getCurrentNetworkView() {
        if (currentNetworkViewID == null || !Cytoscape.getNetworkViewMap().containsKey(currentNetworkViewID)) {
            return nullNetworkView;
        }
        CyNetworkView nview = (CyNetworkView)Cytoscape.getNetworkViewMap().get(currentNetworkViewID);
        return nview;
    }

    public static CytoscapeDesktop getDesktop() {
        if (defaultDesktop == null) {
            defaultDesktop = new CytoscapeDesktop(CytoscapeDesktop.parseViewType(CytoscapeInit.getProperties().getProperty("viewType")));
        }
        return defaultDesktop;
    }

    public static void setCurrentNetwork(String id) {
        if (Cytoscape.getNetworkMap().containsKey(id)) {
            currentNetworkID = id;
        }
    }

    public static boolean setCurrentNetworkView(String id) {
        if (Cytoscape.getNetworkViewMap().containsKey(id)) {
            currentNetworkViewID = id;
            return true;
        }
        return false;
    }

    protected static Map getNetworkMap() {
        if (networkMap == null) {
            networkMap = new HashMap();
        }
        return networkMap;
    }

    public static Map getNetworkViewMap() {
        if (networkViewMap == null) {
            networkViewMap = new HashMap();
        }
        return networkViewMap;
    }

    public static void destroyNetwork(String network_id) {
        Cytoscape.destroyNetwork((CyNetwork)Cytoscape.getNetworkMap().get(network_id));
    }

    public static void destroyNetwork(CyNetwork network) {
        Cytoscape.destroyNetwork(network, false);
    }

    public static void destroyNetwork(CyNetwork network, boolean destroy_unique) {
        String networkId = network.getIdentifier();
        Cytoscape.firePropertyChange(NETWORK_DESTROYED, null, networkId);
        Map nmap = Cytoscape.getNetworkMap();
        nmap.remove(networkId);
        if (networkId.equals(currentNetworkID)) {
            if (nmap.size() <= 0) {
                currentNetworkID = null;
            } else {
                Iterator it = nmap.keySet().iterator();
                if (it.hasNext()) {
                    currentNetworkID = (String)it.next();
                }
            }
        }
        if (Cytoscape.viewExists(networkId)) {
            Cytoscape.destroyNetworkView(network);
        }
        if (destroy_unique) {
            boolean add;
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Edge> edges = new ArrayList<Edge>();
            Collection networks = networkMap.values();
            Iterator nodes_i = network.nodesIterator();
            Iterator edges_i = network.edgesIterator();
            while (nodes_i.hasNext()) {
                Node node = (Node)nodes_i.next();
                add = true;
                for (CyNetwork net : networks) {
                    if (!net.containsNode(node)) continue;
                    add = false;
                }
                if (!add) continue;
                nodes.add(node);
            }
            while (edges_i.hasNext()) {
                Edge edge = (Edge)edges_i.next();
                add = true;
                for (CyNetwork net : networks) {
                    if (!net.containsEdge(edge)) continue;
                    add = false;
                }
                if (!add) continue;
                edges.add(edge);
            }
            Cytoscape.getRootGraph().removeNodes(nodes);
            Cytoscape.getRootGraph().removeEdges(edges);
        }
        network = null;
        if (currentNetworkID != null && currentNetworkViewID == null) {
            Cytoscape.getDesktop().setFocus(currentNetworkID);
        }
    }

    public static void destroyNetworkView(CyNetworkView view) {
        String viewID = view.getIdentifier();
        Cytoscape.getNetworkViewMap().remove(viewID);
        if (viewID.equals(currentNetworkViewID)) {
            CyNetworkView newCurr;
            currentNetworkViewID = Cytoscape.getNetworkViewMap().size() <= 0 ? null : ((newCurr = (CyNetworkView)Cytoscape.getNetworkViewMap().get(currentNetworkID)) != null ? newCurr.getIdentifier() : null);
        }
        Cytoscape.firePropertyChange("NETWORK_VIEW_DESTROYED", null, view);
        view = null;
        if (currentNetworkID != null) {
            Cytoscape.getDesktop().setFocus(currentNetworkID);
        }
    }

    public static void destroyNetworkView(String network_view_id) {
        Cytoscape.destroyNetworkView((CyNetworkView)Cytoscape.getNetworkViewMap().get(network_view_id));
    }

    public static void destroyNetworkView(CyNetwork network) {
        Cytoscape.destroyNetworkView((CyNetworkView)Cytoscape.getNetworkViewMap().get(network.getIdentifier()));
    }

    protected static void addNetwork(CyNetwork network, String title, CyNetwork parent, boolean create_view) {
        Cytoscape.getNetworkMap().put(network.getIdentifier(), network);
        network.setTitle(title);
        String parentID = null;
        if (parent != null) {
            parentID = parent.getIdentifier();
        }
        Cytoscape.firePropertyChange(NETWORK_CREATED, parentID, network.getIdentifier());
        if (network.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold")) && create_view) {
            Cytoscape.createNetworkView(network);
        }
    }

    public static CyNetwork createNetwork(String title) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, null, true);
    }

    public static CyNetwork createNetwork(String title, boolean create_view) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, null, create_view);
    }

    public static CyNetwork createNetwork(String title, CyNetwork parent, boolean create_view) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, parent, create_view);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String title) {
        return Cytoscape.createNetwork(nodes, edges, title, null, true);
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String title) {
        return Cytoscape.createNetwork(nodes, edges, title, null, true);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String child_title, CyNetwork parent) {
        return Cytoscape.createNetwork(nodes, edges, child_title, parent, true);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String child_title, CyNetwork parent, boolean create_view) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, child_title, parent, create_view);
        return network;
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String child_title, CyNetwork parent) {
        return Cytoscape.createNetwork(nodes, edges, child_title, parent, true);
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String child_title, CyNetwork parent, boolean create_view) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, child_title, parent, create_view);
        return network;
    }

    public static CyNetwork createNetworkFromFile(String location) {
        return Cytoscape.createNetworkFromFile(location, true);
    }

    public static CyNetwork createNetworkFromFile(String loc, boolean create_view) {
        return Cytoscape.createNetwork(importHandler.getReader(loc), create_view, null);
    }

    public static CyNetwork createNetworkFromURL(URL url, boolean create_view) {
        return Cytoscape.createNetwork(importHandler.getReader(url), create_view, null);
    }

    public static CyNetwork createNetwork(String location, int file_type, boolean canonicalize, BioDataServer biodataserver, String species) {
        return Cytoscape.createNetworkFromFile(location, true);
    }

    public static CyNetwork createNetwork(GraphReader reader, boolean create_view, CyNetwork parent) {
        if (reader == null) {
            throw new RuntimeException("Couldn't read specified file.");
        }
        try {
            reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String title = reader.getNetworkName();
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        if (nodes == null) {
            System.err.println("reader returned null nodes");
        }
        if (edges == null) {
            System.err.println("reader returned null edges");
        }
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        network.putClientData(READER_CLIENT_KEY, reader);
        Cytoscape.addNetwork(network, title, parent, create_view);
        reader.doPostProcessing(network);
        return network;
    }

    public static CyAttributes getNodeAttributes() {
        return nodeAttributes;
    }

    public static CyAttributes getEdgeAttributes() {
        return edgeAttributes;
    }

    public static CyAttributes getNetworkAttributes() {
        return networkAttributes;
    }

    public static CyAttributes getOntologyAttributes() {
        return ontologyAttributes;
    }

    public static ExpressionData getExpressionData() {
        return expressionData;
    }

    public static void setExpressionData(ExpressionData expData) {
        expressionData = expData;
    }

    public static boolean loadExpressionData(String filename, boolean copy_atts) {
        try {
            expressionData = new ExpressionData(filename);
        }
        catch (Exception e) {
            System.err.println("Unable to Load Expression Data");
            String errString = "Unable to load expression data from " + filename;
            String title = "Load Expression Data";
        }
        if (copy_atts) {
            expressionData.copyToAttribs(Cytoscape.getNodeAttributes(), null);
            Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
        }
        Cytoscape.firePropertyChange(EXPRESSION_DATA_LOADED, null, expressionData);
        return true;
    }

    public static void loadAttributes(String[] nodeAttrLocations, String[] edgeAttrLocations, boolean canonicalize, BioDataServer bioDataServer, String species) {
        Cytoscape.loadAttributes(nodeAttrLocations, edgeAttrLocations);
    }

    public static void loadAttributes(String[] nodeAttrLocations, String[] edgeAttrLocations) {
        InputStreamReader reader;
        if (nodeAttrLocations != null) {
            for (int i = 0; i < nodeAttrLocations.length; ++i) {
                try {
                    reader = new InputStreamReader(FileUtil.getInputStream(nodeAttrLocations[i]));
                    CyAttributesReader.loadAttributes(nodeAttributes, reader);
                    Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Failure loading node attribute data: " + nodeAttrLocations[i] + "  because of:" + e.getMessage());
                }
            }
        }
        if (edgeAttrLocations != null) {
            for (int j = 0; j < edgeAttrLocations.length; ++j) {
                try {
                    reader = new InputStreamReader(FileUtil.getInputStream(edgeAttrLocations[j]));
                    CyAttributesReader.loadAttributes(edgeAttributes, reader);
                    Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Failure loading edge attribute data: " + edgeAttrLocations[j] + "  because of:" + e.getMessage());
                }
            }
        }
    }

    public static BioDataServer loadBioDataServer(String location) {
        try {
            bioDataServer = new BioDataServer(location);
        }
        catch (Exception e) {
            System.err.println("Could not Load BioDataServer from: " + location);
            return null;
        }
        return bioDataServer;
    }

    public static BioDataServer getBioDataServer() {
        return bioDataServer;
    }

    public static OntologyServer buildOntologyServer() {
        try {
            ontologyServer = new OntologyServer();
        }
        catch (Exception e) {
            System.err.println("Could not build OntologyServer.");
            e.printStackTrace();
            return null;
        }
        return ontologyServer;
    }

    public static OntologyServer getOntologyServer() {
        return ontologyServer;
    }

    public static CyNetworkView createNetworkView(CyNetwork network) {
        return Cytoscape.createNetworkView(network, network.getTitle());
    }

    public static CyNetworkView createNetworkView(CyNetwork network, String title) {
        if (network == nullNetwork) {
            return nullNetworkView;
        }
        if (Cytoscape.viewExists(network.getIdentifier())) {
            return Cytoscape.getNetworkView(network.getIdentifier());
        }
        DingNetworkView view = new DingNetworkView(network, title);
        view.setGraphLOD(new CyGraphLOD());
        view.setIdentifier(network.getIdentifier());
        Cytoscape.getNetworkViewMap().put(network.getIdentifier(), view);
        view.setTitle(network.getTitle());
        Cytoscape.setSelectionMode(currentSelectionMode, view);
        Cytoscape.firePropertyChange("NETWORK_VIEW_CREATED", null, view);
        if (network.getClientData(READER_CLIENT_KEY) != null) {
            ((GraphReader)network.getClientData(READER_CLIENT_KEY)).layout(Cytoscape.getNetworkView(network.getIdentifier()));
        } else {
            double distanceBetweenNodes = 80.0;
            int columns = (int)Math.sqrt(view.nodeCount());
            Iterator nodeViews = view.getNodeViewsIterator();
            double currX = 0.0;
            double currY = 0.0;
            int count = 0;
            while (nodeViews.hasNext()) {
                NodeView nView = (NodeView)nodeViews.next();
                nView.setOffset(currX, currY);
                if (++count == columns) {
                    count = 0;
                    currX = 0.0;
                    currY += distanceBetweenNodes;
                    continue;
                }
                currX += distanceBetweenNodes;
            }
        }
        Cytoscape.getCurrentNetworkView().fitContent();
        return view;
    }

    public static void firePropertyChange(String property_type, Object old_value, Object new_value) {
        PropertyChangeEvent e = new PropertyChangeEvent(pcsO, property_type, old_value, new_value);
        Cytoscape.getSwingPropertyChangeSupport().firePropertyChange(e);
        Cytoscape.getPropertyChangeSupport().firePropertyChange(e);
    }

    public static int getSelectionMode() {
        return currentSelectionMode;
    }

    public static void setSelectionMode(int selectionMode) {
        Map networkViewMap = Cytoscape.getNetworkViewMap();
        for (String network_id : networkViewMap.keySet()) {
            GraphView view = (GraphView)networkViewMap.get(network_id);
            Cytoscape.setSelectionMode(selectionMode, view);
        }
        currentSelectionMode = selectionMode;
    }

    public static void setSelectionMode(int selectionMode, GraphView view) {
        view.disableNodeSelection();
        view.disableEdgeSelection();
        switch (selectionMode) {
            case 1: {
                view.enableNodeSelection();
                break;
            }
            case 2: {
                view.enableEdgeSelection();
                break;
            }
            case 3: {
                view.enableNodeSelection();
                view.enableEdgeSelection();
            }
        }
    }

    public static String getCurrentSessionFileName() {
        return currentSessionFileName;
    }

    public static void setCurrentSessionFileName(String newName) {
        currentSessionFileName = newName;
    }

    public static void setSessionState(int state) {
        sessionState = state;
    }

    public static int getSessionstate() {
        return sessionState;
    }

    public static void createNewSession() {
        Set netSet = Cytoscape.getNetworkSet();
        for (CyNetwork net : netSet) {
            Cytoscape.destroyNetwork(net);
        }
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        String[] nodeAttrNames = nodeAttributes.getAttributeNames();
        for (int i = 0; i < nodeAttrNames.length; ++i) {
            nodeAttributes.deleteAttribute(nodeAttrNames[i]);
        }
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        String[] edgeAttrNames = edgeAttributes.getAttributeNames();
        for (int i = 0; i < edgeAttrNames.length; ++i) {
            edgeAttributes.deleteAttribute(edgeAttrNames[i]);
        }
        CyAttributes networkAttributes = Cytoscape.getNetworkAttributes();
        String[] networkAttrNames = networkAttributes.getAttributeNames();
        for (int i = 0; i < networkAttrNames.length; ++i) {
            networkAttributes.deleteAttribute(networkAttrNames[i]);
        }
        Cytoscape.setCurrentSessionFileName(null);
    }

    public static String getOntologyRootID() {
        return ontologyRootID;
    }

    public static void setOntologyRootID(String id) {
        ontologyRootID = id;
    }

    public static Bookmarks getBookmarks() throws JAXBException, IOException {
        if (bookmarks == null) {
            BookmarkReader reader = new BookmarkReader();
            reader.readBookmarks();
            bookmarks = reader.getBookmarks();
        }
        return bookmarks;
    }

    public static void setBookmarks(Bookmarks pBookmarks) {
        bookmarks = pBookmarks;
    }

    static {
        squiggleEnabled = false;
        nodeAttributes = new CyAttributesImpl();
        edgeAttributes = new CyAttributesImpl();
        networkAttributes = new CyAttributesImpl();
        ontologyAttributes = new CyAttributesImpl();
        pcsO = new Object();
        pcs = new SwingPropertyChangeSupport(pcsO);
        pcs2 = new Object();
        newPcs = new PropertyChangeSupport(pcs2);
        nullNetwork = Cytoscape.getRootGraph().createNetwork(new int[0], new int[0]);
        importHandler = new ImportHandler();
        nullNetworkView = new DingNetworkView(nullNetwork, "null");
        VMM = new VisualMappingManager(nullNetworkView);
    }
}

