/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.ding;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.layout.LayoutAlgorithm;
import cytoscape.view.CyEdgeView;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CyNodeView;
import cytoscape.view.FlagAndSelectionHandler;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapUI;
import ding.view.DGraphView;
import ding.view.EdgeContextMenuListener;
import ding.view.NodeContextMenuListener;
import giny.model.GraphPerspective;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DingNetworkView
extends DGraphView
implements CyNetworkView {
    private String title;
    private boolean vizmapEnabled = true;
    private HashMap clientData = new HashMap();
    private VisualStyle vs;

    public DingNetworkView(CyNetwork network, String title) {
        super((GraphPerspective)network);
        int i;
        this.title = title;
        int[] nodes = network.getNodeIndicesArray();
        int[] edges = network.getEdgeIndicesArray();
        for (i = 0; i < nodes.length; ++i) {
            this.addNodeView(nodes[i]);
        }
        for (i = 0; i < edges.length; ++i) {
            this.addEdgeView(edges[i]);
        }
        new FlagAndSelectionHandler(this.getNetwork().getFlagger(), this);
    }

    public void setVisualStyle(String vsName) {
        this.vs = Cytoscape.getVisualMappingManager().getCalculatorCatalog().getVisualStyle(vsName);
    }

    public VisualStyle getVisualStyle() {
        return this.vs;
    }

    public CyNetwork getNetwork() {
        return (CyNetwork)this.getGraphPerspective();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void redrawGraph(boolean layout, boolean vizmap) {
        Cytoscape.getVisualMappingManager().applyAppearances();
        this.updateView();
    }

    public CyNetworkView getView() {
        return this;
    }

    public VisualMappingManager getVizMapManager() {
        return null;
    }

    public VizMapUI getVizMapUI() {
        return null;
    }

    public void toggleVisualMapperEnabled() {
        this.vizmapEnabled = !this.vizmapEnabled;
    }

    public void setVisualMapperEnabled(boolean state) {
        this.vizmapEnabled = state;
    }

    public boolean getVisualMapperEnabled() {
        return this.vizmapEnabled;
    }

    public void putClientData(String data_name, Object data) {
        this.clientData.put(data_name, data);
    }

    public Collection getClientDataNames() {
        return this.clientData.keySet();
    }

    public Object getClientData(String data_name) {
        return this.clientData.get(data_name);
    }

    public boolean setSelected(CyNode[] nodes) {
        return this.setSelected(this.convertToViews(nodes));
    }

    private NodeView[] convertToViews(CyNode[] nodes) {
        NodeView[] views = new NodeView[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            views[i] = this.getNodeView(nodes[i]);
        }
        return views;
    }

    public boolean setSelected(NodeView[] node_views) {
        for (int i = 0; i < node_views.length; ++i) {
            node_views[i].select();
        }
        return true;
    }

    public boolean applyVizMap(CyEdge edge) {
        return this.applyVizMap(this.getEdgeView(edge));
    }

    public boolean applyVizMap(EdgeView edge_view) {
        return this.applyVizMap(edge_view, (VisualStyle)this.getClientData("VISUAL_STYLE"));
    }

    public boolean applyVizMap(CyNode node) {
        return this.applyVizMap(this.getNodeView(node));
    }

    public boolean applyVizMap(NodeView node_view) {
        return this.applyVizMap(node_view, (VisualStyle)this.getClientData("VISUAL_STYLE"));
    }

    public boolean applyVizMap(CyEdge edge, VisualStyle style) {
        return this.applyVizMap(this.getEdgeView(edge), style);
    }

    public boolean applyVizMap(EdgeView edge_view, VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        Cytoscape.getVisualMappingManager().vizmapEdge(edge_view, this);
        Cytoscape.getDesktop().setVisualStyle(old_style);
        return true;
    }

    public boolean applyVizMap(CyNode node, VisualStyle style) {
        return this.applyVizMap(this.getNodeView(node), style);
    }

    public boolean applyVizMap(NodeView node_view, VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        Cytoscape.getVisualMappingManager().vizmapNode(node_view, this);
        Cytoscape.getDesktop().setVisualStyle(old_style);
        return true;
    }

    public boolean setSelected(CyEdge[] edges) {
        return this.setSelected(this.convertToViews(edges));
    }

    private EdgeView[] convertToViews(CyEdge[] edges) {
        EdgeView[] views = new EdgeView[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            views[i] = this.getEdgeView(edges[i]);
        }
        return views;
    }

    public boolean setSelected(EdgeView[] edge_views) {
        for (int i = 0; i < edge_views.length; ++i) {
            edge_views[i].select();
        }
        return true;
    }

    public void applyVizmapper(VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        this.redrawGraph(false, true);
    }

    public void applyLayout(LayoutAlgorithm layout) {
        layout.doLayout();
    }

    public void applyLockedLayout(LayoutAlgorithm layout, CyNode[] nodes, CyEdge[] edges) {
        layout.lockNodes(this.convertToViews(nodes));
        layout.doLayout();
    }

    public void applyLayout(LayoutAlgorithm layout, CyNode[] nodes, CyEdge[] edges) {
        layout.lockNodes(this.getInverseViews(this.convertToViews(nodes)));
        layout.doLayout();
    }

    private NodeView[] getInverseViews(NodeView[] given) {
        NodeView[] inverse = new NodeView[this.getNodeViewCount() - given.length];
        List node_views = this.getNodeViewsList();
        int count = 0;
        Iterator i = node_views.iterator();
        Arrays.sort(given);
        while (i.hasNext()) {
            NodeView view = (NodeView)i.next();
            if (Arrays.binarySearch(given, view) >= 0) continue;
            inverse[count] = view;
            ++count;
        }
        return inverse;
    }

    public List getNodeViewsList() {
        ArrayList<NodeView> list = new ArrayList<NodeView>(this.getNodeViewCount());
        int[] gp_indices = this.getGraphPerspective().getNodeIndicesArray();
        for (int i = 0; i < gp_indices.length; ++i) {
            list.add(this.getNodeView(gp_indices[i]));
        }
        return list;
    }

    public void applyLockedLayout(LayoutAlgorithm layout, CyNodeView[] nodes, CyEdgeView[] edges) {
        layout.lockNodes(nodes);
        layout.doLayout();
    }

    public void applyLayout(LayoutAlgorithm layout, CyNodeView[] nodes, CyEdgeView[] edges) {
        layout.lockNodes(this.getInverseViews(nodes));
        layout.doLayout();
    }

    public void applyLockedLayout(LayoutAlgorithm layout, int[] nodes, int[] edges) {
        layout.lockNodes(this.convertToNodeViews(nodes));
        layout.doLayout();
    }

    private NodeView[] convertToNodeViews(int[] nodes) {
        NodeView[] views = new NodeView[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            views[i] = this.getNodeView(nodes[i]);
        }
        return views;
    }

    public void applyLayout(LayoutAlgorithm layout, int[] nodes, int[] edges) {
        layout.lockNodes(this.getInverseViews(this.convertToNodeViews(nodes)));
        layout.doLayout();
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
        super.addNodeContextMenuListener(l);
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
        super.removeNodeContextMenuListener(l);
    }

    public void addEdgeContextMenuListener(EdgeContextMenuListener l) {
        super.addEdgeContextMenuListener(l);
    }

    public void removeEdgeContextMenuListener(EdgeContextMenuListener l) {
        super.removeEdgeContextMenuListener(l);
    }
}

