/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxyHandler
implements PropertyChangeListener {
    private static Proxy proxyServer = null;

    private ProxyHandler() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public static Proxy getProxyServer() {
        if (proxyServer == null) {
            ProxyHandler.loadProxyServer();
        }
        return proxyServer;
    }

    private static void loadProxyServer() {
        String proxyName = CytoscapeInit.getProperties().getProperty("proxy.server");
        if (proxyName == null || proxyName.equals("")) {
            proxyServer = null;
            return;
        }
        String proxyT = CytoscapeInit.getProperties().getProperty("proxy.server.type");
        if (proxyT == null || proxyT.equals("")) {
            proxyServer = null;
            return;
        }
        Proxy.Type proxyType = Proxy.Type.valueOf(proxyT);
        String proxyP = CytoscapeInit.getProperties().getProperty("proxy.server.port");
        if (proxyP == null || proxyP.equals("")) {
            proxyServer = null;
            return;
        }
        int proxyPort = Integer.parseInt(proxyP);
        proxyServer = new Proxy(proxyType, new InetSocketAddress(proxyName, proxyPort));
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "PREFERENCES_UPDATED") {
            ProxyHandler.loadProxyServer();
        }
    }

    static {
        new ProxyHandler();
    }
}

