/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.AppearanceCalculator;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.NodeCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLabelColorCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import giny.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;

public class NodeAppearanceCalculator
extends AppearanceCalculator {
    NodeAppearance defaultAppearance = new NodeAppearance();
    private NodeAppearance currentAppearance;
    private CyNetwork currentNetwork;
    private Node currentNode;
    public static final String nodeFillColorBypass = "node.fillColor";
    public static final String nodeBorderColorBypass = "node.borderColor";
    public static final String nodeLineTypeBypass = "node.lineType";
    public static final String nodeShapeBypass = "node.shape";
    public static final String nodeWidthBypass = "node.width";
    public static final String nodeHeightBypass = "node.height";
    public static final String nodeLabelBypass = "node.label";
    public static final String nodeToolTipBypass = "node.toolTip";
    public static final String nodeFontBypass = "node.font";
    public static final String nodeLabelColorBypass = "node.labelColor";

    public NodeAppearanceCalculator() {
    }

    public NodeAppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        super(name, nacProps, baseKey, catalog, new NodeAppearance());
        this.defaultAppearance = (NodeAppearance)this.tmpDefaultAppearance;
    }

    public NodeAppearanceCalculator(NodeAppearanceCalculator toCopy) {
        super(toCopy);
    }

    public NodeAppearance calculateNodeAppearance(Node node, CyNetwork network) {
        NodeAppearance appr = new NodeAppearance();
        this.calculateNodeAppearance(appr, node, network);
        return appr;
    }

    public void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
        appr.copy(this.defaultAppearance);
        for (Calculator nc : this.calcs) {
            nc.apply(appr, node, network);
        }
        appr.applyBypass(node);
        this.currentAppearance = appr;
        this.currentNode = node;
        this.currentNetwork = network;
    }

    public NodeAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(NodeAppearance n) {
        this.defaultAppearance = n;
    }

    public String getDescription() {
        return this.getDescription("NodeAppearanceCalculator", this.defaultAppearance);
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(this.defaultAppearance, name, nacProps, baseKey, catalog);
    }

    public Properties getProperties(String baseKey) {
        return this.getProperties(this.defaultAppearance, baseKey);
    }

    protected void copyDefaultAppearance(AppearanceCalculator toCopy) {
        this.defaultAppearance = (NodeAppearance)((NodeAppearanceCalculator)toCopy).getDefaultAppearance().clone();
    }

    public boolean getNodeSizeLocked() {
        return this.defaultAppearance.getNodeSizeLocked();
    }

    public void setNodeSizeLocked(boolean b) {
        this.defaultAppearance.setNodeSizeLocked(b);
    }

    protected boolean isValidCalculator(Calculator c) {
        return c instanceof NodeCalculator;
    }

    public void setDefaultNodeFillColor(Color c) {
        this.defaultAppearance.setFillColor(c);
    }

    public void setDefaultNodeBorderColor(Color c) {
        this.defaultAppearance.setBorderColor(c);
    }

    public void setDefaultNodeLineType(LineType lt) {
        this.defaultAppearance.setBorderLineType(lt);
    }

    public void setDefaultNodeShape(byte s) {
        this.defaultAppearance.setShape(s);
    }

    public void setDefaultNodeWidth(double d) {
        this.defaultAppearance.setWidth(d);
    }

    public void setDefaultNodeHeight(double d) {
        this.defaultAppearance.setHeight(d);
    }

    public void setDefaultNodeLabel(String s) {
        this.defaultAppearance.setLabel(s);
    }

    public void setDefaultNodeToolTip(String s) {
        this.defaultAppearance.setToolTip(s);
    }

    public void setDefaultNodeFont(Font f) {
        this.defaultAppearance.setFont(f);
    }

    public void setDefaultNodeFontFace(Font f) {
        this.defaultAppearance.setFont(f);
    }

    public void setDefaultNodeFontSize(float f) {
        this.defaultAppearance.setFontSize(f);
    }

    public void setDefaultNodeLabelColor(Color c) {
        this.defaultAppearance.setLabelColor(c);
    }

    public Color getDefaultNodeFillColor() {
        return this.defaultAppearance.getFillColor();
    }

    public Color getDefaultNodeBorderColor() {
        return this.defaultAppearance.getBorderColor();
    }

    public LineType getDefaultNodeLineType() {
        return this.defaultAppearance.getBorderLineType();
    }

    public byte getDefaultNodeShape() {
        return this.defaultAppearance.getShape();
    }

    public double getDefaultNodeWidth() {
        return this.defaultAppearance.getWidth();
    }

    public double getDefaultNodeHeight() {
        return this.defaultAppearance.getHeight();
    }

    public String getDefaultNodeLabel() {
        return this.defaultAppearance.getLabel();
    }

    public String getDefaultNodeToolTip() {
        return this.defaultAppearance.getToolTip();
    }

    public Font getDefaultNodeFont() {
        return this.defaultAppearance.getFont();
    }

    public Font getDefaultNodeFontFace() {
        return this.defaultAppearance.getFont();
    }

    public float getDefaultNodeFontSize() {
        return this.defaultAppearance.getFontSize();
    }

    public Color getDefaultNodeLabelColor() {
        return this.defaultAppearance.getLabelColor();
    }

    public Color calculateNodeFillColor(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getFillColor();
    }

    public Color calculateNodeBorderColor(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getBorderColor();
    }

    public LineType calculateNodeLineType(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getBorderLineType();
    }

    public byte calculateNodeShape(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getShape();
    }

    public double calculateNodeWidth(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getWidth();
    }

    public double calculateNodeHeight(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getHeight();
    }

    public String calculateNodeLabel(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getLabel();
    }

    public String calculateNodeToolTip(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getToolTip();
    }

    public Font calculateNodeFont(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getFont();
    }

    public Color calculateNodeLabelColor(Node node, CyNetwork network) {
        this.doCalc(node, network);
        return this.currentAppearance.getLabelColor();
    }

    private void doCalc(Node node, CyNetwork network) {
        if (node != this.currentNode && network != this.currentNetwork) {
            this.calculateNodeAppearance(node, network);
        }
    }

    public NodeColorCalculator getNodeFillColorCalculator() {
        return (NodeColorCalculator)this.getCalculator((byte)0);
    }

    public NodeColorCalculator getNodeBorderColorCalculator() {
        return (NodeColorCalculator)this.getCalculator((byte)1);
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator() {
        return (NodeLineTypeCalculator)this.getCalculator((byte)2);
    }

    public NodeShapeCalculator getNodeShapeCalculator() {
        return (NodeShapeCalculator)this.getCalculator((byte)3);
    }

    public NodeSizeCalculator getNodeWidthCalculator() {
        if (this.getNodeSizeLocked()) {
            return (NodeSizeCalculator)this.getCalculator((byte)4);
        }
        return (NodeSizeCalculator)this.getCalculator((byte)127);
    }

    public NodeSizeCalculator getNodeHeightCalculator() {
        if (this.getNodeSizeLocked()) {
            return (NodeSizeCalculator)this.getCalculator((byte)4);
        }
        return (NodeSizeCalculator)this.getCalculator((byte)126);
    }

    public NodeLabelCalculator getNodeLabelCalculator() {
        return (NodeLabelCalculator)this.getCalculator((byte)5);
    }

    public NodeToolTipCalculator getNodeToolTipCalculator() {
        return (NodeToolTipCalculator)this.getCalculator((byte)14);
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator() {
        return (NodeFontFaceCalculator)this.getCalculator((byte)122);
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator() {
        return (NodeFontSizeCalculator)this.getCalculator((byte)123);
    }

    public NodeLabelColorCalculator getNodeLabelColorCalculator() {
        return (NodeLabelColorCalculator)this.getCalculator((byte)7);
    }

    public void setNodeFillColorCalculator(NodeColorCalculator c) {
        c.set((byte)0, "nodeFillColorCalculator", "Node Color");
        this.setCalculator(c);
    }

    public void setNodeBorderColorCalculator(NodeColorCalculator c) {
        c.set((byte)1, "nodeBorderColorCalculator", "Node Border Color");
        this.setCalculator(c);
    }

    public void setNodeLineTypeCalculator(NodeLineTypeCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeShapeCalculator(NodeShapeCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeWidthCalculator(NodeSizeCalculator c) {
        if (this.getNodeSizeLocked()) {
            c.set((byte)4, "nodeUniformSizeCalculator", "Node Size");
        } else {
            c.set((byte)127, "nodeWidthCalculator", "Node Width");
        }
        this.setCalculator(c);
    }

    public void setNodeHeightCalculator(NodeSizeCalculator c) {
        if (this.getNodeSizeLocked()) {
            c.set((byte)4, "nodeUniformSizeCalculator", "Node Size");
        } else {
            c.set((byte)126, "nodeHeightCalculator", "Node Height");
        }
        this.setCalculator(c);
    }

    public void setNodeLabelCalculator(NodeLabelCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeToolTipCalculator(NodeToolTipCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeFontFaceCalculator(NodeFontFaceCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeFontSizeCalculator(NodeFontSizeCalculator c) {
        this.setCalculator(c);
    }

    public void setNodeLabelColorCalculator(NodeLabelColorCalculator c) {
        this.setCalculator(c);
    }
}

