/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.db.biosql.DBHelper;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.EbiFormat;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.WeakTaxonFactory;
import org.biojava.utils.ChangeVetoException;

public class TaxonSQL {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Taxon getTaxon(Connection conn, int ncbi_taxon_id) {
        Taxon taxon;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            int taxon_id = 0;
            statement = conn.prepareStatement("select taxon_id from taxon where ncbi_taxon_id = ? ");
            statement.setInt(1, ncbi_taxon_id);
            rs = statement.executeQuery();
            if (rs.next()) {
                taxon_id = rs.getInt(1);
                if (rs.wasNull()) {
                    taxon_id = 0;
                }
            }
            rs.close();
            statement.close();
            taxon = taxon_id != 0 ? TaxonSQL.getDBTaxon(conn, taxon_id) : null;
        }
        catch (ChangeVetoException ex) {
            try {
                throw new BioRuntimeException("Couldn't manipulate in-memory taxonomy", ex);
                catch (SQLException ex2) {
                    throw new BioRuntimeException("Error fetching taxonomy annotations", ex2);
                }
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(statement);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return taxon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Taxon getDBTaxon(Connection conn, int taxon_id) throws SQLException, ChangeVetoException {
        Taxon taxon;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String nextID;
            boolean NCBI_ID = true;
            boolean TAXON_ID = false;
            statement = conn.prepareStatement("select ncbi_taxon_id, parent_taxon_id from taxon where taxon_id = ? ");
            ArrayList<int[]> path = new ArrayList<int[]>();
            while (taxon_id != 0) {
                statement.setInt(1, taxon_id);
                rs = statement.executeQuery();
                if (rs.next()) {
                    path.add(new int[]{taxon_id, rs.getInt(1)});
                    taxon_id = rs.getInt(2);
                    if (rs.wasNull()) {
                        taxon_id = 0;
                    }
                } else {
                    throw new BioRuntimeException("Error fetching taxonomy structure. No taxon with taxon_id=" + taxon_id);
                }
                rs.close();
            }
            statement.close();
            WeakTaxonFactory factory = WeakTaxonFactory.GLOBAL;
            Taxon taxon2 = factory.getRoot();
            int pos = path.size() - 1;
            int[] ids = (int[])path.get(pos--);
            Map names = TaxonSQL.getTaxonNames(conn, ids[0]);
            taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, "" + ids[1]);
            taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_TAXON_NAMES, names);
            if (pos >= 0) {
                ids = (int[])path.get(pos);
                nextID = "" + ids[1];
                Set children = taxon2.getChildren();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Taxon child = (Taxon)it.next();
                    Annotation anno = child.getAnnotation();
                    if (anno.containsProperty(EbiFormat.PROPERTY_NCBI_TAXON)) {
                        String childID = (String)anno.getProperty(EbiFormat.PROPERTY_NCBI_TAXON);
                        if (!childID.equals(nextID)) continue;
                        taxon2 = child;
                        continue;
                    }
                    throw new BioRuntimeException("Taxon has not been annotated with NCBI taxon ids.");
                }
            }
            try {
                while (pos >= 0) {
                    ids = (int[])path.get(pos);
                    nextID = "" + ids[1];
                    names = TaxonSQL.getTaxonNames(conn, ids[0]);
                    String sciName = (String)names.get("scientific name");
                    if (sciName == null) {
                        throw new BioRuntimeException("No scientific name for taxon_id=" + ids[0]);
                    }
                    String commonName = (String)names.get("common name");
                    taxon2 = factory.addChild(taxon2, factory.createTaxon(sciName, commonName));
                    taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, nextID);
                    taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_TAXON_NAMES, names);
                    --pos;
                }
            }
            catch (CircularReferenceException ex) {
                throw new BioRuntimeException("Circular references in taxon table. taxon_id=" + ids[0]);
            }
            taxon = taxon2;
        }
        catch (Throwable throwable) {
            TaxonSQL.attemptClose(rs);
            TaxonSQL.attemptClose(statement);
            throw throwable;
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return taxon;
    }

    private static Map getTaxonNames(Connection conn, int taxon_id) {
        HashMap<String, String> hashMap;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("select name_class, name from taxon_name where taxon_id = ? ");
            statement.setInt(1, taxon_id);
            rs = statement.executeQuery();
            HashMap<String, String> names = new HashMap<String, String>();
            while (rs.next()) {
                String name_class = rs.getString(1);
                String name = rs.getString(2);
                names.put(name_class, name);
            }
            hashMap = names;
        }
        catch (SQLException ex) {
            try {
                throw new BioRuntimeException("Error fetching taxonomy annotations", ex);
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(statement);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return hashMap;
    }

    public static int putTaxon(Connection conn, DBHelper helper, Taxon taxon) throws SQLException {
        int taxon_id;
        Annotation anno = taxon.getAnnotation();
        Object t = anno.getProperty(EbiFormat.PROPERTY_NCBI_TAXON);
        if (t instanceof List) {
            t = (String)((List)t).get(0);
        }
        int ncbi_taxon_id = Integer.parseInt((String)t);
        PreparedStatement selectTaxon = conn.prepareStatement("select taxon_id from taxon where ncbi_taxon_id = ? ");
        selectTaxon.setInt(1, ncbi_taxon_id);
        ResultSet trs = selectTaxon.executeQuery();
        if (trs.next()) {
            taxon_id = trs.getInt(1);
        } else {
            Taxon parent = taxon.getParent();
            PreparedStatement createTaxon = null;
            if (parent != null) {
                int parent_taxon_id = TaxonSQL.putTaxon(conn, helper, parent);
                createTaxon = conn.prepareStatement("insert into taxon (ncbi_taxon_id, parent_taxon_id) values (?, ?)");
                createTaxon.setInt(1, ncbi_taxon_id);
                createTaxon.setInt(2, parent_taxon_id);
            } else {
                createTaxon = conn.prepareStatement("insert into taxon (ncbi_taxon_id) values (?)");
                createTaxon.setInt(1, ncbi_taxon_id);
            }
            createTaxon.executeUpdate();
            createTaxon.close();
            taxon_id = helper.getInsertID(conn, "taxon", "taxon_id");
            TaxonSQL.putTaxonNames(conn, (Map)taxon.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES), taxon_id);
        }
        trs.close();
        selectTaxon.close();
        return taxon_id;
    }

    private static void putTaxonNames(Connection conn, Map names, int taxon_id) throws SQLException {
        if (names != null) {
            Iterator it = names.keySet().iterator();
            while (it.hasNext()) {
                String nameClass = (String)it.next();
                String name = (String)names.get(nameClass);
                PreparedStatement createTaxon = conn.prepareStatement("insert into taxon_name (taxon_id, name, name_class) values (?, ?, ?)");
                createTaxon.setInt(1, taxon_id);
                createTaxon.setString(2, name);
                createTaxon.setString(3, nameClass);
                createTaxon.executeUpdate();
                createTaxon.close();
            }
        }
    }

    static void attemptClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    static void attemptClose(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }
}

