/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.PatternListener;
import org.biojava.utils.automata.PatternMaker;
import org.biojava.utils.automata.StateMachineFactory;
import org.biojava.utils.automata.StateMachineInstance;
import org.biojava.utils.automata.StateMachineToolkit;

public class PatternBlitz {
    FiniteAlphabet alfa;
    private LinkedList patternStore;
    private LinkedList instanceStore;
    private PatternListener listener;
    private StateMachineToolkit factory;
    private AlphabetIndex alfaIdx;

    public PatternBlitz(FiniteAlphabet alfa, StateMachineToolkit factory) {
        this.alfa = alfa;
        this.alfaIdx = AlphabetManager.getAlphabetIndex(alfa);
        this.patternStore = new LinkedList();
        this.instanceStore = new LinkedList();
        this.factory = factory;
    }

    public void lock() {
    }

    public void setListener(PatternListener listener) {
        this.listener = listener;
    }

    public void addPattern(String pattern) {
        try {
            FiniteAutomaton dfa = PatternMaker.compilePattern(pattern, this.alfa);
            StateMachineFactory instanceFactory = this.factory.getFactory(pattern, dfa);
            instanceFactory.setListener(this.listener);
            this.patternStore.addLast(instanceFactory);
        }
        catch (BioException be) {
            throw new AssertionError((Object)be);
        }
    }

    private void scanPatterns(Symbol sym, int start) throws IllegalSymbolException {
        int symIdx = this.alfaIdx.indexForSymbol(sym);
        ListIterator instanceI = this.instanceStore.listIterator();
        while (instanceI.hasNext()) {
            StateMachineInstance instance = (StateMachineInstance)instanceI.next();
            if (instance.transit(symIdx)) continue;
            instanceI.remove();
        }
        Iterator patternI = this.patternStore.iterator();
        while (patternI.hasNext()) {
            StateMachineFactory factory = (StateMachineFactory)patternI.next();
            StateMachineInstance newInstance = factory.startInstance(symIdx, start);
            if (newInstance == null) continue;
            this.instanceStore.addLast(newInstance);
        }
    }

    public void search(SymbolList sl) throws IllegalAlphabetException {
        if (sl.getAlphabet() != this.alfa) {
            throw new IllegalAlphabetException("incompatible alphabets");
        }
        try {
            for (int i = 1; i < sl.length(); ++i) {
                Symbol sym = sl.symbolAt(i);
                this.scanPatterns(sym, i);
            }
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionError((Object)ise);
        }
    }
}

