/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEProgressBarDialog;
import csplugins.mcode.MCODEResultsDialog;
import csplugins.mcode.MCODEScoreAndFindAction;
import csplugins.mcode.MCODEUtil;
import csplugins.mcode.SwingWorker;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import giny.model.GraphPerspective;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class MCODEScoreAndFindAction
implements ActionListener {
    private MCODEResultsDialog resultDialog;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "MCODEScoreAction.actionPerformed";
        final CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
        if (cyNetwork == null) {
            System.err.println("In " + string + ":");
            System.err.println("Can't get current network.");
            return;
        }
        if (cyNetwork.getNodeCount() < 1) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "You must have a network loaded to run this plugin.");
            return;
        }
        Boolean bl = (Boolean)cyNetwork.getClientData("MCODE_running");
        if (bl != null && bl.booleanValue()) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "MCODE is already running on this network. Please wait for it to complete.");
            return;
        }
        cyNetwork.putClientData("MCODE_running", (Object)new Boolean(true));
        this.resultDialog = (MCODEResultsDialog)cyNetwork.getClientData("MCODE_dialog");
        if (this.resultDialog != null) {
            this.resultDialog.setVisible(true);
            cyNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
        } else {
            final MCODEProgressBarDialog mCODEProgressBarDialog = new MCODEProgressBarDialog((Frame)Cytoscape.getDesktop());
            mCODEProgressBarDialog.setIndeterminate(true);
            mCODEProgressBarDialog.pack();
            mCODEProgressBarDialog.setVisible(true);
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    MCODEAlgorithm mCODEAlgorithm = new MCODEAlgorithm();
                    mCODEProgressBarDialog.setString("Scoring Network (Step 1 of 3)");
                    mCODEAlgorithm.scoreGraph(cyNetwork);
                    if (mCODEProgressBarDialog.isCancelled()) {
                        mCODEProgressBarDialog.dispose();
                        cyNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
                        return null;
                    }
                    mCODEProgressBarDialog.setString("Finding Clusters (Step 2 of 3)");
                    ArrayList arrayList = mCODEAlgorithm.findComplexes(cyNetwork);
                    if (mCODEProgressBarDialog.isCancelled()) {
                        mCODEProgressBarDialog.dispose();
                        cyNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
                        return null;
                    }
                    mCODEProgressBarDialog.setIndeterminate(false);
                    mCODEProgressBarDialog.setLengthOfTask(arrayList.size());
                    mCODEProgressBarDialog.setString("Drawing Results (Step 3 of 3)");
                    cyNetwork.putClientData("MCODE_alg", (Object)mCODEAlgorithm);
                    System.err.println("Network was scored in " + mCODEAlgorithm.getLastScoreTime() + " ms.");
                    GraphPerspective[] graphPerspectiveArray = MCODEUtil.convertComplexListToSortedNetworkList(arrayList, cyNetwork, mCODEAlgorithm);
                    Image[] imageArray = new Image[arrayList.size()];
                    int n = MCODECurrentParameters.getInstance().getParamsCopy().getDefaultRowHeight();
                    for (int i = 0; i < graphPerspectiveArray.length; ++i) {
                        if (mCODEProgressBarDialog.isCancelled()) {
                            mCODEProgressBarDialog.dispose();
                            cyNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
                            return null;
                        }
                        imageArray[i] = MCODEUtil.convertNetworkToImage(graphPerspectiveArray[i], n, n);
                        mCODEProgressBarDialog.setValue(i + 1);
                    }
                    class ThreadReturnInfo {
                        ArrayList complexes;
                        Image[] imageList;
                        private final /* synthetic */ MCODEScoreAndFindAction this$0;

                        public ThreadReturnInfo(MCODEScoreAndFindAction mCODEScoreAndFindAction, ArrayList arrayList, Image[] imageArray) {
                            this.this$0 = mCODEScoreAndFindAction;
                            this.complexes = arrayList;
                            this.imageList = imageArray;
                        }
                    }
                    ThreadReturnInfo threadReturnInfo = new ThreadReturnInfo(MCODEScoreAndFindAction.this, arrayList, imageArray);
                    return threadReturnInfo;
                }

                public void finished() {
                    ThreadReturnInfo threadReturnInfo = (ThreadReturnInfo)this.get();
                    if (threadReturnInfo != null) {
                        MCODEScoreAndFindAction.this.resultDialog = new MCODEResultsDialog((Frame)Cytoscape.getDesktop(), threadReturnInfo.complexes, cyNetwork, threadReturnInfo.imageList);
                        MCODEScoreAndFindAction.this.resultDialog.pack();
                        cyNetwork.putClientData("MCODE_dialog", (Object)MCODEScoreAndFindAction.this.resultDialog);
                        cyNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
                        mCODEProgressBarDialog.dispose();
                        MCODEScoreAndFindAction.this.resultDialog.setVisible(true);
                    }
                }
            };
            swingWorker.start();
        }
    }
}

