/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEParameterSet;
import cytoscape.CyNetwork;
import giny.model.GraphPerspective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class MCODEAlgorithm {
    private HashMap nodeInfoHashMap = null;
    private TreeMap nodeScoreSortedMap = null;
    private MCODEParameterSet params = MCODECurrentParameters.getInstance().getParamsCopy();
    private long lastScoreTime;
    private long lastFindTime;

    public long getLastScoreTime() {
        return this.lastScoreTime;
    }

    public long getLastFindTime() {
        return this.lastFindTime;
    }

    public MCODEParameterSet getParams() {
        return this.params;
    }

    public void scoreGraph(CyNetwork cyNetwork) {
        String string = "MCODEAlgorithm.MCODEAlgorithm";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": inputNetwork was null.");
            return;
        }
        long l = System.currentTimeMillis();
        this.nodeInfoHashMap = new HashMap(cyNetwork.getNodeCount());
        this.nodeScoreSortedMap = new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = (Double)object;
                if (d2 == (d = ((Double)object2).doubleValue())) {
                    return 0;
                }
                if (d2 < d) {
                    return 1;
                }
                return -1;
            }
        });
        NodeInfo nodeInfo = null;
        for (int i = 1; i <= cyNetwork.getNodeCount(); ++i) {
            nodeInfo = this.calcNodeInfo(cyNetwork, i);
            this.nodeInfoHashMap.put(new Integer(i), nodeInfo);
            double d = this.scoreNode(nodeInfo);
            cyNetwork.setNodeAttributeValue(i, "MCODE_SCORE", (Object)new Double(d));
            this.nodeScoreSortedMap.put(new Double(d), new Integer(i));
        }
        long l2 = System.currentTimeMillis();
        this.lastScoreTime = l2 - l;
    }

    public ArrayList findComplexes(CyNetwork cyNetwork) {
        String string = "MCODEAlgorithm.findComplexes";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": inputNetwork was null.");
            return null;
        }
        if (this.nodeInfoHashMap == null || this.nodeScoreSortedMap == null) {
            System.err.println("In " + string + ": nodeInfoHashMap or nodeScoreSortedMap was null.");
            return null;
        }
        long l = System.currentTimeMillis();
        boolean[] blArray = new boolean[cyNetwork.getNodeCount() + 1];
        Arrays.fill(blArray, false);
        int n = 0;
        Collection collection = this.nodeScoreSortedMap.values();
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList2;
            n = (Integer)iterator.next();
            if (blArray[n] || (arrayList2 = this.getComplexCore(n, blArray)).size() <= 0) continue;
            if (!arrayList2.contains(new Integer(n))) {
                arrayList2.add(new Integer(n));
            }
            int[] nArray = new int[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                int n2;
                nArray[i] = n2 = ((Integer)arrayList2.get(i)).intValue();
            }
            GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
            if (this.filterComplex(graphPerspective)) continue;
            if (this.params.isHaircut()) {
                this.haircutComplex(graphPerspective, arrayList2, (GraphPerspective)cyNetwork);
            }
            if (this.params.isFluff()) {
                this.fluffComplexBoundary(arrayList2, blArray);
            }
            arrayList.add(arrayList2);
        }
        long l2 = System.currentTimeMillis();
        this.lastFindTime = l2 - l;
        return arrayList;
    }

    private double scoreNode(NodeInfo nodeInfo) {
        nodeInfo.score = nodeInfo.numNodeNeighbors > this.params.getDegreeCutOff() ? nodeInfo.coreDensity * (double)nodeInfo.coreLevel : 0.0;
        return nodeInfo.score;
    }

    public double scoreComplex(GraphPerspective graphPerspective) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        n = graphPerspective.getNodeCount();
        d = this.calcDensity(graphPerspective, true);
        d2 = d * (double)n;
        return d2;
    }

    private NodeInfo calcNodeInfo(CyNetwork cyNetwork, int n) {
        int[] nArray;
        String string = "MCODEAlgorithm.calcNodeInfo";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int[] nArray2 = cyNetwork.neighborsArray(n);
        if (nArray2.length < 2) {
            NodeInfo nodeInfo = new NodeInfo();
            if (nArray2.length == 1) {
                nodeInfo.coreLevel = 1;
                nodeInfo.coreDensity = 1.0;
                nodeInfo.density = 1.0;
            }
            return nodeInfo;
        }
        Arrays.sort(nArray2);
        if (Arrays.binarySearch(nArray2, n) < 0) {
            nArray = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray, 1, nArray2.length);
            nArray[0] = n;
        } else {
            nArray = nArray2;
        }
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpNodeNeighborhood was null.");
            return null;
        }
        NodeInfo nodeInfo = new NodeInfo();
        if (graphPerspective != null) {
            nodeInfo.density = this.calcDensity(graphPerspective, this.params.isIncludeLoops());
        }
        nodeInfo.numNodeNeighbors = nArray.length;
        GraphPerspective graphPerspective2 = null;
        Integer n2 = null;
        Object[] objectArray = this.getHighestKCore(graphPerspective);
        n2 = (Integer)objectArray[0];
        graphPerspective2 = (GraphPerspective)objectArray[1];
        nodeInfo.coreLevel = n2;
        if (graphPerspective2 != null) {
            nodeInfo.coreDensity = this.calcDensity(graphPerspective2, this.params.isIncludeLoops());
        }
        nodeInfo.nodeNeighbors = nArray;
        return nodeInfo;
    }

    private ArrayList getComplexCore(int n, boolean[] blArray) {
        ArrayList arrayList = new ArrayList();
        this.getComplexCoreInternal(n, blArray, ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).score, 1, arrayList);
        return arrayList;
    }

    private boolean getComplexCoreInternal(int n, boolean[] blArray, double d, int n2, ArrayList arrayList) {
        if (blArray[n]) {
            return true;
        }
        if (n2 > this.params.getMaxDepthFromStart()) {
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        blArray[n] = true;
        for (n4 = 0; n4 < ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).numNodeNeighbors; ++n4) {
            n3 = ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).nodeNeighbors[n4];
            if (blArray[n3]) continue;
            Integer n5 = new Integer(n3);
            if (!(((NodeInfo)this.nodeInfoHashMap.get((Object)n5)).score >= d - d * this.params.getNodeScoreCutOff())) continue;
            if (!arrayList.contains(new Integer(n3))) {
                arrayList.add(new Integer(n3));
            }
            this.getComplexCoreInternal(n3, blArray, d, n2 + 1, arrayList);
        }
        return true;
    }

    private boolean fluffComplexBoundary(ArrayList arrayList, boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i);
            for (int j = 0; j < ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).numNodeNeighbors; ++j) {
                n2 = ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).nodeNeighbors[j];
                if (blArray2[n2]) continue;
                Integer n3 = new Integer(n2);
                if (!(((NodeInfo)this.nodeInfoHashMap.get((Object)n3)).density > this.params.getFluffNodeDensityCutOff())) continue;
                arrayList2.add(new Integer(n2));
                blArray2[n2] = true;
            }
        }
        if (arrayList2.size() > 0) {
            arrayList.addAll(arrayList2.subList(0, arrayList2.size()));
        }
        return true;
    }

    private boolean filterComplex(GraphPerspective graphPerspective) {
        if (graphPerspective == null) {
            return true;
        }
        GraphPerspective graphPerspective2 = this.getKCore(graphPerspective, 2);
        return graphPerspective2 == null;
    }

    private boolean haircutComplex(GraphPerspective graphPerspective, ArrayList arrayList, GraphPerspective graphPerspective2) {
        GraphPerspective graphPerspective3 = this.getKCore(graphPerspective, 2);
        if (graphPerspective3 != null) {
            arrayList.clear();
            int[] nArray = graphPerspective3.getNodeIndicesArray();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Integer(graphPerspective2.getNodeIndex(nArray[i])));
            }
        }
        return true;
    }

    public double calcDensity(GraphPerspective graphPerspective, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        String string = "MCODEAlgorithm.calcDensity";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return -1.0;
        }
        if (bl) {
            for (int i = 1; i <= graphPerspective.getNodeCount(); ++i) {
                if (!graphPerspective.isNeighbor(i, i)) continue;
                ++n3;
            }
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount() - n3;
        } else {
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount();
        }
        d = (double)n2 / (double)n;
        return d;
    }

    public GraphPerspective getKCore(GraphPerspective graphPerspective, int n) {
        String string = "MCODEAlgorithm.getKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        boolean bl = true;
        GraphPerspective graphPerspective2 = null;
        while (true) {
            int n2 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(graphPerspective.getNodeCount());
            for (int i = 1; i <= graphPerspective.getNodeCount(); ++i) {
                if (graphPerspective.getDegree(i) >= n) {
                    arrayList.add(new Integer(i));
                    continue;
                }
                ++n2;
            }
            if (n2 <= 0 && !bl) break;
            int[] nArray = new int[arrayList.size()];
            int n3 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nArray[n3] = (Integer)iterator.next();
                ++n3;
            }
            graphPerspective2 = graphPerspective.createGraphPerspective(nArray);
            if (graphPerspective2.getNodeCount() == 0) {
                return null;
            }
            graphPerspective = graphPerspective2;
            if (!bl) continue;
            bl = false;
        }
        return graphPerspective2;
    }

    public Object[] getHighestKCore(GraphPerspective graphPerspective) {
        String string = "MCODEAlgorithm.getHighestKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int n = 1;
        GraphPerspective graphPerspective2 = null;
        GraphPerspective graphPerspective3 = null;
        while ((graphPerspective2 = this.getKCore(graphPerspective, n)) != null) {
            graphPerspective = graphPerspective2;
            graphPerspective3 = graphPerspective2;
            ++n;
        }
        Integer n2 = new Integer(n - 1);
        Object[] objectArray = new Object[]{n2, graphPerspective3};
        return objectArray;
    }

    private class NodeInfo {
        double density = 0.0;
        int numNodeNeighbors = 0;
        int[] nodeNeighbors;
        int coreLevel = 0;
        double coreDensity = 0.0;
        double score;
    }
}

