/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.JMultiLineToolTip;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEParameterSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;

public class MCODEParameterChangeDialog
extends JDialog {
    MCODEParameterSet currentParamsCopy;
    JCheckBox includeLoopsCheckBox;
    JFormattedTextField degreeCutOffFormattedTextField;
    JFormattedTextField maxDepthFormattedTextField;
    JFormattedTextField nodeScoreCutOffFormattedTextField;
    JCheckBox haircutCheckBox;
    JCheckBox fluffCheckBox;
    JFormattedTextField fluffNodeDensityCutOffFormattedTextField;
    JCheckBox processCheckBox;

    public MCODEParameterChangeDialog(Frame frame) {
        super(frame, "MCODE Parameters", false);
        this.setResizable(false);
        this.currentParamsCopy = MCODECurrentParameters.getInstance().getParamsCopy();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.includeLoopsCheckBox = new JCheckBox("Include loops", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.includeLoopsCheckBox.addItemListener(new includeLoopsCheckBoxAction());
        this.includeLoopsCheckBox.setToolTipText("If checked, MCODE will include loops (self-edges) in the neighborhood\ndensity calculation.  This is expected to make a small difference in the results.");
        this.includeLoopsCheckBox.setSelected(this.currentParamsCopy.isIncludeLoops());
        jPanel2.add(this.includeLoopsCheckBox);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setParseIntegerOnly(true);
        this.degreeCutOffFormattedTextField = new JFormattedTextField(decimalFormat){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.degreeCutOffFormattedTextField.setColumns(3);
        this.degreeCutOffFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string = "Sets the degree cutoff below which a node will not be scored.\nNodes with a degree equal or higher to this value will be scored.\nBy default this is set to 2. Valid values are 2 or higher to prevent singly connected nodes\nfrom getting an artificially high node score.";
        this.degreeCutOffFormattedTextField.setToolTipText(string);
        this.degreeCutOffFormattedTextField.setText(new Integer(this.currentParamsCopy.getDegreeCutOff()).toString());
        JLabel jLabel = new JLabel("Degree Cutoff");
        JPanel jPanel3 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel3.setToolTipText(string);
        jPanel3.add(jLabel);
        jPanel3.add(this.degreeCutOffFormattedTextField);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new BorderLayout(15, 2));
        JPanel jPanel7 = new JPanel();
        this.nodeScoreCutOffFormattedTextField = new JFormattedTextField(new DecimalFormat("0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.nodeScoreCutOffFormattedTextField.setColumns(3);
        this.nodeScoreCutOffFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string2 = "Sets the node score cutoff for expanding a cluster as a percentage from the seed node score.\nThis is the most important parameter to control the size of MCODE clusters,\nwith smaller values creating smaller clusters.";
        this.nodeScoreCutOffFormattedTextField.setToolTipText(string2);
        this.nodeScoreCutOffFormattedTextField.setText(new Double(this.currentParamsCopy.getNodeScoreCutOff()).toString());
        JLabel jLabel2 = new JLabel("Node Score Cutoff");
        JPanel jPanel8 = new JPanel(new FlowLayout(0)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel8.setToolTipText(string2);
        jPanel8.add(jLabel2);
        jPanel8.add(this.nodeScoreCutOffFormattedTextField);
        jPanel6.add((Component)jPanel8, "West");
        this.haircutCheckBox = new JCheckBox("Haircut", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.haircutCheckBox.addItemListener(new haircutCheckBoxAction());
        this.haircutCheckBox.setToolTipText("If checked, MCODE will give clusters a haircut\n(remove singly connected nodes).");
        this.haircutCheckBox.setSelected(this.currentParamsCopy.isHaircut());
        jPanel6.add((Component)this.haircutCheckBox, "East");
        this.fluffNodeDensityCutOffFormattedTextField = new JFormattedTextField(new DecimalFormat("0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.fluffNodeDensityCutOffFormattedTextField.setColumns(3);
        this.fluffNodeDensityCutOffFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string3 = "Sets the fluff density cutoff for expanding a cluster according to the unadjusted\nnode density (clustering coefficient) after the cluster has already been defined by the algorithm.\nThis allows clusters to slightly overlap at their edges. This parameter is only valid if fluffing\nis turned on. A higher value will expand the cluster more.";
        this.fluffNodeDensityCutOffFormattedTextField.setToolTipText(string3);
        this.fluffNodeDensityCutOffFormattedTextField.setText(new Double(this.currentParamsCopy.getFluffNodeDensityCutOff()).toString());
        this.fluffNodeDensityCutOffFormattedTextField.setEnabled(this.currentParamsCopy.isFluff());
        JLabel jLabel3 = new JLabel("Fluff Node Density Cutoff");
        JPanel jPanel9 = new JPanel(new FlowLayout(0)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel9.setToolTipText(string3);
        jPanel9.add(jLabel3);
        jPanel9.add(this.fluffNodeDensityCutOffFormattedTextField);
        jPanel7.add(jPanel9);
        this.fluffCheckBox = new JCheckBox("Fluff", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.fluffCheckBox.addItemListener(new fluffCheckBoxAction());
        this.fluffCheckBox.setToolTipText("If checked, MCODE will fluff clusters\n(expand core cluster one neighbour shell outwards according to fluff\ndensity cutoff). This is done after the optional haircut step.");
        this.fluffCheckBox.setSelected(this.currentParamsCopy.isFluff());
        jPanel7.add(this.fluffCheckBox);
        jPanel5.setBorder(BorderFactory.createTitledBorder("Main Options"));
        jPanel7.setBorder(BorderFactory.createTitledBorder("Fluff Options"));
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jPanel7, "South");
        jPanel4.add((Component)jPanel5, "North");
        this.maxDepthFormattedTextField = new JFormattedTextField(decimalFormat){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.maxDepthFormattedTextField.setColumns(3);
        this.maxDepthFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string4 = "Sets the maximum depth from a seed node in the network to search to expand a cluster.\nBy default this is set to an arbitrarily large number. Set this to a small number\nto limit cluster size.";
        this.maxDepthFormattedTextField.setToolTipText(string4);
        this.maxDepthFormattedTextField.setText(new Integer(this.currentParamsCopy.getMaxDepthFromStart()).toString());
        JLabel jLabel4 = new JLabel("Max. Depth");
        JPanel jPanel10 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel10.setToolTipText(string4);
        jPanel10.add(jLabel4);
        jPanel10.add(this.maxDepthFormattedTextField);
        jPanel4.add((Component)jPanel10, "South");
        JPanel jPanel11 = new JPanel();
        this.processCheckBox = new JCheckBox("Preprocess network", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.processCheckBox.addItemListener(new processCheckBoxAction());
        this.processCheckBox.setToolTipText("If checked, MCODE will limit cluster expansion to the\ndirect neighborhood of the spawning node.  If unchecked, the cluster will be allowed\nto branch out to denser regions of the network.");
        this.processCheckBox.setSelected(this.currentParamsCopy.isPreprocessNetwork());
        jPanel11.add(this.processCheckBox);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Network Scoring", null, jPanel2, "Set parameters for scoring stage (Stage 1)");
        jTabbedPane.addTab("Find Clusters", null, jPanel4, "Set parameters for cluster finding stage (Stage 2)");
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel12 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new OKAction(this));
        jPanel12.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new cancelAction(this));
        jPanel12.add(jButton2);
        jPanel.add((Component)jPanel12, "South");
        this.setContentPane(jPanel);
    }

    private void saveParams() {
        MCODECurrentParameters.getInstance().setParams(this.currentParamsCopy);
    }

    private class processCheckBoxAction
    implements ItemListener {
        private processCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEParameterChangeDialog.this.currentParamsCopy.setPreprocessNetwork(false);
            } else {
                MCODEParameterChangeDialog.this.currentParamsCopy.setPreprocessNetwork(true);
            }
        }
    }

    private class fluffCheckBoxAction
    implements ItemListener {
        private fluffCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEParameterChangeDialog.this.currentParamsCopy.setFluff(false);
            } else {
                MCODEParameterChangeDialog.this.currentParamsCopy.setFluff(true);
            }
            MCODEParameterChangeDialog.this.fluffNodeDensityCutOffFormattedTextField.setEnabled(MCODEParameterChangeDialog.this.currentParamsCopy.isFluff());
        }
    }

    private class haircutCheckBoxAction
    implements ItemListener {
        private haircutCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEParameterChangeDialog.this.currentParamsCopy.setHaircut(false);
            } else {
                MCODEParameterChangeDialog.this.currentParamsCopy.setHaircut(true);
            }
        }
    }

    private class formattedTextFieldAction
    implements PropertyChangeListener {
        private formattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Number number;
            Object object = propertyChangeEvent.getSource();
            if (object == MCODEParameterChangeDialog.this.degreeCutOffFormattedTextField) {
                Number number2 = (Number)MCODEParameterChangeDialog.this.degreeCutOffFormattedTextField.getValue();
                if (number2 != null && number2.intValue() > 1) {
                    MCODEParameterChangeDialog.this.currentParamsCopy.setDegreeCutOff(number2.intValue());
                }
            } else if (object == MCODEParameterChangeDialog.this.maxDepthFormattedTextField) {
                Number number3 = (Number)MCODEParameterChangeDialog.this.maxDepthFormattedTextField.getValue();
                if (number3 != null && number3.intValue() > 0) {
                    MCODEParameterChangeDialog.this.currentParamsCopy.setMaxDepthFromStart(number3.intValue());
                }
            } else if (object == MCODEParameterChangeDialog.this.nodeScoreCutOffFormattedTextField) {
                Number number4 = (Number)MCODEParameterChangeDialog.this.nodeScoreCutOffFormattedTextField.getValue();
                if (number4 != null && number4.doubleValue() >= 0.0) {
                    MCODEParameterChangeDialog.this.currentParamsCopy.setNodeScoreCutOff(number4.doubleValue());
                }
            } else if (object == MCODEParameterChangeDialog.this.fluffNodeDensityCutOffFormattedTextField && (number = (Number)MCODEParameterChangeDialog.this.fluffNodeDensityCutOffFormattedTextField.getValue()) != null && number.doubleValue() >= 0.0) {
                MCODEParameterChangeDialog.this.currentParamsCopy.setFluffNodeDensityCutOff(number.doubleValue());
            }
        }
    }

    private class includeLoopsCheckBoxAction
    implements ItemListener {
        private includeLoopsCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEParameterChangeDialog.this.currentParamsCopy.setIncludeLoops(false);
            } else {
                MCODEParameterChangeDialog.this.currentParamsCopy.setIncludeLoops(true);
            }
        }
    }

    private class cancelAction
    extends AbstractAction {
        private JDialog dialog;

        cancelAction(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private JDialog dialog;

        OKAction(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MCODEParameterChangeDialog.this.saveParams();
            this.dialog.dispose();
        }
    }
}

