/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.JMultiLineToolTip;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

class MultiLineToolTipUI
extends BasicToolTipUI {
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    Font smallFont;
    static JToolTip tip;
    protected CellRendererPane rendererPane;
    private static JTextArea textArea;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        tip = (JToolTip)jComponent;
        this.rendererPane = new CellRendererPane();
        jComponent.add(this.rendererPane);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.remove(this.rendererPane);
        this.rendererPane = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        textArea.setBackground(jComponent.getBackground());
        this.rendererPane.paintComponent(graphics, textArea, jComponent, 1, 1, dimension.width - 1, dimension.height - 1, true);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return new Dimension(0, 0);
        }
        textArea = new JTextArea(string);
        this.rendererPane.removeAll();
        this.rendererPane.add(textArea);
        textArea.setWrapStyleWord(true);
        int n = ((JMultiLineToolTip)jComponent).getFixedWidth();
        int n2 = ((JMultiLineToolTip)jComponent).getColumns();
        if (n2 > 0) {
            textArea.setColumns(n2);
            textArea.setSize(0, 0);
            textArea.setLineWrap(true);
            textArea.setSize(textArea.getPreferredSize());
        } else if (n > 0) {
            textArea.setLineWrap(true);
            dimension = textArea.getPreferredSize();
            dimension.width = n;
            ++dimension.height;
            textArea.setSize(dimension);
        } else {
            textArea.setLineWrap(false);
        }
        dimension = textArea.getPreferredSize();
        ++dimension.height;
        ++dimension.width;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

