/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class MCODECollapsablePanel
extends JPanel {
    CollapsableTitledBorder border;
    Border collapsedBorderLine = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    Border expandedBorderLine = null;
    AbstractButton titleComponent;
    static final int COLLAPSED = 0;
    static final int EXPANDED = 1;
    ImageIcon[] iconArrow = this.createExpandAndCollapseIcon();
    JButton arrow = this.createArrowButton();
    JPanel panel;
    boolean collapsed;

    public MCODECollapsablePanel(JRadioButton jRadioButton) {
        jRadioButton.addItemListener(new ExpandAndCollapseAction());
        this.titleComponent = jRadioButton;
        this.collapsed = !jRadioButton.isSelected();
        this.commonConstructor();
    }

    public MCODECollapsablePanel(String string) {
        this.arrow.setText(string);
        this.titleComponent = this.arrow;
        this.collapsed = true;
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.setLayout(new BorderLayout());
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "Center");
        this.add((Component)this.panel, "Center");
        this.setCollapsed(this.collapsed);
        this.placeTitleComponent();
    }

    private void placeTitleComponent() {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.border.getComponentRect(rectangle, insets);
        this.titleComponent.setBounds(rectangle2);
    }

    public void setTitleComponentText(String string) {
        if (this.titleComponent instanceof JButton) {
            this.titleComponent.setText(string);
        }
        this.placeTitleComponent();
    }

    public JPanel getContentPane() {
        return this.panel;
    }

    public void setCollapsed(boolean bl) {
        if (bl) {
            this.remove(this.panel);
            this.arrow.setIcon(this.iconArrow[0]);
            this.border = new CollapsableTitledBorder(this.collapsedBorderLine, this.titleComponent);
        } else {
            this.add((Component)this.panel, "North");
            this.arrow.setIcon(this.iconArrow[1]);
            this.border = new CollapsableTitledBorder(this.expandedBorderLine, this.titleComponent);
        }
        this.setBorder(this.border);
        this.collapsed = bl;
        this.updateUI();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private ImageIcon[] createExpandAndCollapseIcon() {
        ImageIcon[] imageIconArray = new ImageIcon[2];
        URL uRL = MCODEPlugin.class.getResource("resources/arrow_collapsed.gif");
        if (uRL != null) {
            imageIconArray[0] = new ImageIcon(uRL);
        }
        if ((uRL = MCODEPlugin.class.getResource("resources/arrow_expanded.gif")) != null) {
            imageIconArray[1] = new ImageIcon(uRL);
        }
        return imageIconArray;
    }

    private JButton createArrowButton() {
        JButton jButton = new JButton("arrow", this.iconArrow[0]);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(2);
        jButton.setMargin(new Insets(0, 0, 3, 0));
        Font font = BorderFactory.createTitledBorder("Sample").getTitleFont();
        Color color = BorderFactory.createTitledBorder("Sample").getTitleColor();
        jButton.setFont(font);
        jButton.setForeground(color);
        jButton.setFocusable(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(new ExpandAndCollapseAction());
        return jButton;
    }

    private class CollapsableTitledBorder
    extends TitledBorder {
        JComponent component;

        public CollapsableTitledBorder(JComponent jComponent) {
            this(null, jComponent, 1, 2);
        }

        public CollapsableTitledBorder(Border border) {
            this(border, null, 1, 2);
        }

        public CollapsableTitledBorder(Border border, JComponent jComponent) {
            this(border, jComponent, 1, 2);
        }

        public CollapsableTitledBorder(Border border, JComponent jComponent, int n, int n2) {
            super(border, null, n, n2, null, null);
            this.component = jComponent;
            if (border == null) {
                this.border = super.getBorder();
            }
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
            Insets insets = this.border != null ? this.border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            Insets insets2 = this.getBorderInsets(component);
            Rectangle rectangle3 = this.getComponentRect(rectangle2, insets2);
            switch (this.titlePosition) {
                case 1: {
                    int n5 = rectangle3.height + 2;
                    rectangle.y += n5;
                    rectangle.height -= n5;
                    break;
                }
                case 0: 
                case 2: {
                    int n6 = insets2.top / 2 - insets.top - 2;
                    rectangle.y += n6;
                    rectangle.height -= n6;
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    int n7 = insets2.bottom / 2 - insets.bottom - 2;
                    rectangle.height -= n7;
                    break;
                }
                case 6: {
                    int n8 = rectangle3.height + 2;
                    rectangle.height -= n8;
                }
            }
            this.border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Color color = graphics.getColor();
            graphics.setColor(component.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.border != null ? this.border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
            insets.top = 4 + insets2.top;
            insets.right = 4 + insets2.right;
            insets.bottom = 4 + insets2.bottom;
            insets.left = 4 + insets2.left;
            if (component == null || this.component == null) {
                return insets;
            }
            int n = this.component.getPreferredSize().height;
            switch (this.titlePosition) {
                case 1: {
                    insets.top += n + 2;
                    break;
                }
                case 0: 
                case 2: {
                    insets.top += Math.max(n, insets2.top) - insets2.top;
                    break;
                }
                case 3: {
                    insets.top += n + 2;
                    break;
                }
                case 4: {
                    insets.bottom += n + 2;
                    break;
                }
                case 5: {
                    insets.bottom += Math.max(n, insets2.bottom) - insets2.bottom;
                    break;
                }
                case 6: {
                    insets.bottom += n + 2;
                }
            }
            return insets;
        }

        public JComponent getTitleComponent() {
            return this.component;
        }

        public void setTitleComponent(JComponent jComponent) {
            this.component = jComponent;
        }

        public Rectangle getComponentRect(Rectangle rectangle, Insets insets) {
            Dimension dimension = this.component.getPreferredSize();
            Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
            switch (this.titlePosition) {
                case 1: {
                    rectangle2.y = 2;
                    break;
                }
                case 0: 
                case 2: {
                    if (MCODECollapsablePanel.this.titleComponent instanceof JButton) {
                        rectangle2.y = 2 + (insets.top - 2 - 2 - dimension.height) / 2;
                        break;
                    }
                    if (!(MCODECollapsablePanel.this.titleComponent instanceof JRadioButton)) break;
                    rectangle2.y = (insets.top - 2 - 2 - dimension.height) / 2;
                    break;
                }
                case 3: {
                    rectangle2.y = insets.top - dimension.height - 2;
                    break;
                }
                case 4: {
                    rectangle2.y = rectangle.height - insets.bottom + 2;
                    break;
                }
                case 5: {
                    rectangle2.y = rectangle.height - insets.bottom + 2 + (insets.bottom - 2 - 2 - dimension.height) / 2;
                    break;
                }
                case 6: {
                    rectangle2.y = rectangle.height - dimension.height - 2;
                }
            }
            switch (this.titleJustification) {
                case 0: 
                case 1: {
                    rectangle2.x = 5 + insets.left - 2;
                    break;
                }
                case 3: {
                    rectangle2.x = rectangle.width - insets.right - 5 - rectangle2.width;
                    break;
                }
                case 2: {
                    rectangle2.x = (rectangle.width - rectangle2.width) / 2;
                }
            }
            return rectangle2;
        }
    }

    private class ExpandAndCollapseAction
    extends AbstractAction
    implements ActionListener,
    ItemListener {
        private ExpandAndCollapseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MCODECollapsablePanel.this.setCollapsed(!MCODECollapsablePanel.this.isCollapsed());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            MCODECollapsablePanel.this.setCollapsed(!MCODECollapsablePanel.this.isCollapsed());
        }
    }
}

