/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class MCODELoader
extends ImageIcon
implements Runnable {
    JTable table;
    int selectedRow;
    ImageIcon graphImage;
    BufferedImage onScreenLoader;
    BufferedImage offScreenLoader;
    Graphics2D onScreenG2;
    Graphics2D offScreenG2;
    Color bgColor;
    Color fgColor;
    double fadeInAlpha;
    int degreesForDisk;
    int fontSize;
    int progress;
    String process;
    Thread t;
    boolean loading;
    boolean loaderDisplayed;

    MCODELoader(JTable jTable, int n, int n2) {
        this.table = jTable;
        this.bgColor = jTable.getSelectionBackground();
        this.fgColor = jTable.getSelectionForeground();
        this.fontSize = 8;
        this.onScreenLoader = new BufferedImage(n, n2, 2);
        this.onScreenG2 = (Graphics2D)this.onScreenLoader.getGraphics();
        this.offScreenLoader = new BufferedImage(n, n2, 2);
        this.offScreenG2 = (Graphics2D)this.offScreenLoader.getGraphics();
        this.offScreenG2.setFont(new Font("Arial", 0, this.fontSize));
        this.offScreenG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setImage(this.onScreenLoader);
        this.loading = false;
        this.t = new Thread(this);
        this.t.start();
    }

    public void setLoader(int n, JTable jTable) {
        this.selectedRow = n;
        this.graphImage = (ImageIcon)jTable.getValueAt(n, 0);
        this.fadeInAlpha = 0.0;
        this.degreesForDisk = 0;
        this.progress = 0;
        this.process = "Starting";
        this.loaderDisplayed = false;
        this.loading = true;
    }

    public void run() {
        try {
            while (true) {
                if (this.loading) {
                    if (this.loading && !this.loaderDisplayed) {
                        Thread.sleep(500L);
                    }
                    if (this.loading) {
                        this.drawLoader();
                        if (this.loading && !this.loaderDisplayed) {
                            this.table.setValueAt(this, this.selectedRow, 0);
                            this.loaderDisplayed = true;
                        }
                        if (this.loading) {
                            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(this.selectedRow, 0);
                        }
                    }
                }
                Thread.sleep(30L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void loaded() {
        this.loading = false;
        this.loaderDisplayed = false;
    }

    private void drawLoader() {
        Graphics2D graphics2D = this.offScreenG2;
        BufferedImage bufferedImage = this.offScreenLoader;
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.setColor(this.bgColor);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n = Math.round(((float)bufferedImage.getWidth() - (float)this.graphImage.getIconWidth()) / 2.0f);
        int n2 = Math.round(((float)bufferedImage.getHeight() - (float)this.graphImage.getIconHeight()) / 2.0f);
        graphics2D.drawImage(this.graphImage.getImage(), n, n2, this.getImageObserver());
        this.fadeInAlpha = (int)(100.0 * this.fadeInAlpha) < 100 ? (this.fadeInAlpha += (1.0 - this.fadeInAlpha) / 10.0) : 1.0;
        graphics2D.setColor(this.bgColor);
        graphics2D.setColor(new Color(graphics2D.getColor().getRed(), graphics2D.getColor().getGreen(), graphics2D.getColor().getBlue(), (int)(200.0 * this.fadeInAlpha)));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n3 = 20;
        Ellipse2D.Double double_ = new Ellipse2D.Double(bufferedImage.getWidth() / 2 - n3, bufferedImage.getHeight() / 2 - n3, 2 * n3, 2 * n3);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(bufferedImage.getWidth() / 2 - n3 / 2, bufferedImage.getHeight() / 2 - n3 / 2, n3, n3);
        Area area = new Area(double_2);
        Area area2 = new Area(double_);
        area2.subtract(area);
        if (this.degreesForDisk >= 360) {
            this.degreesForDisk = 0;
        }
        double d = this.degreesForDisk;
        Point2D.Double double_3 = new Point2D.Double(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        Point2D.Double double_4 = new Point2D.Double();
        Point2D.Double double_5 = new Point2D.Double();
        Color color = Color.WHITE;
        Color color2 = Color.CYAN;
        double d2 = 1.0;
        double d3 = 255.0 * this.fadeInAlpha;
        n3 += 10;
        while ((int)d3 > 0) {
            double d4 = Math.PI * 2 * (d / 360.0);
            double d5 = Math.PI * 2 * ((d - 6.0) / 360.0);
            ((Point2D)double_4).setLocation((double)n3 * Math.cos(d4) + ((Point2D)double_3).getX(), (double)n3 * Math.sin(d4) + ((Point2D)double_3).getY());
            ((Point2D)double_5).setLocation((double)n3 * Math.cos(d5) + ((Point2D)double_3).getX(), (double)n3 * Math.sin(d5) + ((Point2D)double_3).getY());
            graphics2D.setColor(new Color((int)((double)color.getRed() * d2 + (double)color2.getRed() * (1.0 - d2)), (int)((double)color.getGreen() * d2 + (double)color2.getGreen() * (1.0 - d2)), (int)((double)color.getBlue() * d2 + (double)color2.getBlue() * (1.0 - d2)), (int)Math.rint(d3)));
            if ((int)(d2 * 100.0) > 0) {
                d2 -= d2 / 40.0;
            }
            int[] nArray = new int[]{(int)((Point2D)double_3).getX(), (int)((Point2D)double_4).getX(), (int)((Point2D)double_5).getX()};
            int[] nArray2 = new int[]{(int)((Point2D)double_3).getY(), (int)((Point2D)double_4).getY(), (int)((Point2D)double_5).getY()};
            Polygon polygon = new Polygon(nArray, nArray2, 3);
            Area area3 = new Area(polygon);
            area3.intersect(area2);
            graphics2D.fill(area3);
            d3 -= d3 / 20.0;
            d -= 2.0;
        }
        this.degreesForDisk += 15;
        String string = "LOADING";
        graphics2D.setColor(Color.WHITE);
        graphics2D.setColor(new Color(graphics2D.getColor().getRed(), graphics2D.getColor().getGreen(), graphics2D.getColor().getBlue(), (int)(255.0 * this.fadeInAlpha)));
        graphics2D.drawString(string, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string) / 2 - 1, bufferedImage.getHeight() / 2 + this.fontSize / 2 - 1);
        graphics2D.drawString(string, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string) / 2 - 1, bufferedImage.getHeight() / 2 + this.fontSize / 2 + 1);
        graphics2D.drawString(string, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string) / 2 + 1, bufferedImage.getHeight() / 2 + this.fontSize / 2 - 1);
        graphics2D.drawString(string, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string) / 2 + 1, bufferedImage.getHeight() / 2 + this.fontSize / 2 + 1);
        graphics2D.setColor(Color.RED);
        graphics2D.setColor(new Color(graphics2D.getColor().getRed(), graphics2D.getColor().getGreen(), graphics2D.getColor().getBlue(), (int)(255.0 * this.fadeInAlpha)));
        graphics2D.drawString(string, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string) / 2, bufferedImage.getHeight() / 2 + this.fontSize / 2);
        graphics2D.setColor(this.fgColor);
        graphics2D.drawString(this.process, 10, bufferedImage.getHeight() - 2);
        graphics2D.setColor(Color.BLUE);
        int n4 = 150 - (int)(50.0 * Math.abs(Math.sin(Math.PI * 2 * ((double)this.degreesForDisk / 2.0 / 360.0))));
        graphics2D.setColor(new Color(graphics2D.getColor().getRed(), graphics2D.getColor().getGreen(), graphics2D.getColor().getBlue(), n4));
        graphics2D.fillRect(10, bufferedImage.getHeight() - 20, (int)((double)this.progress / 100.0 * (double)(bufferedImage.getWidth() - 20)), 10);
        graphics2D.setColor(this.fgColor);
        graphics2D.setColor(new Color(graphics2D.getColor().getRed(), graphics2D.getColor().getGreen(), graphics2D.getColor().getBlue(), 100));
        graphics2D.drawRect(10, bufferedImage.getHeight() - 20, bufferedImage.getWidth() - 20, 10);
        String string2 = this.progress + "%";
        graphics2D.setColor(this.bgColor);
        graphics2D.drawString(string2, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string2) / 2 + 1, bufferedImage.getHeight() - 11);
        graphics2D.setColor(this.fgColor);
        graphics2D.drawString(string2, bufferedImage.getWidth() / 2 - fontMetrics.stringWidth(string2) / 2, bufferedImage.getHeight() - 12);
        this.onScreenG2.drawImage((Image)this.offScreenLoader, 0, 0, null);
    }

    public void setProgress(int n, String string) {
        this.progress = n;
        this.process = string;
    }
}

