/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODECluster;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEUtil;
import cytoscape.CyNetwork;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.awt.Image;

public class MCODEScoreAndFindTask
implements Task {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private CyNetwork network = null;
    private MCODEAlgorithm alg = null;
    private MCODECluster[] clusters = null;
    private Image[] imageList = null;
    private boolean completedSuccessfully = false;
    private int analyze;
    private String resultSet;

    public MCODEScoreAndFindTask(CyNetwork cyNetwork, int n, String string, MCODEAlgorithm mCODEAlgorithm) {
        this.network = cyNetwork;
        this.analyze = n;
        this.resultSet = string;
        this.alg = mCODEAlgorithm;
    }

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        try {
            this.alg.setTaskMonitor(this.taskMonitor, this.network.getIdentifier());
            if (this.analyze == 1) {
                this.taskMonitor.setPercentCompleted(0);
                this.taskMonitor.setStatus("Scoring Network (Step 1 of 3)");
                this.alg.scoreGraph(this.network, this.resultSet);
                if (this.interrupted) {
                    return;
                }
                System.err.println("Network was scored in " + this.alg.getLastScoreTime() + " ms.");
            }
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Finding Clusters (Step 2 of 3)");
            this.clusters = this.alg.findClusters(this.network, this.resultSet);
            if (this.interrupted) {
                return;
            }
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Drawing Results (Step 3 of 3)");
            this.clusters = MCODEUtil.sortClusters(this.clusters);
            this.imageList = new Image[this.clusters.length];
            MCODECurrentParameters.getInstance();
            int n = MCODECurrentParameters.getResultParams(this.resultSet).getDefaultRowHeight();
            for (int i = 0; i < this.clusters.length; ++i) {
                if (this.interrupted) {
                    return;
                }
                this.imageList[i] = MCODEUtil.convertNetworkToImage(null, this.clusters[i], n, n, null, true);
                this.taskMonitor.setPercentCompleted(i * 100 / this.clusters.length);
            }
            this.completedSuccessfully = true;
        }
        catch (Exception exception) {
            this.taskMonitor.setException((Throwable)exception, "MCODE cancelled");
        }
    }

    public boolean isCompletedSuccessfully() {
        return this.completedSuccessfully;
    }

    public MCODECluster[] getClusters() {
        return this.clusters;
    }

    public Image[] getImageList() {
        return this.imageList;
    }

    public void halt() {
        this.interrupted = true;
        this.alg.setCancelled(true);
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("MCODE Network Cluster Detection");
    }

    public MCODEAlgorithm getAlg() {
        return this.alg;
    }
}

