/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODECluster;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEParameterSet;
import cytoscape.CyNetwork;
import cytoscape.task.TaskMonitor;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class MCODEAlgorithm {
    private boolean cancelled = false;
    private TaskMonitor taskMonitor = null;
    private HashMap currentNodeInfoHashMap = null;
    private TreeMap currentNodeScoreSortedMap = null;
    private HashMap nodeScoreResultsMap = new HashMap();
    private HashMap nodeInfoResultsMap = new HashMap();
    private MCODEParameterSet params;
    private long lastScoreTime;
    private long lastFindTime;

    public MCODEAlgorithm(String string) {
        this.params = MCODECurrentParameters.getInstance().getParamsCopy(string);
    }

    public MCODEAlgorithm(TaskMonitor taskMonitor, String string) {
        this(string);
        this.taskMonitor = taskMonitor;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor, String string) {
        this.params = MCODECurrentParameters.getInstance().getParamsCopy(string);
        this.taskMonitor = taskMonitor;
    }

    public long getLastScoreTime() {
        return this.lastScoreTime;
    }

    public long getLastFindTime() {
        return this.lastFindTime;
    }

    public MCODEParameterSet getParams() {
        return this.params;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public Double getNodeScore(int n, String string) {
        Double d = new Double(0.0);
        TreeMap treeMap = (TreeMap)this.nodeScoreResultsMap.get(string);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            ArrayList arrayList = (ArrayList)treeMap.get(d);
            if (!arrayList.contains(new Integer(n))) continue;
            return d;
        }
        return d;
    }

    public double getMaxScore(String string) {
        TreeMap treeMap = (TreeMap)this.nodeScoreResultsMap.get(string);
        Double d = (Double)treeMap.firstKey();
        return d;
    }

    public void scoreGraph(CyNetwork cyNetwork, String string) {
        this.params = this.getParams();
        String string2 = "MCODEAlgorithm.MCODEAlgorithm";
        if (cyNetwork == null) {
            System.err.println("In " + string2 + ": inputNetwork was null.");
            return;
        }
        long l = System.currentTimeMillis();
        HashMap<Integer, NodeInfo> hashMap = new HashMap<Integer, NodeInfo>(cyNetwork.getNodeCount());
        TreeMap<Double, ArrayList> treeMap = new TreeMap<Double, ArrayList>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = (Double)object;
                if (d2 == (d = ((Double)object2).doubleValue())) {
                    return 0;
                }
                if (d2 < d) {
                    return 1;
                }
                return -1;
            }
        });
        NodeInfo nodeInfo = null;
        int n = 0;
        Iterator iterator = cyNetwork.nodesIterator();
        while (iterator.hasNext() && !this.cancelled) {
            ArrayList arrayList;
            Node node = (Node)iterator.next();
            nodeInfo = this.calcNodeInfo(cyNetwork, node.getRootGraphIndex());
            hashMap.put(new Integer(node.getRootGraphIndex()), nodeInfo);
            double d = this.scoreNode(nodeInfo);
            if (treeMap.containsKey(new Double(d))) {
                arrayList = (ArrayList)treeMap.get(new Double(d));
                arrayList.add(new Integer(node.getRootGraphIndex()));
            } else {
                arrayList = new ArrayList();
                arrayList.add(new Integer(node.getRootGraphIndex()));
                treeMap.put(new Double(d), arrayList);
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted(++n * 100 / cyNetwork.getNodeCount());
        }
        this.nodeScoreResultsMap.put(string, treeMap);
        this.nodeInfoResultsMap.put(string, hashMap);
        this.currentNodeScoreSortedMap = treeMap;
        this.currentNodeInfoHashMap = hashMap;
        long l2 = System.currentTimeMillis();
        this.lastScoreTime = l2 - l;
    }

    public MCODECluster[] findClusters(CyNetwork cyNetwork, String string) {
        GraphPerspective graphPerspective;
        ArrayList arrayList;
        Object object;
        Object object2;
        ArrayList arrayList2;
        HashMap hashMap;
        TreeMap treeMap;
        if (!this.nodeScoreResultsMap.containsKey(string)) {
            treeMap = this.currentNodeScoreSortedMap;
            hashMap = this.currentNodeInfoHashMap;
            this.nodeScoreResultsMap.put(string, treeMap);
            this.nodeInfoResultsMap.put(string, hashMap);
        } else {
            treeMap = (TreeMap)this.nodeScoreResultsMap.get(string);
            hashMap = (HashMap)this.nodeInfoResultsMap.get(string);
        }
        this.params = this.getParams();
        String string2 = "MCODEAlgorithm.findClusters";
        if (cyNetwork == null) {
            System.err.println("In " + string2 + ": inputNetwork was null.");
            return null;
        }
        if (hashMap == null || treeMap == null) {
            System.err.println("In " + string2 + ": nodeInfoHashMap or nodeScoreSortedMap was null.");
            return null;
        }
        long l = System.currentTimeMillis();
        HashMap hashMap2 = new HashMap();
        int n = 0;
        int n2 = 0;
        Collection collection = treeMap.values();
        Object object3 = collection.iterator();
        while (object3.hasNext()) {
            arrayList2 = (ArrayList)object3.next();
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                object2.next();
                ++n2;
            }
        }
        object3 = new ArrayList();
        object2 = collection.iterator();
        block2: while (object2.hasNext()) {
            arrayList2 = (ArrayList)object2.next();
            for (int i = 0; i < arrayList2.size(); ++i) {
                int n3;
                int n4;
                Integer n5 = (Integer)arrayList2.get(i);
                if (!hashMap2.containsKey(n5)) {
                    MCODECluster mCODECluster = new MCODECluster();
                    mCODECluster.setSeedNode(n5);
                    object = new HashMap((HashMap)hashMap2.clone());
                    arrayList = this.getClusterCore(n5, hashMap2, this.params.getNodeScoreCutoff(), this.params.getMaxDepthFromStart(), hashMap);
                    if (arrayList.size() > 0) {
                        if (!arrayList.contains(n5)) {
                            arrayList.add(n5);
                        }
                        if (!this.filterCluster(graphPerspective = this.createGraphPerspective(arrayList, cyNetwork))) {
                            if (this.params.isHaircut()) {
                                this.haircutCluster(graphPerspective, arrayList, (GraphPerspective)cyNetwork);
                            }
                            if (this.params.isFluff()) {
                                this.fluffClusterBoundary(arrayList, hashMap2, hashMap);
                            }
                            mCODECluster.setALCluster(arrayList);
                            graphPerspective = this.createGraphPerspective(arrayList, cyNetwork);
                            mCODECluster.setGPCluster(graphPerspective);
                            mCODECluster.setClusterScore(this.scoreCluster(mCODECluster));
                            mCODECluster.setNodeSeenHashMap((HashMap)object);
                            mCODECluster.setResultTitle(string);
                            ((ArrayList)object3).add(mCODECluster);
                        }
                    }
                }
                if (this.taskMonitor != null && (n4 = ++n * 100 / n2) != (n3 = (n - 1) * 100 / n2)) {
                    this.taskMonitor.setPercentCompleted(n4);
                }
                if (this.cancelled) continue block2;
            }
        }
        object2 = new ArrayList();
        if (!this.params.getScope().equals(MCODEParameterSet.NETWORK)) {
            Iterator iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                int n6;
                object = (MCODECluster)iterator.next();
                arrayList = ((MCODECluster)object).getALCluster();
                graphPerspective = new ArrayList();
                for (n6 = 0; n6 < this.params.getSelectedNodes().length; ++n6) {
                    graphPerspective.add(this.params.getSelectedNodes()[n6]);
                }
                n6 = 0;
                Iterator iterator2 = graphPerspective.iterator();
                while (iterator2.hasNext()) {
                    if (!arrayList.contains((Integer)iterator2.next())) continue;
                    n6 = 1;
                }
                if (n6 == 0) continue;
                ((ArrayList)object2).add(object);
            }
            object3 = object2;
        }
        MCODECluster[] mCODEClusterArray = new MCODECluster[((ArrayList)object3).size()];
        for (int i = 0; i < mCODEClusterArray.length; ++i) {
            mCODEClusterArray[i] = (MCODECluster)((ArrayList)object3).get(i);
        }
        long l2 = System.currentTimeMillis();
        this.lastFindTime = l2 - l;
        return mCODEClusterArray;
    }

    public MCODECluster exploreCluster(MCODECluster mCODECluster, double d, CyNetwork cyNetwork, String string) {
        HashMap hashMap = (HashMap)this.nodeInfoResultsMap.get(string);
        MCODEParameterSet mCODEParameterSet = MCODECurrentParameters.getResultParams(mCODECluster.getResultTitle());
        HashMap hashMap2 = d <= mCODEParameterSet.getNodeScoreCutoff() ? new HashMap(mCODECluster.getNodeSeenHashMap()) : new HashMap();
        Integer n = mCODECluster.getSeedNode();
        ArrayList arrayList = this.getClusterCore(n, hashMap2, d, mCODEParameterSet.getMaxDepthFromStart(), hashMap);
        if (!arrayList.contains(n)) {
            arrayList.add(n);
        }
        GraphPerspective graphPerspective = this.createGraphPerspective(arrayList, cyNetwork);
        if (mCODEParameterSet.isHaircut()) {
            this.haircutCluster(graphPerspective, arrayList, (GraphPerspective)cyNetwork);
        }
        if (mCODEParameterSet.isFluff()) {
            this.fluffClusterBoundary(arrayList, hashMap2, hashMap);
        }
        mCODECluster.setALCluster(arrayList);
        graphPerspective = this.createGraphPerspective(arrayList, cyNetwork);
        mCODECluster.setGPCluster(graphPerspective);
        mCODECluster.setClusterScore(this.scoreCluster(mCODECluster));
        return mCODECluster;
    }

    private GraphPerspective createGraphPerspective(ArrayList arrayList, CyNetwork cyNetwork) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            nArray[i] = n = ((Integer)arrayList.get(i)).intValue();
        }
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        return graphPerspective;
    }

    private double scoreNode(NodeInfo nodeInfo) {
        nodeInfo.score = nodeInfo.numNodeNeighbors > this.params.getDegreeCutoff() ? nodeInfo.coreDensity * (double)nodeInfo.coreLevel : 0.0;
        return nodeInfo.score;
    }

    public double scoreCluster(MCODECluster mCODECluster) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        n = mCODECluster.getGPCluster().getNodeCount();
        d = this.calcDensity(mCODECluster.getGPCluster(), true);
        d2 = d * (double)n;
        return d2;
    }

    private NodeInfo calcNodeInfo(CyNetwork cyNetwork, int n) {
        int[] nArray;
        String string = "MCODEAlgorithm.calcNodeInfo";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int[] nArray2 = cyNetwork.neighborsArray(n);
        if (nArray2.length < 2) {
            NodeInfo nodeInfo = new NodeInfo();
            if (nArray2.length == 1) {
                nodeInfo.coreLevel = 1;
                nodeInfo.coreDensity = 1.0;
                nodeInfo.density = 1.0;
            }
            return nodeInfo;
        }
        Arrays.sort(nArray2);
        if (Arrays.binarySearch(nArray2, n) < 0) {
            nArray = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray, 1, nArray2.length);
            nArray[0] = n;
        } else {
            nArray = nArray2;
        }
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpNodeNeighborhood was null.");
            return null;
        }
        NodeInfo nodeInfo = new NodeInfo();
        if (graphPerspective != null) {
            nodeInfo.density = this.calcDensity(graphPerspective, this.params.isIncludeLoops());
        }
        nodeInfo.numNodeNeighbors = nArray.length;
        GraphPerspective graphPerspective2 = null;
        Integer n2 = null;
        Object[] objectArray = this.getHighestKCore(graphPerspective);
        n2 = (Integer)objectArray[0];
        graphPerspective2 = (GraphPerspective)objectArray[1];
        nodeInfo.coreLevel = n2;
        if (graphPerspective2 != null) {
            nodeInfo.coreDensity = this.calcDensity(graphPerspective2, this.params.isIncludeLoops());
        }
        nodeInfo.nodeNeighbors = nArray;
        return nodeInfo;
    }

    private ArrayList getClusterCore(Integer n, HashMap hashMap, double d, int n2, HashMap hashMap2) {
        ArrayList arrayList = new ArrayList();
        this.getClusterCoreInternal(n, hashMap, ((NodeInfo)hashMap2.get((Object)n)).score, 1, arrayList, d, n2, hashMap2);
        return arrayList;
    }

    private boolean getClusterCoreInternal(Integer n, HashMap hashMap, double d, int n2, ArrayList arrayList, double d2, int n3, HashMap hashMap2) {
        if (hashMap.containsKey(n)) {
            return true;
        }
        hashMap.put(n, new Boolean(true));
        if (n2 > n3) {
            return true;
        }
        int n4 = 0;
        for (n4 = 0; n4 < ((NodeInfo)hashMap2.get((Object)n)).numNodeNeighbors; ++n4) {
            Integer n5 = new Integer(((NodeInfo)hashMap2.get((Object)n)).nodeNeighbors[n4]);
            if (hashMap.containsKey(n5) || !(((NodeInfo)hashMap2.get((Object)n5)).score >= d - d * d2)) continue;
            if (!arrayList.contains(n5)) {
                arrayList.add(n5);
            }
            this.getClusterCoreInternal(n5, hashMap, d, n2 + 1, arrayList, d2, n3, hashMap2);
        }
        return true;
    }

    private boolean fluffClusterBoundary(ArrayList arrayList, HashMap hashMap, HashMap hashMap2) {
        int n = 0;
        int n2 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        HashMap<Integer, Boolean> hashMap3 = new HashMap<Integer, Boolean>();
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i);
            for (int j = 0; j < ((NodeInfo)hashMap2.get((Object)new Integer((int)n))).numNodeNeighbors; ++j) {
                n2 = ((NodeInfo)hashMap2.get((Object)new Integer((int)n))).nodeNeighbors[j];
                if (hashMap.containsKey(new Integer(n2)) || hashMap3.containsKey(new Integer(n2))) continue;
                Integer n3 = new Integer(n2);
                if (!(((NodeInfo)hashMap2.get((Object)n3)).density > this.params.getFluffNodeDensityCutoff())) continue;
                arrayList2.add(new Integer(n2));
                hashMap3.put(new Integer(n2), new Boolean(true));
            }
        }
        if (arrayList2.size() > 0) {
            arrayList.addAll(arrayList2.subList(0, arrayList2.size()));
        }
        return true;
    }

    private boolean filterCluster(GraphPerspective graphPerspective) {
        if (graphPerspective == null) {
            return true;
        }
        GraphPerspective graphPerspective2 = this.getKCore(graphPerspective, this.params.getKCore());
        return graphPerspective2 == null;
    }

    private boolean haircutCluster(GraphPerspective graphPerspective, ArrayList arrayList, GraphPerspective graphPerspective2) {
        GraphPerspective graphPerspective3 = this.getKCore(graphPerspective, 2);
        if (graphPerspective3 != null) {
            arrayList.clear();
            int[] nArray = graphPerspective3.getNodeIndicesArray();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Integer(graphPerspective2.getRootGraphNodeIndex(nArray[i])));
            }
        }
        return true;
    }

    public double calcDensity(GraphPerspective graphPerspective, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        String string = "MCODEAlgorithm.calcDensity";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return -1.0;
        }
        if (bl) {
            Iterator iterator = graphPerspective.nodesIterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!graphPerspective.isNeighbor(node, node)) continue;
                ++n3;
            }
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount() - n3;
        } else {
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount();
        }
        d = (double)n2 / (double)n;
        return d;
    }

    public GraphPerspective getKCore(GraphPerspective graphPerspective, int n) {
        String string = "MCODEAlgorithm.getKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        boolean bl = true;
        GraphPerspective graphPerspective2 = null;
        while (true) {
            Object object;
            int n2 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(graphPerspective.getNodeCount());
            Iterator iterator = graphPerspective.nodesIterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                if (graphPerspective.getDegree(object) >= n) {
                    arrayList.add(new Integer(object.getRootGraphIndex()));
                    continue;
                }
                ++n2;
            }
            if (n2 <= 0 && !bl) break;
            object = new int[arrayList.size()];
            int n3 = 0;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                object[n3] = (Node)((Integer)iterator2.next());
                ++n3;
            }
            graphPerspective2 = graphPerspective.createGraphPerspective((int[])object);
            if (graphPerspective2.getNodeCount() == 0) {
                return null;
            }
            graphPerspective = graphPerspective2;
            if (!bl) continue;
            bl = false;
        }
        return graphPerspective2;
    }

    public Object[] getHighestKCore(GraphPerspective graphPerspective) {
        String string = "MCODEAlgorithm.getHighestKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int n = 1;
        GraphPerspective graphPerspective2 = null;
        GraphPerspective graphPerspective3 = null;
        while ((graphPerspective2 = this.getKCore(graphPerspective, n)) != null) {
            graphPerspective = graphPerspective2;
            graphPerspective3 = graphPerspective2;
            ++n;
        }
        Integer n2 = new Integer(n - 1);
        Object[] objectArray = new Object[]{n2, graphPerspective3};
        return objectArray;
    }

    private class NodeInfo {
        double density = 0.0;
        int numNodeNeighbors = 0;
        int[] nodeNeighbors;
        int coreLevel = 0;
        double coreDensity = 0.0;
        double score;
    }
}

