/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.JMultiLineToolTip;
import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODECluster;
import csplugins.mcode.MCODECollapsiblePanel;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODELoader;
import csplugins.mcode.MCODEParameterSet;
import csplugins.mcode.MCODEUtil;
import csplugins.mcode.SpringEmbeddedLayouter;
import csplugins.mcode.SwingWorker;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.data.CyAttributes;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import ding.view.DGraphView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class MCODEResultsPanel
extends JPanel {
    protected String resultTitle;
    protected MCODEAlgorithm alg;
    protected MCODECluster[] clusters;
    protected JTable table;
    protected MCODEClusterBrowserTableModel modelBrowser;
    protected final int graphPicSize = 80;
    protected final int defaultRowHeight = 88;
    protected int preferredTableWidth = 0;
    CyNetwork network;
    CyNetworkView networkView;
    MCODECollapsiblePanel explorePanel;
    JPanel[] exploreContent;
    MCODEParameterSet currentParamsCopy;
    int enumerationSelection = 0;
    GraphDrawer drawer;
    MCODELoader loader;

    public MCODEResultsPanel(MCODECluster[] mCODEClusterArray, MCODEAlgorithm mCODEAlgorithm, CyNetwork cyNetwork, Image[] imageArray, String string) {
        this.setLayout(new BorderLayout());
        this.alg = mCODEAlgorithm;
        this.resultTitle = string;
        this.clusters = mCODEClusterArray;
        this.network = cyNetwork;
        this.networkView = Cytoscape.getNetworkView((String)cyNetwork.getIdentifier());
        MCODECurrentParameters.getInstance();
        this.currentParamsCopy = MCODECurrentParameters.getResultParams(string);
        JPanel jPanel = this.createClusterBrowserPanel(imageArray);
        JPanel jPanel2 = this.createBottomPanel();
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.drawer = new GraphDrawer();
        this.loader = new MCODELoader(this.table, 80, 80);
        this.setSize(this.getMinimumSize());
    }

    private JPanel createClusterBrowserPanel(Image[] imageArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Cluster Browser"));
        this.modelBrowser = new MCODEClusterBrowserTableModel(imageArray);
        this.table = new JTable(this.modelBrowser);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(StringBuffer.class, new JTextAreaRenderer(88));
        this.table.setIntercellSpacing(new Dimension(0, 4));
        this.table.setFocusable(false);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new TableRowSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.explorePanel = new MCODECollapsiblePanel("Explore");
        this.explorePanel.setCollapsed(false);
        this.explorePanel.setVisible(false);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Export");
        jButton.addActionListener(new ExportAction());
        jButton.setToolTipText("Export result set to a text file");
        JButton jButton2 = new JButton("Discard Result");
        jButton2.addActionListener(new CloseAction(this));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)this.explorePanel, "North");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createExploreContent(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Size Threshold"));
        JSlider jSlider = new JSlider(0, 0, 1000, (int)(this.currentParamsCopy.getNodeScoreCutoff() * 1000.0)){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jSlider.setMajorTickSpacing(200);
        jSlider.setMinorTickSpacing(50);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("Min"));
        hashtable.put(new Integer(1000), new JLabel("Max"));
        hashtable.put(new Integer((int)(this.currentParamsCopy.getNodeScoreCutoff() * 1000.0)), new JLabel("^"));
        jSlider.setLabelTable(hashtable);
        jSlider.setFont(new Font("Arial", 0, 8));
        String string = "Move the slider to include or\nexclude nodes from the cluster";
        jSlider.setToolTipText(string);
        jPanel2.add((Component)jSlider, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Node Attribute Enumerator"));
        String[] stringArray = Cytoscape.getNodeAttributes().getAttributeNames();
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = "Please Select";
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jSlider.addChangeListener(new SizeAction(n, jComboBox));
        MCODEResultsEnumeratorTableModel mCODEResultsEnumeratorTableModel = new MCODEResultsEnumeratorTableModel(new HashMap());
        JTable jTable = new JTable(mCODEResultsEnumeratorTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jTable.setPreferredScrollableViewportSize(new Dimension(100, 80));
        jTable.setGridColor(Color.LIGHT_GRAY);
        jTable.setFont(new Font(jTable.getFont().getFontName(), 0, 11));
        jTable.setDefaultRenderer(StringBuffer.class, new JTextAreaRenderer(0));
        jTable.setFocusable(false);
        jComboBox.addActionListener(new enumerateAction(jTable, mCODEResultsEnumeratorTableModel, n));
        jPanel3.add(jComboBox, "North");
        jPanel3.add((Component)jScrollPane, "South");
        JPanel jPanel4 = this.createBottomExplorePanel(n);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createBottomExplorePanel(int n) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Create Sub-Network");
        jButton.addActionListener(new CreateChildAction(this, n));
        jPanel.add(jButton);
        return jPanel;
    }

    public double setNodeAttributesAndGetMaxScore() {
        Cytoscape.getNodeAttributes().deleteAttribute("MCODE_Cluster");
        Iterator iterator = this.network.nodesIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            int n = node.getRootGraphIndex();
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "MCODE_Node_Status", "Unclustered");
            for (int i = 0; i < this.clusters.length; ++i) {
                MCODECluster mCODECluster = this.clusters[i];
                if (!mCODECluster.getALCluster().contains(new Integer(n))) continue;
                ArrayList arrayList = new ArrayList();
                if (Cytoscape.getNodeAttributes().getAttributeList(node.getIdentifier(), "MCODE_Cluster") != null) {
                    arrayList = (ArrayList)Cytoscape.getNodeAttributes().getAttributeList(node.getIdentifier(), "MCODE_Cluster");
                    arrayList.add(mCODECluster.getClusterName());
                } else {
                    arrayList.add(mCODECluster.getClusterName());
                }
                this.setAttributeList(Cytoscape.getNodeAttributes(), node.getIdentifier(), "MCODE_Cluster", arrayList);
                if (mCODECluster.getSeedNode() == n) {
                    Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "MCODE_Node_Status", "Seed");
                    continue;
                }
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "MCODE_Node_Status", "Clustered");
            }
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "MCODE_Score", this.alg.getNodeScore(node.getRootGraphIndex(), this.resultTitle));
        }
        return this.alg.getMaxScore(this.resultTitle);
    }

    private void setAttributeList(CyAttributes cyAttributes, String string, String string2, List list) {
        for (String string3 : new String[]{"getAttributeList", "getListAttribute"}) {
            try {
                Method method = cyAttributes.getClass().getMethod(string3, String.class, String.class, List.class);
                method.invoke((Object)string, string2, list);
                return;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private StringBuffer getClusterDetails(MCODECluster mCODECluster) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Rank: ");
        stringBuffer.append(new Integer(mCODECluster.getRank() + 1).toString());
        stringBuffer.append("\n");
        stringBuffer.append("Score: ");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        stringBuffer.append(numberFormat.format(mCODECluster.getClusterScore()));
        stringBuffer.append("\n");
        stringBuffer.append("Nodes: ");
        stringBuffer.append(mCODECluster.getGPCluster().getNodeCount());
        stringBuffer.append("\n");
        stringBuffer.append("Edges: ");
        stringBuffer.append(mCODECluster.getGPCluster().getEdgeCount());
        return stringBuffer;
    }

    private ArrayList sortMap(Map map) {
        ArrayList<Map.Entry> arrayList = null;
        int n = 0;
        Set set = null;
        Map.Entry[] entryArray = null;
        set = map.entrySet();
        Iterator iterator = set.iterator();
        entryArray = new Map.Entry[set.size()];
        while (iterator.hasNext()) {
            entryArray[n++] = iterator.next();
        }
        Arrays.sort(entryArray, new Comparator(){

            public int compareTo(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((Comparable)entry.getValue()).compareTo((Comparable)entry2.getValue());
            }

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((Comparable)entry.getValue()).compareTo((Comparable)entry2.getValue());
            }
        });
        arrayList = new ArrayList<Map.Entry>();
        for (int i = 0; i < entryArray.length; ++i) {
            arrayList.add(entryArray[i]);
        }
        return arrayList;
    }

    public void selectCluster(GraphPerspective graphPerspective) {
        if (graphPerspective != null) {
            if (this.networkView != null) {
                GinyUtils.deselectAllNodes((GraphView)this.networkView);
                this.network.setSelectedNodeState((Collection)graphPerspective.nodesList(), true);
                if (Cytoscape.getDesktop().getCytoPanel(3).getState() == CytoPanelState.DOCK) {
                    Cytoscape.getDesktop().setFocus(this.networkView.getIdentifier());
                }
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "You must have a network view\ncreated to select nodes.", "No Network View", 1);
            }
        } else if (this.networkView != null) {
            GinyUtils.deselectAllNodes((GraphView)this.networkView);
        }
    }

    public String getResultTitle() {
        return this.resultTitle;
    }

    public void setResultTitle(String string) {
        this.resultTitle = string;
    }

    public JTable getClusterBrowserTable() {
        return this.table;
    }

    private class GraphDrawer
    implements Runnable {
        private Thread t;
        private boolean drawGraph = false;
        private boolean placeHolderDrawn;
        private boolean drawPlaceHolder = false;
        MCODECluster cluster;
        SpringEmbeddedLayouter layouter = new SpringEmbeddedLayouter();
        SizeAction trigger;
        boolean layoutNecessary;
        boolean clusterSelected;

        GraphDrawer() {
            this.t = new Thread(this);
            this.t.start();
        }

        public void drawGraph(MCODECluster mCODECluster, boolean bl, SizeAction sizeAction, boolean bl2) {
            this.cluster = mCODECluster;
            this.trigger = sizeAction;
            this.layoutNecessary = bl;
            this.drawGraph = !bl2;
            this.drawPlaceHolder = bl2;
            this.clusterSelected = false;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Image image;
                    if (this.drawGraph && !this.drawPlaceHolder) {
                        image = MCODEUtil.convertNetworkToImage(MCODEResultsPanel.this.loader, this.cluster, 80, 80, this.layouter, this.layoutNecessary);
                        if (image != null && this.drawGraph) {
                            MCODEResultsPanel.this.loader.setProgress(100, "Selecting Nodes");
                            MCODEResultsPanel.this.selectCluster(this.cluster.getGPCluster());
                            this.clusterSelected = true;
                            MCODEResultsPanel.this.table.setValueAt(new ImageIcon(image), this.cluster.getRank(), 0);
                            this.trigger.loaderSet = false;
                            MCODEResultsPanel.this.loader.loaded();
                            this.drawGraph = false;
                        }
                        this.placeHolderDrawn = false;
                    } else if (this.drawPlaceHolder && !this.placeHolderDrawn) {
                        image = MCODEUtil.getPlaceHolderImage(80, 80);
                        MCODEResultsPanel.this.table.setValueAt(new ImageIcon(image), this.cluster.getRank(), 0);
                        MCODEResultsPanel.this.selectCluster(this.cluster.getGPCluster());
                        this.trigger.loaderSet = false;
                        MCODEResultsPanel.this.loader.loaded();
                        this.drawGraph = false;
                        this.placeHolderDrawn = true;
                    } else if (!this.drawGraph && this.drawPlaceHolder && !this.clusterSelected) {
                        MCODEResultsPanel.this.selectCluster(this.cluster.getGPCluster());
                        this.clusterSelected = true;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        public void interruptDrawing() {
            this.drawGraph = false;
            this.layouter.interruptDoLayout();
            MCODEUtil.interruptLoading();
        }
    }

    private class SizeAction
    implements ChangeListener {
        private int selectedRow;
        public boolean loaderSet = false;
        private JComboBox nodeAttributesComboBox;
        private GraphDrawer drawer;
        private boolean drawPlaceHolder;

        SizeAction(int n, JComboBox jComboBox) {
            this.selectedRow = n;
            this.nodeAttributesComboBox = jComboBox;
            this.drawer = new GraphDrawer();
            this.loaderSet = false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            double d = (double)jSlider.getValue() / 1000.0;
            ArrayList arrayList = MCODEResultsPanel.this.clusters[this.selectedRow].getALCluster();
            MCODECluster mCODECluster = MCODEResultsPanel.this.alg.exploreCluster(MCODEResultsPanel.this.clusters[this.selectedRow], d, MCODEResultsPanel.this.network, MCODEResultsPanel.this.resultTitle);
            ArrayList arrayList2 = mCODECluster.getALCluster();
            boolean bl = this.drawPlaceHolder = arrayList2.size() > 300;
            if (!arrayList2.equals(arrayList)) {
                this.drawer.interruptDrawing();
                MCODEResultsPanel.this.clusters[this.selectedRow] = mCODECluster;
                StringBuffer stringBuffer = MCODEResultsPanel.this.getClusterDetails(mCODECluster);
                MCODEResultsPanel.this.table.setValueAt(stringBuffer, this.selectedRow, 1);
                this.nodeAttributesComboBox.setSelectedIndex(this.nodeAttributesComboBox.getSelectedIndex());
                if (!this.loaderSet && !this.drawPlaceHolder) {
                    MCODEResultsPanel.this.loader.setLoader(this.selectedRow, MCODEResultsPanel.this.table);
                    this.loaderSet = true;
                }
                boolean bl2 = arrayList2.size() > arrayList.size();
                this.drawer.drawGraph(mCODECluster, bl2, this, this.drawPlaceHolder);
            }
        }
    }

    private class JTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        int minHeight;

        public JTextAreaRenderer(int n) {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.setFont(new Font(this.getFont().getFontName(), 0, 11));
            this.minHeight = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StringBuffer stringBuffer = (StringBuffer)object;
            this.setText(stringBuffer.toString());
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            int n3 = jTable.getRowHeight(n);
            int n4 = jTable.getRowMargin();
            this.setSize(jTable.getColumnModel().getColumn(n2).getWidth(), n3 - 2 * n4);
            int n5 = (int)this.getPreferredSize().getHeight();
            if (n3 != Math.max(n5 + 2 * n4, this.minHeight + 2 * n4)) {
                jTable.setRowHeight(n, Math.max(n5 + 2 * n4, this.minHeight + 2 * n4));
            }
            return this;
        }
    }

    private class TableRowSelectionHandler
    implements ListSelectionListener {
        private TableRowSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                GraphPerspective graphPerspective = MCODEResultsPanel.this.clusters[n].getGPCluster();
                MCODEResultsPanel.this.selectCluster(graphPerspective);
                if (MCODEResultsPanel.this.exploreContent[n] == null) {
                    MCODEResultsPanel.this.exploreContent[n] = MCODEResultsPanel.this.createExploreContent(n);
                }
                if (MCODEResultsPanel.this.explorePanel.isVisible()) {
                    MCODEResultsPanel.this.explorePanel.getContentPane().remove(0);
                }
                MCODEResultsPanel.this.explorePanel.getContentPane().add((Component)MCODEResultsPanel.this.exploreContent[n], "Center");
                if (!MCODEResultsPanel.this.explorePanel.isVisible()) {
                    MCODEResultsPanel.this.explorePanel.setVisible(true);
                }
                String string = "Explore: ";
                string = MCODEResultsPanel.this.clusters[n].getClusterName() != null ? string + MCODEResultsPanel.this.clusters[n].getClusterName() : string + "Cluster " + (n + 1);
                MCODEResultsPanel.this.explorePanel.setTitleComponentText(string);
                MCODEResultsPanel.this.explorePanel.updateUI();
                JComboBox jComboBox = (JComboBox)((JPanel)MCODEResultsPanel.this.exploreContent[n].getComponent(1)).getComponent(0);
                jComboBox.setSelectedIndex(MCODEResultsPanel.this.enumerationSelection);
            }
        }
    }

    private class ExportAction
    extends AbstractAction {
        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileUtil.getFile((String)"Export Graph as Interactions", (int)FileUtil.SAVE, (CyFileFilter[])new CyFileFilter[0]);
            if (file != null) {
                String string = file.getAbsolutePath();
                MCODEUtil.exportMCODEResults(MCODEResultsPanel.this.alg, MCODEResultsPanel.this.clusters, MCODEResultsPanel.this.network, string);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        MCODEResultsPanel trigger;

        CloseAction(MCODEResultsPanel mCODEResultsPanel2) {
            this.trigger = mCODEResultsPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
            CytoPanel cytoPanel = cytoscapeDesktop.getCytoPanel(3);
            String string = "You are about to dispose of " + MCODEResultsPanel.this.resultTitle + ".\nDo you wish to continue?";
            int n = JOptionPane.showOptionDialog((Component)Cytoscape.getDesktop(), new Object[]{string}, "Confirm", 0, 3, null, null, null);
            if (n == 0) {
                cytoPanel.remove((Component)this.trigger);
                MCODECurrentParameters.removeResultParams(MCODEResultsPanel.this.getResultTitle());
            }
            if (cytoPanel.getCytoPanelComponentCount() == 0) {
                cytoPanel.setState(CytoPanelState.HIDE);
            }
        }
    }

    private class enumerateAction
    extends AbstractAction {
        JTable enumerationsTable;
        int selectedRow;
        MCODEResultsEnumeratorTableModel modelEnumerator;

        enumerateAction(JTable jTable, MCODEResultsEnumeratorTableModel mCODEResultsEnumeratorTableModel, int n) {
            this.selectedRow = n;
            this.enumerationsTable = jTable;
            this.modelEnumerator = mCODEResultsEnumeratorTableModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
            if (!string.equals("Please Select")) {
                Iterator iterator = MCODEResultsPanel.this.clusters[this.selectedRow].getGPCluster().nodesIterator();
                while (iterator.hasNext()) {
                    Integer n2;
                    Object object;
                    Node node = (Node)iterator.next();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (Cytoscape.getNodeAttributes().getType(string) == 4) {
                        arrayList.add(Cytoscape.getNodeAttributes().getStringAttribute(node.getIdentifier(), string));
                    } else if (Cytoscape.getNodeAttributes().getType(string) == 2) {
                        arrayList.add(Cytoscape.getNodeAttributes().getDoubleAttribute(node.getIdentifier(), string));
                    } else if (Cytoscape.getNodeAttributes().getType(string) == 3) {
                        arrayList.add(Cytoscape.getNodeAttributes().getIntegerAttribute(node.getIdentifier(), string));
                    } else if (Cytoscape.getNodeAttributes().getType(string) == 1) {
                        arrayList.add(Cytoscape.getNodeAttributes().getBooleanAttribute(node.getIdentifier(), string));
                    } else if (Cytoscape.getNodeAttributes().getType(string) == -2) {
                        object = Cytoscape.getNodeAttributes().getAttributeList(node.getIdentifier(), string);
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            arrayList.add(iterator2.next());
                        }
                    } else if (Cytoscape.getNodeAttributes().getType(string) == -3) {
                        object = Cytoscape.getNodeAttributes().getAttributeMap(node.getIdentifier(), string);
                        for (String string2 : object.keySet()) {
                            n2 = object.get(string2);
                            arrayList.add(new String(string2 + " -> " + n2));
                        }
                    }
                    for (Object e : arrayList) {
                        String string2;
                        if (e == null) continue;
                        string2 = e.toString();
                        if (!hashMap.containsKey(string2)) {
                            hashMap.put(string2, new Integer(1));
                            continue;
                        }
                        n2 = (Integer)hashMap.get(string2);
                        n2 = new Integer(n2 + 1);
                        hashMap.put(string2, n2);
                    }
                }
            }
            this.modelEnumerator.listIt(hashMap);
            MCODEResultsPanel.this.enumerationSelection = n;
        }
    }

    private class MCODEResultsEnumeratorTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Value", "Occurrence"};
        Object[][] data = new Object[0][this.columnNames.length];

        public MCODEResultsEnumeratorTableModel(HashMap hashMap) {
            this.listIt(hashMap);
        }

        public void listIt(HashMap hashMap) {
            ArrayList arrayList = MCODEResultsPanel.this.sortMap(hashMap);
            Object[][] objectArray = new Object[arrayList.size()][this.columnNames.length];
            int n = arrayList.size() - 1;
            for (Map.Entry entry : arrayList) {
                objectArray[n][0] = new StringBuffer(entry.getKey().toString());
                objectArray[n][1] = new String(entry.getValue().toString());
                --n;
            }
            if (this.getRowCount() == objectArray.length) {
                this.data = new Object[objectArray.length][this.columnNames.length];
                System.arraycopy(objectArray, 0, this.data, 0, this.data.length);
                this.fireTableRowsUpdated(0, this.getRowCount());
            } else {
                this.data = new Object[objectArray.length][this.columnNames.length];
                System.arraycopy(objectArray, 0, this.data, 0, this.data.length);
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class MCODEClusterBrowserTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Network", "Details"};
        Object[][] data;

        public MCODEClusterBrowserTableModel(Image[] imageArray) {
            MCODEResultsPanel.this.exploreContent = new JPanel[MCODEResultsPanel.this.clusters.length];
            this.data = new Object[MCODEResultsPanel.this.clusters.length][this.columnNames.length];
            for (int i = 0; i < MCODEResultsPanel.this.clusters.length; ++i) {
                MCODEResultsPanel.this.clusters[i].setRank(i);
                StringBuffer stringBuffer = new StringBuffer(MCODEResultsPanel.this.getClusterDetails(MCODEResultsPanel.this.clusters[i]));
                this.data[i][1] = new StringBuffer(stringBuffer);
                Image image = imageArray != null ? imageArray[i] : MCODEUtil.convertNetworkToImage(null, MCODEResultsPanel.this.clusters[i], 80, 80, null, true);
                this.data[i][0] = new ImageIcon(image);
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    private class CreateChildAction
    extends AbstractAction {
        int selectedRow;
        MCODEResultsPanel trigger;

        CreateChildAction(MCODEResultsPanel mCODEResultsPanel2, int n) {
            this.selectedRow = n;
            this.trigger = mCODEResultsPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(3);
            final MCODECluster mCODECluster = MCODEResultsPanel.this.clusters[this.selectedRow];
            final GraphPerspective graphPerspective = mCODECluster.getGPCluster();
            final String string = this.trigger.getResultTitle() + ": " + mCODECluster.getClusterName() + " (Score: " + numberFormat.format(mCODECluster.getClusterScore()) + ")";
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    CyNetwork cyNetwork = Cytoscape.createNetwork((int[])graphPerspective.getNodeIndicesArray(), (int[])graphPerspective.getEdgeIndicesArray(), (String)string, (CyNetwork)MCODEResultsPanel.this.network);
                    DGraphView dGraphView = (DGraphView)Cytoscape.createNetworkView((CyNetwork)cyNetwork);
                    boolean bl = false;
                    Object object = dGraphView.getNodeViewsIterator();
                    while (object.hasNext()) {
                        NodeView nodeView = (NodeView)object.next();
                        if (mCODECluster.getDGView() != null && mCODECluster.getDGView().getNodeView(nodeView.getNode().getRootGraphIndex()) != null) {
                            nodeView.setXPosition(mCODECluster.getDGView().getNodeView(nodeView.getNode().getRootGraphIndex()).getXPosition());
                            nodeView.setYPosition(mCODECluster.getDGView().getNodeView(nodeView.getNode().getRootGraphIndex()).getYPosition());
                            continue;
                        }
                        nodeView.setXPosition((double)dGraphView.getCanvas().getWidth() * Math.random());
                        nodeView.setYPosition((double)(dGraphView.getCanvas().getHeight() + 100) * Math.random());
                        bl = true;
                    }
                    if (bl) {
                        object = new SpringEmbeddedLayouter((GraphView)dGraphView);
                        ((SpringEmbeddedLayouter)object).doLayout(0, 0, 0.0, null);
                    }
                    dGraphView.fitContent();
                    return null;
                }
            };
            swingWorker.start();
        }
    }
}

