/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import java.util.ArrayList;
import netmatch.algorithm.Pair;

public class BfsPath
extends ArrayList {
    public BfsPath() {
    }

    public BfsPath(BfsPath path) {
        this.addAll(path);
    }

    public void add(int index, boolean isOutGoingEdge) {
        super.add(new Pair(index, isOutGoingEdge));
    }

    public boolean contains(int index) {
        for (int i = 0; i < this.size(); ++i) {
            Pair p = (Pair)this.get(i);
            if (p.getEdge() != index) continue;
            return true;
        }
        return false;
    }

    public Pair getLastEdge() {
        return (Pair)this.get(this.size() - 1);
    }

    public boolean checkCondition(String cond, int number) {
        int level = this.size();
        if (cond.equals(">")) {
            return level > number;
        }
        if (cond.equals(">=")) {
            return level >= number;
        }
        if (cond.equals("=")) {
            return level == number;
        }
        if (cond.equals("<")) {
            return level < number;
        }
        if (cond.equals("<=")) {
            return level <= number;
        }
        return false;
    }

    public int[] getApproximatePath(CyNetwork network) {
        int size = this.size();
        int[] path = new int[size];
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)this.get(i);
            path[i] = p.getEdge();
        }
        return path;
    }

    public void print(CyNetwork t) {
        if (this.size() == 0) {
            System.out.print("[empty]");
        } else {
            for (int i = 0; i < this.size(); ++i) {
                Pair p = (Pair)this.get(i);
                CyEdge edge = (CyEdge)t.getEdge(p.getEdge());
                System.out.print("[" + edge.getSource().getIdentifier() + "," + edge.getTarget().getIdentifier() + "] ");
            }
        }
        System.out.println();
    }
}

