/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import netmatch.algorithm.Graph;
import netmatch.algorithm.myInteger;

public class VF2MonoState {
    private int core_len;
    private int orig_core_len;
    private int added_node1;
    private int t1both_len;
    private int t2both_len;
    private int t1in_len;
    private int t1out_len;
    private int t2in_len;
    private int t2out_len;
    private int[] core_1;
    private int[] core_2;
    private int[] in_1;
    private int[] in_2;
    private int[] out_1;
    private int[] out_2;
    private Graph g1;
    private Graph g2;
    private int n1;
    private int n2;

    public VF2MonoState(Graph ag1, Graph ag2) {
        int i;
        this.g1 = ag1;
        this.g2 = ag2;
        this.n1 = this.g1.NodeCount();
        this.n2 = this.g2.NodeCount();
        this.orig_core_len = 0;
        this.core_len = 0;
        this.t1out_len = 0;
        this.t1in_len = 0;
        this.t1both_len = 0;
        this.t2out_len = 0;
        this.t2in_len = 0;
        this.t2both_len = 0;
        this.added_node1 = 65535;
        this.core_1 = new int[this.n1];
        this.core_2 = new int[this.n2];
        this.in_1 = new int[this.n1];
        this.in_2 = new int[this.n2];
        this.out_1 = new int[this.n1];
        this.out_2 = new int[this.n2];
        for (i = 0; i < this.n1; ++i) {
            this.core_1[i] = 65535;
            this.in_1[i] = 0;
            this.out_1[i] = 0;
        }
        for (i = 0; i < this.n2; ++i) {
            this.core_2[i] = 65535;
            this.in_2[i] = 0;
            this.out_2[i] = 0;
        }
    }

    public VF2MonoState(VF2MonoState state) {
        this.g1 = state.g1;
        this.g2 = state.g2;
        this.n1 = state.n1;
        this.n2 = state.n2;
        this.core_len = this.orig_core_len = state.core_len;
        this.t1in_len = state.t1in_len;
        this.t1out_len = state.t1out_len;
        this.t1both_len = state.t1both_len;
        this.t2in_len = state.t2in_len;
        this.t2out_len = state.t2out_len;
        this.t2both_len = state.t2both_len;
        this.added_node1 = 65535;
        this.core_1 = state.core_1;
        this.core_2 = state.core_2;
        this.in_1 = state.in_1;
        this.in_2 = state.in_2;
        this.out_1 = state.out_1;
        this.out_2 = state.out_2;
    }

    public Graph GetGraph1() {
        return this.g1;
    }

    public Graph GetGraph2() {
        return this.g2;
    }

    public boolean IsGoal() {
        return this.core_len == this.n1;
    }

    public boolean IsDead() {
        return this.n1 > this.n2 || this.t1both_len > this.t2both_len || this.t1out_len > this.t2out_len || this.t1in_len > this.t2in_len;
    }

    public int CoreLen() {
        return this.core_len;
    }

    public boolean NextPair(myInteger pn1, myInteger pn2, int prev_n1, int prev_n2) {
        if (prev_n1 == 65535) {
            prev_n1 = 0;
        }
        prev_n2 = prev_n2 == 65535 ? 0 : ++prev_n2;
        if (this.t1both_len > this.core_len && this.t2both_len > this.core_len) {
            while (prev_n1 < this.n1 && (this.core_1[prev_n1] != 65535 || this.out_1[prev_n1] == 0 || this.in_1[prev_n1] == 0)) {
                ++prev_n1;
                prev_n2 = 0;
            }
        } else if (this.t1out_len > this.core_len && this.t2out_len > this.core_len) {
            while (prev_n1 < this.n1 && (this.core_1[prev_n1] != 65535 || this.out_1[prev_n1] == 0)) {
                ++prev_n1;
                prev_n2 = 0;
            }
        } else if (this.t1in_len > this.core_len && this.t2in_len > this.core_len) {
            while (prev_n1 < this.n1 && (this.core_1[prev_n1] != 65535 || this.in_1[prev_n1] == 0)) {
                ++prev_n1;
                prev_n2 = 0;
            }
        } else {
            while (prev_n1 < this.n1 && this.core_1[prev_n1] != 65535) {
                ++prev_n1;
                prev_n2 = 0;
            }
        }
        if (this.t1both_len > this.core_len && this.t2both_len > this.core_len) {
            while (prev_n2 < this.n2 && (this.core_2[prev_n2] != 65535 || this.out_2[prev_n2] == 0 || this.in_2[prev_n2] == 0)) {
                ++prev_n2;
            }
        } else if (this.t1out_len > this.core_len && this.t2out_len > this.core_len) {
            while (prev_n2 < this.n2 && (this.core_2[prev_n2] != 65535 || this.out_2[prev_n2] == 0)) {
                ++prev_n2;
            }
        } else if (this.t1in_len > this.core_len && this.t2in_len > this.core_len) {
            while (prev_n2 < this.n2 && (this.core_2[prev_n2] != 65535 || this.in_2[prev_n2] == 0)) {
                ++prev_n2;
            }
        } else {
            while (prev_n2 < this.n2 && this.core_2[prev_n2] != 65535) {
                ++prev_n2;
            }
        }
        if (prev_n1 < this.n1 && prev_n2 < this.n2) {
            pn1.setValue(prev_n1);
            pn2.setValue(prev_n2);
            return true;
        }
        return false;
    }

    public boolean IsFeasiblePair(int node1, int node2) throws Exception {
        if (node1 < this.n1 && node2 < this.n2 && this.core_1[node1] == 65535 && this.core_2[node2] == 65535) {
            int other2;
            int other1;
            int i;
            if (!this.g1.CompatibleNode(this.g1.GetNodeAttr(node1), this.g2.GetNodeAttr(node2))) {
                return false;
            }
            Object attr1 = null;
            int termout1 = 0;
            int termout2 = 0;
            int termin1 = 0;
            int termin2 = 0;
            int new1 = 0;
            int new2 = 0;
            for (i = 0; i < this.g1.OutEdgeCount(node1); ++i) {
                other1 = this.g1.GetOutEdge(node1, i, attr1);
                attr1 = this.g1.GetOutEdge2(node1, i);
                if (this.core_1[other1] != 65535) {
                    other2 = this.core_1[other1];
                    if (this.g2.HasEdge(node2, other2) && this.g1.CompatibleEdge(attr1, this.g2.GetEdgeAttr(node2, other2))) continue;
                    return false;
                }
                if (this.in_1[other1] != 0) {
                    ++termin1;
                }
                if (this.out_1[other1] != 0) {
                    ++termout1;
                }
                if (this.in_1[other1] != 0 || this.out_1[other1] != 0) continue;
                ++new1;
            }
            for (i = 0; i < this.g1.InEdgeCount(node1); ++i) {
                other1 = this.g1.GetInEdge(node1, i, attr1);
                attr1 = this.g1.GetInEdge2(node1, i);
                if (this.core_1[other1] != 65535) {
                    other2 = this.core_1[other1];
                    if (this.g2.HasEdge(other2, node2) && this.g1.CompatibleEdge(attr1, this.g2.GetEdgeAttr(other2, node2))) continue;
                    return false;
                }
                if (this.in_1[other1] != 0) {
                    ++termin1;
                }
                if (this.out_1[other1] != 0) {
                    ++termout1;
                }
                if (this.in_1[other1] != 0 || this.out_1[other1] != 0) continue;
                ++new1;
            }
            for (i = 0; i < this.g2.OutEdgeCount(node2); ++i) {
                other2 = this.g2.GetOutEdge(node2, i);
                if (this.core_2[other2] != 65535) continue;
                if (this.in_2[other2] != 0) {
                    ++termin2;
                }
                if (this.out_2[other2] != 0) {
                    ++termout2;
                }
                if (this.in_2[other2] != 0 || this.out_2[other2] != 0) continue;
                ++new2;
            }
            for (i = 0; i < this.g2.InEdgeCount(node2); ++i) {
                other2 = this.g2.GetInEdge(node2, i);
                if (this.core_2[other2] != 65535) continue;
                if (this.in_2[other2] != 0) {
                    ++termin2;
                }
                if (this.out_2[other2] != 0) {
                    ++termout2;
                }
                if (this.in_2[other2] != 0 || this.out_2[other2] != 0) continue;
                ++new2;
            }
            return termin1 <= termin2 && termout1 <= termout2 && termin1 + termout1 + new1 <= termin2 + termout2 + new2;
        }
        throw new Exception("Exception in VF2MonoState. IsfeasiblePair condition false:\nnode1 < n1 && node2 < n2 && core_1[node1] == NULL_NODE && core_2[node2] == NULL_NODE");
    }

    public void AddPair(int node1, int node2) throws Exception {
        if (node1 < this.n1 && node2 < this.n2 && this.core_len < this.n1 && this.core_len < this.n2) {
            int other;
            int i;
            ++this.core_len;
            this.added_node1 = node1;
            if (this.in_1[node1] == 0) {
                this.in_1[node1] = this.core_len;
                ++this.t1in_len;
                if (this.out_1[node1] != 0) {
                    ++this.t1both_len;
                }
            }
            if (this.out_1[node1] == 0) {
                this.out_1[node1] = this.core_len;
                ++this.t1out_len;
                if (this.in_1[node1] != 0) {
                    ++this.t1both_len;
                }
            }
            if (this.in_2[node2] == 0) {
                this.in_2[node2] = this.core_len;
                ++this.t2in_len;
                if (this.out_2[node2] != 0) {
                    ++this.t2both_len;
                }
            }
            if (this.out_2[node2] == 0) {
                this.out_2[node2] = this.core_len;
                ++this.t2out_len;
                if (this.in_2[node2] != 0) {
                    ++this.t2both_len;
                }
            }
            this.core_1[node1] = node2;
            this.core_2[node2] = node1;
            for (i = 0; i < this.g1.InEdgeCount(node1); ++i) {
                other = this.g1.GetInEdge(node1, i);
                if (this.in_1[other] != 0) continue;
                this.in_1[other] = this.core_len;
                ++this.t1in_len;
                if (this.out_1[other] == 0) continue;
                ++this.t1both_len;
            }
            for (i = 0; i < this.g1.OutEdgeCount(node1); ++i) {
                other = this.g1.GetOutEdge(node1, i);
                if (this.out_1[other] != 0) continue;
                this.out_1[other] = this.core_len;
                ++this.t1out_len;
                if (this.in_1[other] == 0) continue;
                ++this.t1both_len;
            }
            for (i = 0; i < this.g2.InEdgeCount(node2); ++i) {
                other = this.g2.GetInEdge(node2, i);
                if (this.in_2[other] != 0) continue;
                this.in_2[other] = this.core_len;
                ++this.t2in_len;
                if (this.out_2[other] == 0) continue;
                ++this.t2both_len;
            }
            for (i = 0; i < this.g2.OutEdgeCount(node2); ++i) {
                other = this.g2.GetOutEdge(node2, i);
                if (this.out_2[other] != 0) continue;
                this.out_2[other] = this.core_len;
                ++this.t2out_len;
                if (this.in_2[other] == 0) continue;
                ++this.t2both_len;
            }
        } else {
            throw new Exception();
        }
    }

    public void GetCoreSet(int[] c1, int[] c2) {
        int j = 0;
        for (int i = 0; i < this.n1; ++i) {
            if (this.core_1[i] == 65535) continue;
            c1[j] = i;
            c2[j] = this.core_1[i];
            ++j;
        }
    }

    public VF2MonoState Clone() {
        return new VF2MonoState(this);
    }

    public void BackTrack() throws Exception {
        if (this.core_len - this.orig_core_len <= 1 && this.added_node1 != 65535) {
            if (this.orig_core_len < this.core_len) {
                int other;
                int i;
                if (this.in_1[this.added_node1] == this.core_len) {
                    this.in_1[this.added_node1] = 0;
                }
                for (i = 0; i < this.g1.InEdgeCount(this.added_node1); ++i) {
                    other = this.g1.GetInEdge(this.added_node1, i);
                    if (this.in_1[other] != this.core_len) continue;
                    this.in_1[other] = 0;
                }
                if (this.out_1[this.added_node1] == this.core_len) {
                    this.out_1[this.added_node1] = 0;
                }
                for (i = 0; i < this.g1.OutEdgeCount(this.added_node1); ++i) {
                    other = this.g1.GetOutEdge(this.added_node1, i);
                    if (this.out_1[other] != this.core_len) continue;
                    this.out_1[other] = 0;
                }
                int node2 = this.core_1[this.added_node1];
                if (this.in_2[node2] == this.core_len) {
                    this.in_2[node2] = 0;
                }
                for (i = 0; i < this.g2.InEdgeCount(node2); ++i) {
                    other = this.g2.GetInEdge(node2, i);
                    if (this.in_2[other] != this.core_len) continue;
                    this.in_2[other] = 0;
                }
                if (this.out_2[node2] == this.core_len) {
                    this.out_2[node2] = 0;
                }
                for (i = 0; i < this.g2.OutEdgeCount(node2); ++i) {
                    other = this.g2.GetOutEdge(node2, i);
                    if (this.out_2[other] != this.core_len) continue;
                    this.out_2[other] = 0;
                }
                this.core_1[this.added_node1] = 65535;
                this.core_2[node2] = 65535;
                this.core_len = this.orig_core_len;
                this.added_node1 = 65535;
            }
        } else {
            throw new Exception();
        }
    }
}

