/*
 * Decompiled with CFR 0.152.
 */
package netmatch;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.util.SwingWorker;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import netmatch.JMultiLineToolTip;
import netmatch.algorithm.Common;
import phoebe.PGraphView;

public class netMatchResultsDialog
extends JPanel {
    protected JTable table;
    JScrollPane scrollPane;
    protected netMatchResultsTableModel model;
    protected final int defaultRowHeight = Common.imageSize;
    protected boolean openAsNewChild = false;
    protected GraphPerspective[] gpComplexArray;
    CyNetwork originalInputNetwork;
    CyNetworkView originalInputNetworkView;
    HashMap hmNetworkNames;
    JButton saveButton;
    JCheckBox newWindowCheckBox;
    boolean isApproximate;
    ArrayList allPaths;

    public netMatchResultsDialog() {
        this.setLayout(new BorderLayout());
        this.hmNetworkNames = new HashMap();
        this.isApproximate = false;
        this.allPaths = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.table = new JTable(){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                String tip = this.getColumnName(realColumnIndex);
                if (realColumnIndex == 0 || realColumnIndex == 1) {
                    tip = tip + ":" + this.getValueAt(rowIndex, colIndex);
                }
                return tip;
            }
        };
        this.table.setRowHeight(this.defaultRowHeight);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(String.class, new CenterAndBoldRenderer());
        this.table.setDefaultRenderer(StringBuffer.class, new JTextAreaRenderer());
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new TableRowSelectionHandler());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        panel.add((Component)this.scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        this.newWindowCheckBox = new JCheckBox("Create a new child network.", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.newWindowCheckBox.setToolTipText("If checked, a new child network of the selected match will be created. \r\nOtherwise, the occurrence of the query match in the network window will be highlighted.");
        this.newWindowCheckBox.addItemListener(new newWindowCheckBoxAction());
        this.newWindowCheckBox.setEnabled(false);
        bottomPanel.add(this.newWindowCheckBox);
        this.saveButton = new JButton("Save");
        this.saveButton.setToolTipText("Save result summary to a file.");
        this.saveButton.setEnabled(false);
        bottomPanel.add(this.saveButton);
        panel.add((Component)bottomPanel, "South");
        this.add((Component)panel, "Center");
    }

    public void set(ArrayList complexes, CyNetwork network, Image[] imageList, boolean isApproximate, ArrayList allPaths) {
        this.isApproximate = isApproximate;
        this.allPaths = allPaths;
        this.originalInputNetwork = network;
        this.originalInputNetworkView = Cytoscape.getNetworkView((String)network.getIdentifier());
        this.model = new netMatchResultsTableModel(network, complexes, imageList);
        this.table.setModel(this.model);
        this.table.setVisible(true);
        this.initColumnSizes(this.table);
        this.saveButton.addActionListener(new SaveAction(complexes, network));
        this.saveButton.setEnabled(true);
        this.newWindowCheckBox.setEnabled(true);
    }

    public void clear() {
        this.isApproximate = false;
        this.originalInputNetwork = null;
        this.originalInputNetworkView = null;
        ActionListener[] al = this.saveButton.getActionListeners();
        for (int i = 0; i < al.length; ++i) {
            this.saveButton.removeActionListener(al[i]);
        }
        this.saveButton.setEnabled(false);
        this.newWindowCheckBox.setEnabled(false);
        this.table.setVisible(false);
    }

    private void initColumnSizes(JTable table) {
        for (int i = 0; i < 3; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            column.sizeWidthToFit();
        }
    }

    private class JTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        public JTextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.setAutoscrolls(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StringBuffer sb = (StringBuffer)value;
            this.setText(sb.toString());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            int currentRowHeight = table.getRowHeight(row);
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), currentRowHeight);
            int textAreaPreferredHeight = (int)this.getPreferredSize().getHeight();
            if (currentRowHeight < textAreaPreferredHeight) {
                table.setRowHeight(row, textAreaPreferredHeight);
            } else if (currentRowHeight > textAreaPreferredHeight && currentRowHeight != netMatchResultsDialog.this.defaultRowHeight) {
                table.setRowHeight(row, netMatchResultsDialog.this.defaultRowHeight);
            }
            return this;
        }
    }

    private class CenterAndBoldRenderer
    extends DefaultTableCellRenderer {
        private CenterAndBoldRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setFont(new Font(this.getFont().getFontName(), 1, 14));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            return cell;
        }
    }

    private class TableRowSelectionHandler
    implements ListSelectionListener {
        private TableRowSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                GraphPerspective gpComplex = netMatchResultsDialog.this.gpComplexArray[selectedRow];
                if (netMatchResultsDialog.this.originalInputNetworkView != null) {
                    NodeView nv;
                    GinyUtils.deselectAllNodes((GraphView)netMatchResultsDialog.this.originalInputNetworkView);
                    GinyUtils.deselectAllEdges((GraphView)netMatchResultsDialog.this.originalInputNetworkView);
                    Iterator i = gpComplex.nodesIterator();
                    while (i.hasNext()) {
                        Node n = (Node)i.next();
                        if (!netMatchResultsDialog.this.originalInputNetwork.containsNode(n)) continue;
                        nv = netMatchResultsDialog.this.originalInputNetworkView.getNodeView(n);
                        nv.setSelected(true);
                    }
                    if (!netMatchResultsDialog.this.isApproximate) {
                        i = gpComplex.edgesIterator();
                        while (i.hasNext()) {
                            Edge ed = (Edge)i.next();
                            if (!netMatchResultsDialog.this.originalInputNetwork.containsEdge(ed)) continue;
                            EdgeView ev = netMatchResultsDialog.this.originalInputNetworkView.getEdgeView(ed);
                            ev.setSelected(true);
                        }
                    } else {
                        ArrayList paths = (ArrayList)netMatchResultsDialog.this.allPaths.get(selectedRow);
                        for (int i2 = 0; i2 < paths.size(); ++i2) {
                            int[] p = (int[])paths.get(i2);
                            for (int j = 0; j < p.length; ++j) {
                                Node d;
                                Edge edge = netMatchResultsDialog.this.originalInputNetwork.getEdge(p[j]);
                                Node s = edge.getSource();
                                if (netMatchResultsDialog.this.originalInputNetwork.containsNode(s)) {
                                    nv = netMatchResultsDialog.this.originalInputNetworkView.getNodeView(s);
                                    nv.setSelected(true);
                                }
                                if (netMatchResultsDialog.this.originalInputNetwork.containsNode(d = edge.getTarget())) {
                                    nv = netMatchResultsDialog.this.originalInputNetworkView.getNodeView(d);
                                    nv.setSelected(true);
                                }
                                if (!netMatchResultsDialog.this.originalInputNetwork.containsEdge(edge)) continue;
                                EdgeView ev = netMatchResultsDialog.this.originalInputNetworkView.getEdgeView(edge);
                                ev.setSelected(true);
                            }
                        }
                    }
                    if (!netMatchResultsDialog.this.openAsNewChild) {
                        Cytoscape.getDesktop().setFocus(netMatchResultsDialog.this.originalInputNetworkView.getIdentifier());
                    }
                } else if (!netMatchResultsDialog.this.openAsNewChild) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "You must have a network view created to select nodes.");
                }
                if (netMatchResultsDialog.this.openAsNewChild) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(3);
                    String title = "Match " + (selectedRow + 1);
                    String id = (String)netMatchResultsDialog.this.hmNetworkNames.get(new Integer(selectedRow + 1));
                    if (id != null) {
                        Cytoscape.getDesktop().setFocus(id);
                    } else {
                        SwingWorker worker = new SwingWorker(this, title, selectedRow){
                            private final /* synthetic */ String val$title;
                            private final /* synthetic */ int val$selectedRow;
                            private final /* synthetic */ TableRowSelectionHandler this$1;
                            {
                                this.this$1 = this$1;
                                this.val$title = val$title;
                                this.val$selectedRow = val$selectedRow;
                            }

                            public Object construct() {
                                CyNetwork newNetwork = Cytoscape.createNetwork((int[])TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).originalInputNetworkView.getSelectedNodeIndices(), (int[])TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).originalInputNetworkView.getSelectedEdgeIndices(), (String)this.val$title, (CyNetwork)TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).originalInputNetwork);
                                TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).hmNetworkNames.put(new Integer(this.val$selectedRow + 1), newNetwork.getIdentifier());
                                try {
                                    PGraphView view = (PGraphView)Cytoscape.createNetworkView((CyNetwork)newNetwork);
                                    Iterator in = view.getNodeViewsIterator();
                                    while (in.hasNext()) {
                                        NodeView nv = (NodeView)in.next();
                                        nv.setXPosition(view.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
                                        nv.setYPosition((view.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
                                    }
                                    view.fitContent();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                        };
                        worker.start();
                    }
                }
            }
        }

        static /* synthetic */ netMatchResultsDialog access$300(TableRowSelectionHandler x0) {
            return x0.netMatchResultsDialog.this;
        }
    }

    private class newWindowCheckBoxAction
    implements ItemListener {
        private newWindowCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            netMatchResultsDialog.this.openAsNewChild = e.getStateChange() != 2;
        }
    }

    private class SaveAction
    extends AbstractAction {
        private ArrayList complexes;
        private CyNetwork network;

        SaveAction(ArrayList complexes, CyNetwork network) {
            super("");
            this.complexes = complexes;
            this.network = network;
        }

        public void actionPerformed(ActionEvent e) {
            File file = FileUtil.getFile((String)"Save Graph as Interactions", (int)FileUtil.SAVE, (CyFileFilter[])new CyFileFilter[0]);
            if (file != null) {
                String fileName = file.getAbsolutePath();
                this.saveMCODEResults(this.complexes, this.network, fileName);
            }
        }

        public boolean saveMCODEResults(ArrayList complexes, CyNetwork network, String fileName) {
            if (complexes == null || network == null || fileName == null) {
                return false;
            }
            String lineSep = System.getProperty("line.separator");
            try {
                File file = new File(fileName);
                FileWriter fout = new FileWriter(file);
                fout.write("NetMatch Plugin Results" + lineSep);
                fout.write("Date: " + DateFormat.getDateTimeInstance().format(new Date()) + lineSep + lineSep);
                fout.write("Match Number\tNodeCount\tEdgeCount\tNames" + lineSep);
                GraphPerspective[] gpComplexArray = this.convertComplexListToNetworkList(complexes, network);
                for (int i = 0; i < gpComplexArray.length; ++i) {
                    GraphPerspective gpComplex = gpComplexArray[i];
                    fout.write(i + 1 + "\t\t");
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(3);
                    fout.write(gpComplex.getNodeCount() + "\t\t");
                    fout.write(gpComplex.getEdgeCount() + "\t\t");
                    fout.write(this.getNodeNameList(gpComplex).toString() + lineSep);
                }
                fout.close();
                return true;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + fileName + "\"", 0);
                return false;
            }
        }

        private StringBuffer getNodeNameList(GraphPerspective gpInput) {
            Iterator i = gpInput.nodesIterator();
            StringBuffer sb = new StringBuffer();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                sb.append(node.getIdentifier());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            return sb;
        }

        private GraphPerspective convertComplexToNetwork(int[] complex, CyNetwork sourceNetwork) {
            GraphPerspective gpComplex = sourceNetwork.createGraphPerspective(complex);
            return gpComplex;
        }

        private GraphPerspective[] convertComplexListToNetworkList(ArrayList complexList, CyNetwork sourceNetwork) {
            GraphPerspective[] gpComplexArray = new GraphPerspective[complexList.size()];
            for (int i = 0; i < complexList.size(); ++i) {
                gpComplexArray[i] = this.convertComplexToNetwork((int[])complexList.get(i), sourceNetwork);
            }
            return gpComplexArray;
        }
    }

    private class netMatchResultsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Match Number", "Nodes", "Image"};
        Object[][] data;

        public netMatchResultsTableModel(CyNetwork network, ArrayList complexes, Image[] imageList) {
            netMatchResultsDialog.this.gpComplexArray = this.convertComplexListToNetworkList(complexes, network);
            this.data = new Object[netMatchResultsDialog.this.gpComplexArray.length][this.columnNames.length];
            for (int i = 0; i < netMatchResultsDialog.this.gpComplexArray.length; ++i) {
                GraphPerspective gpComplex = netMatchResultsDialog.this.gpComplexArray[i];
                this.data[i][0] = new Integer(i + 1).toString();
                this.data[i][1] = this.getNodeNameList(gpComplex);
                this.data[i][2] = "No Image";
                if (imageList == null) continue;
                this.data[i][2] = new ImageIcon(imageList[i]);
            }
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        private GraphPerspective convertComplexToNetwork(int[] complex, CyNetwork sourceNetwork) {
            GraphPerspective gpComplex = sourceNetwork.createGraphPerspective(complex);
            return gpComplex;
        }

        private GraphPerspective[] convertComplexListToNetworkList(ArrayList complexList, CyNetwork sourceNetwork) {
            GraphPerspective[] gpComplexArray = new GraphPerspective[complexList.size()];
            for (int i = 0; i < complexList.size(); ++i) {
                gpComplexArray[i] = this.convertComplexToNetwork((int[])complexList.get(i), sourceNetwork);
            }
            return gpComplexArray;
        }

        private StringBuffer getNodeNameList(GraphPerspective gpInput) {
            Iterator i = gpInput.nodesIterator();
            StringBuffer sb = new StringBuffer();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                sb.append(node.getIdentifier());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            return sb;
        }

        private Image convertNetworkToImage(GraphPerspective gpInput, int height, int width) {
            PGraphView view = new PGraphView(gpInput);
            Iterator in = view.getNodeViewsIterator();
            while (in.hasNext()) {
                NodeView nv = (NodeView)in.next();
                String label = nv.getNode().getIdentifier();
                nv.getLabel().setText(label);
                nv.setWidth(40.0);
                nv.setHeight(40.0);
                nv.setShape(2);
                nv.setUnselectedPaint((Paint)Color.red);
                nv.setBorderPaint((Paint)Color.black);
                nv.setXPosition(view.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
                nv.setYPosition((view.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
            }
            Iterator ie = view.getEdgeViewsIterator();
            while (ie.hasNext()) {
                EdgeView ev = (EdgeView)ie.next();
                ev.setUnselectedPaint((Paint)Color.blue);
                ev.setTargetEdgeEnd(5);
                ev.setTargetEdgeEndPaint((Paint)Color.CYAN);
                ev.setSourceEdgeEndPaint((Paint)Color.CYAN);
                ev.setStroke((Stroke)new BasicStroke(5.0f));
            }
            Image image = view.getCanvas().getLayer().toImage(width, height, null);
            return image;
        }
    }
}

