/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import netmatch.qtool.InvalidSIFException;
import netmatch.qtool.QEdge;
import netmatch.qtool.QElement;
import netmatch.qtool.QLoop;
import netmatch.qtool.QNode;
import netmatch.qtool.QPath;

public class Network {
    public static int nodeCount = 0;
    public static int edgeCount = 0;
    public static int pathCount = 0;
    public static int loopCount = 0;
    public static int count = 0;
    public static int width;
    public static int height;
    public static Random r;
    public static int nCount;
    public static int eCount;
    public static int pCount;
    public static int lCount;

    public static void clean(PLayer nodeLayer, PLayer edgeLayer) {
        nodeLayer.removeAllChildren();
        edgeLayer.removeAllChildren();
        loopCount = 0;
        pathCount = 0;
        edgeCount = 0;
        nodeCount = 0;
        lCount = 0;
        pCount = 0;
        eCount = 0;
        nCount = 0;
    }

    public static void updateAll(PLayer nodeLayer) {
        Iterator it = nodeLayer.getAllNodes().iterator();
        while (it.hasNext()) {
            PNode node = (PNode)it.next();
            if (!(node instanceof QNode)) continue;
            ((QNode)node).update();
        }
    }

    public static void saveStructure(FileWriter writer, PCanvas canvas) {
        PLayer nodeLayer = canvas.getCamera().getLayer(1);
        PLayer edgeLayer = canvas.getCamera().getLayer(0);
        BufferedWriter bw = new BufferedWriter(writer);
        Iterator it = nodeLayer.getAllNodes().iterator();
        try {
            PNode node;
            while (it.hasNext()) {
                QNode qNode;
                node = (PNode)it.next();
                if (!(node instanceof QNode) || !(qNode = (QNode)node).isSingle()) continue;
                bw.write(qNode.getId() + "\n");
            }
            it = edgeLayer.getAllNodes().iterator();
            while (it.hasNext()) {
                node = (PNode)it.next();
                if (node instanceof QLoop) {
                    QLoop loop = (QLoop)node;
                    bw.write(loop.getOwner().getId() + " " + loop.getId() + " " + loop.getOwner().getId() + "\n");
                    continue;
                }
                if (node instanceof QEdge) {
                    QEdge edge = (QEdge)node;
                    bw.write(edge.getSource().getId() + " " + edge.getId() + " " + edge.getTarget().getId() + "\n");
                    continue;
                }
                if (!(node instanceof QPath)) continue;
                QPath path = (QPath)node;
                bw.write(path.getSource().getId() + " " + path.getAttr() + " " + path.getTarget().getId() + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println("Write error!");
        }
    }

    public static void saveNodeAttr(FileWriter writer, PLayer nodeLayer) {
        BufferedWriter bw = new BufferedWriter(writer);
        Iterator it = nodeLayer.getAllNodes().iterator();
        try {
            bw.write("Node Attributes\n");
            while (it.hasNext()) {
                PNode node = (PNode)it.next();
                if (!(node instanceof QNode)) continue;
                QNode qNode = (QNode)node;
                bw.write(qNode.getId() + "=" + qNode.getAttr() + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println("Write error!");
        }
    }

    public static void saveEdgeAttr(FileWriter writer, PLayer edgeLayer) {
        BufferedWriter bw = new BufferedWriter(writer);
        Iterator it = edgeLayer.getAllNodes().iterator();
        try {
            bw.write("Edge Attributes\n");
            while (it.hasNext()) {
                PNode node = (PNode)it.next();
                if (!(node instanceof QElement) || node instanceof QPath) continue;
                if (node instanceof QEdge) {
                    QEdge edge = (QEdge)node;
                    bw.write(edge.getSource().getId() + " (" + edge.getId() + ") " + edge.getTarget().getId() + " = " + edge.getAttr() + "\n");
                    continue;
                }
                if (!(node instanceof QLoop)) continue;
                QLoop loop = (QLoop)node;
                bw.write(loop.getOwner().getId() + " (" + loop.getId() + ") " + loop.getOwner().getId() + " = " + loop.getAttr() + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println("Write error!");
        }
    }

    private static int decodeMax(String s) {
        if (s.length() <= 1) {
            return 0;
        }
        if (s.charAt(0) != 'n' && s.charAt(0) != 'e' && s.charAt(0) != 'l') {
            return 0;
        }
        try {
            int bi = Integer.parseInt(s.substring(1));
            return bi;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void loadStructure(FileReader reader, PCanvas canvas) throws InvalidSIFException {
        lCount = 0;
        pCount = 0;
        eCount = 0;
        nCount = 0;
        PLayer nodeLayer = canvas.getCamera().getLayer(1);
        PLayer edgeLayer = canvas.getCamera().getLayer(0);
        BufferedReader br = new BufferedReader(reader);
        Dimension d = canvas.getSize();
        width = (int)d.getWidth();
        height = (int)d.getHeight();
        count = 0;
        int mn_id = 0;
        int me_id = 0;
        int ml_id = 0;
        try {
            String s;
            int line = 0;
            while ((s = br.readLine()) != null) {
                int bi;
                ++line;
                String[] ss = s.split("\\s");
                if (s.length() == 0 || ss.length == 0 || ss.length == 1 && ss[0].length() == 0) continue;
                if (ss.length == 1) {
                    QNode node = Network.addNode(ss[0].trim(), nodeLayer);
                    bi = Network.decodeMax(ss[0].trim());
                    if (bi <= mn_id) continue;
                    mn_id = bi;
                    continue;
                }
                QNode snode = Network.addNode(ss[0].trim(), nodeLayer);
                bi = Network.decodeMax(ss[0].trim());
                if (bi > mn_id) {
                    mn_id = bi;
                }
                ss[1] = ss[1].trim();
                LinkedList<QNode> targets = new LinkedList<QNode>();
                for (int i = 2; i < ss.length; ++i) {
                    targets.add(Network.addNode(ss[i].trim(), nodeLayer));
                    bi = Network.decodeMax(ss[i].trim());
                    if (bi <= mn_id) continue;
                    mn_id = bi;
                }
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    QNode tnode = (QNode)it.next();
                    if (snode == tnode) {
                        QLoop loop = new QLoop(snode, ss[1]);
                        bi = Network.decodeMax(ss[1]);
                        if (bi > ml_id) {
                            ml_id = bi;
                        }
                        snode.addLoop(loop);
                        loop.setAttr(ss[1]);
                        edgeLayer.addChild((PNode)loop);
                        ++lCount;
                        continue;
                    }
                    if (ss[1].charAt(0) == '?' && (ss[1].charAt(1) == '=' || ss[1].charAt(1) == '>' || ss[1].charAt(1) == '!' || ss[1].charAt(1) == '<')) {
                        QPath path = new QPath(snode, tnode, "path");
                        path.setAttr(ss[1]);
                        snode.addPath(path);
                        tnode.addPath(path);
                        edgeLayer.addChild((PNode)path);
                        ++pCount;
                        continue;
                    }
                    QEdge edge = new QEdge(snode, tnode, ss[1]);
                    bi = Network.decodeMax(ss[1]);
                    if (bi > me_id) {
                        me_id = bi;
                    }
                    edge.setAttr(ss[1]);
                    snode.addEdge(edge);
                    tnode.addEdge(edge);
                    edgeLayer.addChild((PNode)edge);
                    ++eCount;
                }
            }
            nodeCount = mn_id + 1;
            edgeCount = me_id + 1;
            loopCount = ml_id + 1;
        }
        catch (IOException e) {
            System.err.println("Error loading file");
        }
        Network.updateAll(nodeLayer);
    }

    public static void loadNodeAttr(FileReader reader, PLayer nodeLayer) throws InvalidSIFException {
        BufferedReader br = new BufferedReader(reader);
        try {
            String s;
            br.readLine();
            int line = 1;
            while ((s = br.readLine()) != null) {
                ++line;
                String[] ss = s.split("=");
                String id = ss[0].trim();
                String label = ss[1].trim();
                if (ss.length != 2) {
                    throw new InvalidSIFException(line);
                }
                Iterator it = nodeLayer.getAllNodes().iterator();
                QNode node = null;
                while (it.hasNext()) {
                    PNode candNode = (PNode)it.next();
                    if (!(candNode instanceof QNode) || !((QNode)candNode).getId().equals(id)) continue;
                    node = (QNode)candNode;
                    break;
                }
                if (node == null) continue;
                node.setAttr(label);
            }
        }
        catch (IOException e) {
            System.err.println("Error loading node labels file");
        }
    }

    public static void loadEdgeLoopAttr(FileReader reader, PLayer edgeLayer) throws InvalidSIFException {
        BufferedReader br = new BufferedReader(reader);
        try {
            String s;
            br.readLine();
            int line = 1;
            while ((s = br.readLine()) != null) {
                PNode node;
                ++line;
                String[] ss = s.split("=");
                String[] edge_info = ss[0].trim().split("\\s");
                String label = ss[1].trim();
                if (edge_info.length != 1 && edge_info.length != 3) {
                    throw new InvalidSIFException(line);
                }
                if (edge_info.length == 1) {
                    String id = edge_info[0].trim();
                    Iterator it = edgeLayer.getAllNodes().iterator();
                    while (it.hasNext()) {
                        QElement elem;
                        PNode node2 = (PNode)it.next();
                        if (!(node2 instanceof QElement) || !(elem = (QElement)node2).getId().equals(id)) continue;
                        elem.setAttr(label);
                    }
                    continue;
                }
                String id_from = edge_info[0].trim();
                String id_edge = edge_info[1].trim();
                if (id_edge.charAt(0) != '(' || id_edge.charAt(id_edge.length() - 1) != ')') {
                    throw new InvalidSIFException(line);
                }
                id_edge = id_edge.substring(1, id_edge.length() - 1);
                String id_to = edge_info[2].trim();
                Iterator it = edgeLayer.getAllNodes().iterator();
                if (id_from.equals(id_to)) {
                    while (it.hasNext()) {
                        QLoop loop;
                        node = (PNode)it.next();
                        if (!(node instanceof QLoop) || !(loop = (QLoop)node).getId().equals(id_edge) || !loop.getOwner().getId().equals(id_from)) continue;
                        loop.setAttr(label);
                    }
                    continue;
                }
                while (it.hasNext()) {
                    QEdge edge;
                    node = (PNode)it.next();
                    if (!(node instanceof QEdge) || !(edge = (QEdge)node).getId().equals(id_edge) || !edge.getSource().getId().equals(id_from) || !edge.getTarget().getId().equals(id_to)) continue;
                    edge.setAttr(label);
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error loading node labels file");
        }
    }

    public static QNode addNode(String id, PLayer nodeLayer) {
        Iterator it = nodeLayer.getAllNodes().iterator();
        QNode node = null;
        while (it.hasNext()) {
            PNode candNode = (PNode)it.next();
            if (!(candNode instanceof QNode) || !((QNode)candNode).getId().equals(id)) continue;
            node = (QNode)candNode;
        }
        if (node != null) {
            return node;
        }
        int x = r.nextInt(width - 30);
        x = x <= 30 ? 31 : x;
        int y = r.nextInt(height - 30);
        y = y <= 30 ? 31 : y;
        node = new QNode(x, y, id);
        node.setAttr(id);
        node.addToLayer(nodeLayer);
        node.update();
        ++nCount;
        ++count;
        return node;
    }

    static {
        r = new Random();
        nCount = 0;
        eCount = 0;
        pCount = 0;
        lCount = 0;
    }
}

