/*
 * Decompiled with CFR 0.152.
 */
package netmatch.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class netMatchQuickHelp
extends JFrame
implements ActionListener,
WindowListener,
HyperlinkListener {
    private final int WIDTH = 600;
    private final int HEIGHT = 500;
    private JEditorPane editor;

    public static void main(String[] args) {
        netMatchQuickHelp f = new netMatchQuickHelp("NetMatch Quick Help", null);
        f.setVisible(true);
    }

    public netMatchQuickHelp(String title, ImageIcon img) {
        this.setTitle(title);
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel princ = new JPanel(new BorderLayout());
        princ.setPreferredSize(new Dimension(600, 500));
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        this.editor = this.createPage("resources/quick.html");
        vp.add(this.editor);
        princ.add((Component)this.createMenuBar(), "North");
        princ.add((Component)scroller, "Center");
        this.getContentPane().add((Component)princ, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem i = new JMenuItem("Exit");
        i.addActionListener(this);
        fileMenu.add(i);
        menuBar.add(fileMenu);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Exit")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Window window = e.getWindow();
        if (window.equals(this)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private URL getPage(String page) {
        return this.getClass().getResource(page);
    }

    private JEditorPane createPage(String path) {
        URL url = this.getPage(path);
        try {
            if (url != null) {
                JEditorPane html = new JEditorPane(url);
                html.setEditable(false);
                html.addHyperlinkListener(this);
                return html;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to laod:" + path);
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.editor.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                try {
                    this.editor.setPage(e.getURL());
                }
                catch (IOException ioe) {
                    System.out.println("IOE: " + ioe);
                }
            }
        }
    }
}

