/*
 * Decompiled with CFR 0.152.
 */
package netmatch;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import netmatch.JAboutDialog;
import netmatch.algorithm.Common;
import netmatch.algorithm.GraphLoader;
import netmatch.algorithm.netMatch;
import netmatch.help.netMatchHelp;
import netmatch.multipleAttrChoice;
import netmatch.netMatchResultsDialog;
import netmatch.qtool.IQueryRecipient;
import netmatch.qtool.QToolFrame;
import netmatch.wizard.WizardForm;

public class netMatchFrame
extends JFrame
implements ActionListener,
WindowListener,
IQueryRecipient {
    private static final int HEIGHT = 580;
    private static final int WIDTH = 550;
    public ImageIcon[] icons;
    public ImageIcon[] structures;
    public ImageIcon[] menu;
    private static final String aboutImage = "bannerImage.jpg";
    private static final String selgimp = "select_gimp.gif";
    private static final String selmove = "select_move.gif";
    private static final String nodegimp = "node.gif";
    private static final String loopgimp = "loop_gimp.gif";
    private static final String edgegimp = "edge_gimp.gif";
    private static final String pathgimp = "path_gimp.gif";
    private static final String zoomin = "zoomin_gimp.gif";
    private static final String zoomout = "zoomout_gimp.gif";
    private static final String bi_fan = "bi_fan.gif";
    private static final String bi_parallel = "bi_parallel.gif";
    private static final String feed_forward_loop = "feed_forward_loop.gif";
    private static final String three_chain = "three_chain.gif";
    private static final String nuovo = "new.gif";
    private static final String load = "load.gif";
    private static final String save = "save.gif";
    private static final String change = "change.gif";
    private static final String pass = "pass.gif";
    private static final String exit = "exit.gif";
    private static final String clear = "clear.gif";
    private static final String nuovo16 = "new16.gif";
    private static final String load16 = "load16.gif";
    private static final String save16 = "save16.gif";
    private static final String change16 = "change16.gif";
    private static final String pass16 = "pass16.gif";
    private static final String exit16 = "exit16.gif";
    private static final String clear16 = "clear16.gif";
    private static final String draw16 = "draw16.gif";
    private static final String about16 = "about16.gif";
    private static final String xedit16 = "xedit.png";
    private static final String h = "h.gif";
    private static final String a = "a.gif";
    private static final String wiz = "wizard.gif";
    private static final String mton_fan = "mton_fan.gif";
    private static final String quickHelp = "help.gif";
    private static final String path = "images/";
    private JTextArea log;
    private JComboBox query;
    private JComboBox target;
    private JCheckBox labeled;
    private JCheckBox directed;
    private netMatchResultsDialog result;
    private JComboBox qea;
    private JComboBox tea;
    private JComboBox qna;
    private JComboBox tna;
    private QToolFrame qEditor;
    private boolean isEditorOpen;
    private boolean isQueryApproximate;
    private Vector qpaths;
    public HashMap queries;
    protected WizardForm wizardForm;
    public ArrayList listOfNodeAttributes;
    public ArrayList listOfEdgeAttributes;

    public netMatchFrame(String title) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(title);
        this.addWindowListener(this);
        this.icons = new ImageIcon[9];
        this.icons[0] = this.createImageIcon("images/bannerImage.jpg");
        this.icons[1] = this.createImageIcon("images/select_gimp.gif");
        this.icons[2] = this.createImageIcon("images/select_move.gif");
        this.icons[3] = this.createImageIcon("images/node.gif");
        this.icons[4] = this.createImageIcon("images/loop_gimp.gif");
        this.icons[5] = this.createImageIcon("images/edge_gimp.gif");
        this.icons[6] = this.createImageIcon("images/path_gimp.gif");
        this.icons[7] = this.createImageIcon("images/zoomin_gimp.gif");
        this.icons[8] = this.createImageIcon("images/zoomout_gimp.gif");
        this.structures = new ImageIcon[5];
        this.structures[0] = this.createImageIcon("images/three_chain.gif");
        this.structures[1] = this.createImageIcon("images/feed_forward_loop.gif");
        this.structures[2] = this.createImageIcon("images/bi_parallel.gif");
        this.structures[3] = this.createImageIcon("images/bi_fan.gif");
        this.structures[4] = this.createImageIcon("images/mton_fan.gif");
        this.menu = new ImageIcon[21];
        this.menu[0] = this.createImageIcon("images/new.gif");
        this.menu[1] = this.createImageIcon("images/load.gif");
        this.menu[2] = this.createImageIcon("images/save.gif");
        this.menu[3] = this.createImageIcon("images/change.gif");
        this.menu[4] = this.createImageIcon("images/pass.gif");
        this.menu[5] = this.createImageIcon("images/exit.gif");
        this.menu[6] = this.createImageIcon("images/clear.gif");
        this.menu[7] = this.createImageIcon("images/new16.gif");
        this.menu[8] = this.createImageIcon("images/load16.gif");
        this.menu[9] = this.createImageIcon("images/save16.gif");
        this.menu[10] = this.createImageIcon("images/change16.gif");
        this.menu[11] = this.createImageIcon("images/pass16.gif");
        this.menu[12] = this.createImageIcon("images/exit16.gif");
        this.menu[13] = this.createImageIcon("images/clear16.gif");
        this.menu[14] = this.createImageIcon("images/draw16.gif");
        this.menu[15] = this.createImageIcon("images/about16.gif");
        this.menu[16] = this.createImageIcon("images/xedit.png");
        this.menu[17] = this.createImageIcon("images/h.gif");
        this.menu[18] = this.createImageIcon("images/a.gif");
        this.menu[19] = this.createImageIcon("images/wizard.gif");
        this.menu[20] = this.createImageIcon("images/help.gif");
        this.setIconImage(this.menu[15].getImage());
        JPanel principale = new JPanel();
        principale.setLayout(new BorderLayout());
        principale.setPreferredSize(new Dimension(550, 580));
        JMenuBar menuBar = this.createMenuBar();
        principale.add((Component)menuBar, "North");
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new BorderLayout());
        panelLeft.setMinimumSize(new Dimension(220, 500));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(2, 1));
        panel2.setBorder(new TitledBorder(new EtchedBorder(), "Graph Properties:", 4, 0, null, Color.BLACK));
        panelLeft.add((Component)panel2, "North");
        this.labeled = new JCheckBox("Labeled");
        this.labeled.setSelected(true);
        this.labeled.addActionListener(this);
        this.labeled.setToolTipText("If not checked, all nodes and edges are supposed unlabeled.");
        panel2.add(this.labeled);
        this.directed = new JCheckBox("Directed");
        this.directed.setSelected(true);
        this.directed.addActionListener(this);
        this.directed.setToolTipText("If not checked, all edges are supposed undirected.");
        panel2.add(this.directed);
        JPanel panel3 = new JPanel();
        GridLayout g = new GridLayout(3, 1);
        g.setVgap(5);
        panel3.setLayout(g);
        panel3.setBorder(new TitledBorder(new EtchedBorder(), "Options:", 4, 0, null, Color.BLACK));
        JButton choose = new JButton("Acquire Data");
        choose.addActionListener(this);
        choose.setToolTipText("<html>Press this button to update queries and<br>networks loaded in the cytoscape main window.</html>");
        panel3.add(choose);
        JButton go = new JButton("Go");
        go.addActionListener(this);
        go.setToolTipText("Start matching.");
        panel3.add(go);
        panelLeft.add((Component)panel3, "South");
        JButton reset = new JButton("Reset");
        reset.addActionListener(this);
        reset.setToolTipText("Reset queries and networks.");
        panel3.add(reset);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridLayout(2, 1));
        panelLeft.add((Component)panel4, "Center");
        JPanel panel4q = new JPanel(new GridLayout(6, 1));
        panel4q.setBorder(new TitledBorder(new EtchedBorder(), "Query Properties:", 4, 0, null, Color.BLACK));
        JPanel pp = new JPanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.gridx = 0;
        cc.gridy = 0;
        cc.weighty = 100.0;
        cc.weightx = 30.0;
        cc.fill = 0;
        cc.anchor = 17;
        JLabel lab = new JLabel("Query:", 2);
        pp.add((Component)lab, cc);
        JButton drawQuery = new JButton("Draw a query...");
        drawQuery.addActionListener(this);
        drawQuery.setToolTipText("Open query editor to draw a query.");
        cc.anchor = 13;
        cc.gridy = 0;
        cc.gridx = 1;
        cc.weighty = 100.0;
        cc.weightx = 70.0;
        pp.add((Component)drawQuery, cc);
        panel4q.add(pp);
        this.query = new JComboBox();
        this.query.setEditable(false);
        this.query.setEnabled(false);
        this.query.setBorder(new EtchedBorder());
        this.query.addActionListener(this);
        this.query.setToolTipText("Select a query.");
        panel4q.add(this.query);
        JLabel lab3 = new JLabel("Query Node Attributes:");
        panel4q.add(lab3);
        this.qna = new JComboBox();
        this.qna.setMinimumSize(new Dimension(30, 100));
        this.qna.setMaximumSize(new Dimension(50, 700));
        this.qna.setEnabled(false);
        this.qna.setToolTipText("<html>Select query node attributes.<br> If \"Use node ID's as Attributes\" is selected,<br> nodes's names are the default attributes.</html>");
        panel4q.add(this.qna);
        JLabel lab4 = new JLabel("Query Edge Attributes:");
        panel4q.add(lab4);
        this.qea = new JComboBox();
        this.qea.setMinimumSize(new Dimension(30, 100));
        this.qea.setMaximumSize(new Dimension(50, 700));
        this.qea.setEnabled(false);
        this.qea.setToolTipText("Select query edge attributes.");
        panel4q.add(this.qea);
        panel4.add(panel4q);
        JPanel panel4t = new JPanel(new GridLayout(6, 1));
        panel4t.setBorder(new TitledBorder(new EtchedBorder(), "Network Properties:", 4, 0, null, Color.BLACK));
        panel4t.setMinimumSize(new Dimension(180, 250));
        JLabel lab2 = new JLabel("Network:");
        panel4t.add(lab2);
        this.target = new JComboBox();
        this.target.setEditable(false);
        this.target.setEnabled(false);
        this.target.setBorder(new EtchedBorder());
        this.target.addActionListener(this);
        this.target.setToolTipText("Select a network.");
        panel4t.add(this.target);
        JLabel lab6 = new JLabel("Network Node Attributes:");
        panel4t.add(lab6);
        this.tna = new JComboBox();
        this.tna.setMinimumSize(new Dimension(30, 100));
        this.tna.setMaximumSize(new Dimension(50, 700));
        this.tna.setEnabled(false);
        this.tna.addActionListener(this);
        this.tna.setToolTipText("<html>Select network node attributes.<br> If \"Use node ID's as Attributes\" is selected,<br> nodes's names are the default attributes.</html>");
        panel4t.add(this.tna);
        JLabel lab66 = new JLabel("Network Edge Attributes:");
        panel4t.add(lab66);
        this.tea = new JComboBox();
        this.tea.setMinimumSize(new Dimension(30, 100));
        this.tea.setMaximumSize(new Dimension(50, 700));
        this.tea.setEnabled(false);
        this.tea.addActionListener(this);
        this.tea.setToolTipText("Select network edge attributes.");
        panel4t.add(this.tea);
        panel4.add(panel4t);
        JPanel panelRightUP = new JPanel();
        panelRightUP.setLayout(new BorderLayout());
        panelRightUP.setMinimumSize(new Dimension(180, 136));
        this.result = new netMatchResultsDialog();
        panelRightUP.add((Component)this.result, "Center");
        JPanel panelRightDOWN = new JPanel();
        panelRightDOWN.setLayout(new BorderLayout());
        JPanel panelRight = new JPanel();
        panelRight.setLayout(new BorderLayout());
        JSplitPane splitPane2 = new JSplitPane(0, panelRightUP, panelRightDOWN);
        splitPane2.setOneTouchExpandable(true);
        splitPane2.setContinuousLayout(true);
        splitPane2.setDividerLocation(350);
        panelRight.add((Component)splitPane2, "Center");
        this.log = new JTextArea();
        this.log.setEditable(false);
        this.log.setBackground(Color.WHITE);
        this.log.setBorder(new TitledBorder(new EtchedBorder(), "Log:", 4, 0, null, Color.BLACK));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.log);
        panelRightDOWN.add((Component)scroller, "Center");
        JSplitPane splitPane = new JSplitPane(1, panelLeft, panelRight);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.setDividerLocation(220);
        principale.add((Component)splitPane, "Center");
        this.getContentPane().add((Component)principale, "Center");
        this.queries = new HashMap();
        this.isEditorOpen = false;
        this.isQueryApproximate = false;
        this.qpaths = new Vector();
        this.listOfNodeAttributes = null;
        this.listOfEdgeAttributes = null;
        if (!Cytoscape.getNetworkSet().isEmpty()) {
            this.acquireData();
        }
        this.wizardForm = new WizardForm(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.wizardForm.setLocation(screenSize.width / 2 - this.wizardForm.getWidth() / 2, screenSize.height / 2 - this.wizardForm.getHeight() / 2);
        this.wizardForm.setResizable(false);
        this.wizardForm.setVisible(false);
        this.wizardForm.setDefaultCloseOperation(0);
    }

    private ImageIcon createImageIcon(String filename) {
        return new ImageIcon(this.getClass().getResource(filename));
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Window window = e.getWindow();
        if (window.equals(this)) {
            if (this.isEditorOpen) {
                this.qEditor.exit();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isEditoOpen() {
        return this.isEditorOpen;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void setDataFromWizard(String t, String q, String tnas, String teas, String qnas, String qeas, boolean lab, boolean dir) {
        ArrayList<String> nodeTemp = null;
        ArrayList<String> edgeTemp = null;
        if (tnas.equals("List of Attributes (select to change)...") && this.listOfNodeAttributes != null) {
            nodeTemp = new ArrayList(this.listOfNodeAttributes);
        } else {
            nodeTemp = new ArrayList<String>();
            nodeTemp.add(tnas);
        }
        if (teas.equals("List of Attributes (select to change)...") && this.listOfEdgeAttributes != null) {
            edgeTemp = new ArrayList(this.listOfEdgeAttributes);
        } else {
            edgeTemp = new ArrayList<String>();
            edgeTemp.add(teas);
        }
        this.acquireData();
        this.setAttrList(nodeTemp, true);
        this.setAttrList(edgeTemp, false);
        Common.LABELED = lab;
        Common.DIRECTED = dir;
        this.labeled.setSelected(lab);
        this.directed.setSelected(dir);
        this.target.setSelectedItem(t);
        this.tna.removeActionListener(this);
        this.tea.removeActionListener(this);
        this.tna.setSelectedItem(tnas);
        this.tea.setSelectedItem(teas);
        this.tna.addActionListener(this);
        this.tea.addActionListener(this);
        this.query.setSelectedItem(q);
        this.qna.setSelectedItem(qnas);
        this.qea.setSelectedItem(qeas);
    }

    public void actionPerformed(ActionEvent e) {
        block48: {
            Set s;
            Object o;
            String command;
            block52: {
                block51: {
                    block50: {
                        block49: {
                            block47: {
                                multipleAttrChoice m;
                                command = e.getActionCommand();
                                o = e.getSource();
                                if (o == this.tna) {
                                    if (((JComboBox)o).getSelectedItem().toString().equals("Select a List of Attributes...") || ((JComboBox)o).getSelectedItem().toString().equals("List of Attributes (select to change)...")) {
                                        m = new multipleAttrChoice(this, "Multiple Node Attributes", (JComboBox)o, true);
                                        m.setVisible(true);
                                    } else {
                                        this.listOfNodeAttributes = new ArrayList();
                                        this.listOfNodeAttributes.add(this.tna.getSelectedItem());
                                    }
                                } else if (o == this.tea) {
                                    if (((JComboBox)o).getSelectedItem().toString().equals("Select a List of Attributes...") || ((JComboBox)o).getSelectedItem().toString().equals("List of Attributes (select to change)...")) {
                                        m = new multipleAttrChoice(this, "Multiple Edge Attributes", (JComboBox)o, false);
                                        m.setVisible(true);
                                    } else {
                                        this.listOfEdgeAttributes = new ArrayList();
                                        this.listOfEdgeAttributes.add(this.tea.getSelectedItem());
                                    }
                                }
                                if (!command.equals("Exit")) break block47;
                                this.processEvent(new WindowEvent(this, 201));
                                break block48;
                            }
                            if (!command.equals("About...")) break block49;
                            JAboutDialog aboutbox = new JAboutDialog(this, this.icons[0]);
                            aboutbox.setVisible(true);
                            break block48;
                        }
                        if (!command.equals("Documentation")) break block50;
                        netMatchHelp h = new netMatchHelp("NetMatch Help", this.menu[15]);
                        h.setVisible(true);
                        break block48;
                    }
                    if (!command.equals("Switch to wizard mode")) break block51;
                    s = Cytoscape.getNetworkSet();
                    if (s.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Cytoscape workspace is empty. Please Load at least one Network!", "NetMatch", 1);
                    } else {
                        this.setVisible(false);
                        this.acquireData();
                        this.wizardForm.init();
                        this.wizardForm.acquire();
                        this.wizardForm.setVisible(true);
                    }
                    break block48;
                }
                if (!command.equals("Reset")) break block52;
                this.log.setText("");
                this.query.removeActionListener(this);
                this.target.removeActionListener(this);
                this.tea.removeActionListener(this);
                this.tna.removeActionListener(this);
                this.query.removeAllItems();
                this.query.setEnabled(false);
                this.target.removeAllItems();
                this.target.setEnabled(false);
                this.qea.removeAllItems();
                this.qea.setEnabled(false);
                this.qna.removeAllItems();
                this.qna.setEnabled(false);
                this.tea.removeAllItems();
                this.tea.setEnabled(false);
                this.tna.removeAllItems();
                this.tna.setEnabled(false);
                this.result.clear();
                this.query.addActionListener(this);
                this.target.addActionListener(this);
                this.tea.addActionListener(this);
                this.tna.addActionListener(this);
                this.labeled.setSelected(true);
                this.directed.setSelected(true);
                this.queries.clear();
                this.listOfNodeAttributes = null;
                this.listOfEdgeAttributes = null;
                System.gc();
                s = Cytoscape.getNetworkSet();
                if (s.isEmpty()) break block48;
                this.acquireData();
                break block48;
            }
            if (command.equals("Draw...") || command.equals("Draw a query...")) {
                if (!this.isEditorOpen) {
                    this.qEditor = new QToolFrame("NetMatch Query Editor", this, this.icons, this.structures, this.menu);
                    this.qEditor.setVisible(true);
                    this.qEditor.setResizable(true);
                    this.isEditorOpen = true;
                } else {
                    this.qEditor.toFront();
                }
            } else if (command.equals("Acquire Data")) {
                s = Cytoscape.getNetworkSet();
                if (s.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Cytoscape workspace is empty. Please Load at least one Network!", "NetMatch", 1);
                } else {
                    this.acquireData();
                }
            } else if (command.equals("Go")) {
                if (!this.query.isEnabled() || !this.target.isEnabled()) {
                    JOptionPane.showMessageDialog(this, "Please Select a Network and a Query First!", "NetMatch", 1);
                } else if (!this.areValidAttributes()) {
                    JOptionPane.showMessageDialog(this, "Map Attributes can't be used in NetMatch!", "NetMatch", 0);
                } else {
                    String t = (String)this.target.getSelectedItem();
                    String q = (String)this.query.getSelectedItem();
                    boolean isUsingQE = false;
                    CyNetwork tnetwork = Cytoscape.getNetwork((String)t.substring(0, t.indexOf(45)));
                    String nn = q.substring(0, q.indexOf(45));
                    if (nn.equals("QE")) {
                        isUsingQE = true;
                    }
                    CyNetwork qnetwork = null;
                    if (!isUsingQE) {
                        qnetwork = Cytoscape.getNetwork((String)nn);
                    }
                    if (tnetwork == null || qnetwork == null && !isUsingQE) {
                        JOptionPane.showMessageDialog(this, "Please Select a Network and a Query First!", "NetMatch Error", 0);
                    } else {
                        Common.LABELED = this.labeled.isSelected();
                        Common.DIRECTED = this.directed.isSelected();
                        Boolean isRunning = (Boolean)tnetwork.getClientData("NetMatch_running");
                        if (isRunning != null && isRunning.booleanValue()) {
                            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "NetMatch is already running on this network. Please wait for it to complete.");
                        } else {
                            this.log.setText("Start Matching...\n");
                            this.result.clear();
                            tnetwork.putClientData("NetMatch_running", (Object)Boolean.TRUE);
                            JTaskConfig config = new JTaskConfig();
                            config.displayCancelButton(true);
                            config.displayStatus(true);
                            if (!isUsingQE) {
                                netMatch netmatch = new netMatch((JFrame)this, tnetwork, this.listOfEdgeAttributes, this.listOfNodeAttributes, qnetwork, (String)this.qea.getSelectedItem(), (String)this.qna.getSelectedItem());
                                TaskManager.executeTask((Task)netmatch, (JTaskConfig)config);
                                if (netmatch.isCompletedSuccessfully()) {
                                    ArrayList l2 = netmatch.getArrayDest();
                                    ArrayList l1 = netmatch.getArraySource();
                                    tnetwork.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                                    if (!l2.isEmpty()) {
                                        this.printMatch(l1, qnetwork, l2, tnetwork);
                                        this.result.set(l2, tnetwork, netmatch.getImageList(), false, null);
                                    }
                                    this.log.append("Found " + l2.size() + " matches!\r\n");
                                } else {
                                    tnetwork.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                                    this.log.setText("");
                                }
                            } else {
                                netMatch netmatch = new netMatch((JFrame)this, tnetwork, this.listOfEdgeAttributes, this.listOfNodeAttributes, (GraphLoader)this.queries.get(q.substring(q.indexOf(45) + 1, q.length())), this.isQueryApproximate, this.qpaths);
                                TaskManager.executeTask((Task)netmatch, (JTaskConfig)config);
                                if (netmatch.isCompletedSuccessfully()) {
                                    ArrayList l2 = netmatch.getArrayDest();
                                    ArrayList l1 = netmatch.getArraySource();
                                    tnetwork.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                                    if (!l2.isEmpty()) {
                                        this.printMatch(l1, l2, tnetwork);
                                        this.result.set(l2, tnetwork, netmatch.getImageList(), this.isQueryApproximate, netmatch.getApproximatePaths());
                                    } else {
                                        this.log.append("Found 0 matches!\r\n");
                                    }
                                } else {
                                    tnetwork.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                                    this.log.setText("");
                                }
                            }
                        }
                    }
                }
            } else if (o == this.query) {
                Object oldQea = this.qea.getSelectedItem();
                Object oldQna = this.qna.getSelectedItem();
                this.qea.removeAllItems();
                this.qna.removeAllItems();
                String qu = (String)this.query.getSelectedItem();
                String nn = qu.substring(0, qu.indexOf(45));
                if (nn.equals("QE")) {
                    this.qea.setEnabled(true);
                    this.qna.setEnabled(true);
                    this.qna.addItem(qu + " - Nodes Attributes");
                    this.qea.addItem(qu + " - Edges Attributes");
                } else {
                    Object o1;
                    int i;
                    CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
                    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
                    String[] attrs = edgesAttributes.getAttributeNames();
                    for (i = 0; i < attrs.length; ++i) {
                        if (edgesAttributes.getType(attrs[i]) == -2 || edgesAttributes.getType(attrs[i]) == -3) continue;
                        this.qea.addItem(attrs[i]);
                    }
                    attrs = nodesAttributes.getAttributeNames();
                    for (i = 0; i < attrs.length; ++i) {
                        if (nodesAttributes.getType(attrs[i]) == -2 || nodesAttributes.getType(attrs[i]) == -3) continue;
                        this.qna.addItem(attrs[i]);
                    }
                    this.qna.addItem("Use node ID's as Attributes");
                    if (oldQea != null) {
                        for (i = 0; i < this.qea.getItemCount(); ++i) {
                            o1 = this.qea.getItemAt(i);
                            if (!o1.equals(oldQea)) continue;
                            this.qea.setSelectedItem(oldQea);
                            break;
                        }
                    }
                    if (oldQna != null) {
                        for (i = 0; i < this.qna.getItemCount(); ++i) {
                            o1 = this.qna.getItemAt(i);
                            if (!o1.equals(oldQna)) continue;
                            this.qna.setSelectedItem(oldQna);
                            break;
                        }
                    }
                }
            }
        }
    }

    private boolean areValidAttributes() {
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        if (nodesAttributes.getType((String)this.qna.getSelectedItem()) == -3 || nodesAttributes.getType((String)this.tna.getSelectedItem()) == -3) {
            return false;
        }
        return edgesAttributes.getType((String)this.qea.getSelectedItem()) != -3 && edgesAttributes.getType((String)this.tea.getSelectedItem()) != -3;
    }

    private void acquireData() {
        Object o;
        int i;
        Object o2;
        this.query.removeActionListener(this);
        this.target.removeActionListener(this);
        this.tea.removeActionListener(this);
        this.tna.removeActionListener(this);
        Object oldQuery = this.query.getSelectedItem();
        Object oldTarget = this.target.getSelectedItem();
        Object oldQea = this.qea.getSelectedItem();
        Object oldQna = this.qna.getSelectedItem();
        Object oldTea = this.tea.getSelectedItem();
        Object oldTna = this.tna.getSelectedItem();
        this.query.removeAllItems();
        this.target.removeAllItems();
        this.qea.removeAllItems();
        this.qna.removeAllItems();
        this.tea.removeAllItems();
        this.tna.removeAllItems();
        Set s = Cytoscape.getNetworkSet();
        Iterator<Object> it = s.iterator();
        while (it.hasNext()) {
            CyNetwork n = (CyNetwork)it.next();
            this.query.addItem(n.getIdentifier() + "-" + n.getTitle());
            this.target.addItem(n.getIdentifier() + "-" + n.getTitle());
        }
        this.query.setEnabled(true);
        this.target.setEnabled(true);
        it = this.queries.keySet().iterator();
        while (it.hasNext()) {
            String o3 = "QE-" + it.next();
            this.query.addItem(o3);
            this.qea.addItem(o3 + " - Edges Attributes");
            this.qna.addItem(o3 + " - Nodes Attributes");
        }
        if (!this.query.isEnabled() && !this.queries.isEmpty()) {
            this.query.setEnabled(true);
        }
        if (oldQuery != null) {
            for (int i2 = 0; i2 < this.query.getItemCount(); ++i2) {
                o2 = this.query.getItemAt(i2);
                if (!o2.equals(oldQuery)) continue;
                this.query.setSelectedItem(oldQuery);
                break;
            }
        }
        if (oldTarget != null) {
            for (int i3 = 0; i3 < this.target.getItemCount(); ++i3) {
                o2 = this.target.getItemAt(i3);
                if (!o2.equals(oldTarget)) continue;
                this.target.setSelectedItem(oldTarget);
                break;
            }
        }
        String qu = (String)this.query.getSelectedItem();
        String nn = qu.substring(0, qu.indexOf(45));
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        String[] attrs = edgesAttributes.getAttributeNames();
        if (!nn.equals("QE")) {
            for (i = 0; i < attrs.length; ++i) {
                if (edgesAttributes.getType(attrs[i]) == -2 || edgesAttributes.getType(attrs[i]) == -3) continue;
                this.qea.addItem(attrs[i]);
            }
            attrs = nodesAttributes.getAttributeNames();
            this.qea.setEnabled(true);
            for (i = 0; i < attrs.length; ++i) {
                if (nodesAttributes.getType(attrs[i]) == -2 || nodesAttributes.getType(attrs[i]) == -3) continue;
                this.qna.addItem(attrs[i]);
            }
            this.qna.setEnabled(true);
        }
        attrs = edgesAttributes.getAttributeNames();
        for (i = 0; i < attrs.length; ++i) {
            this.tea.addItem(attrs[i]);
        }
        this.tea.addItem("Select a List of Attributes...");
        this.tea.setEnabled(true);
        attrs = nodesAttributes.getAttributeNames();
        for (i = 0; i < attrs.length; ++i) {
            this.tna.addItem(attrs[i]);
        }
        this.tna.setEnabled(true);
        if (this.query.getItemCount() > 0 && !nn.equals("QE")) {
            this.qna.addItem("Use node ID's as Attributes");
        }
        if (this.target.getItemCount() > 0) {
            this.tna.addItem("Use node ID's as Attributes");
            this.tna.addItem("Select a List of Attributes...");
        }
        if (oldQea != null) {
            for (i = 0; i < this.qea.getItemCount(); ++i) {
                o = this.qea.getItemAt(i);
                if (!o.equals(oldQea)) continue;
                this.qea.setSelectedItem(oldQea);
                break;
            }
        }
        if (oldQna != null) {
            for (i = 0; i < this.qna.getItemCount(); ++i) {
                o = this.qna.getItemAt(i);
                if (!o.equals(oldQna)) continue;
                this.qna.setSelectedItem(oldQna);
                break;
            }
        }
        if (oldTea != null) {
            for (i = 0; i < this.tea.getItemCount(); ++i) {
                o = this.tea.getItemAt(i);
                if (!o.equals(oldTea)) continue;
                this.tea.setSelectedItem(oldTea);
                break;
            }
        }
        if (oldTna != null) {
            for (i = 0; i < this.tna.getItemCount(); ++i) {
                o = this.tna.getItemAt(i);
                if (!o.equals(oldTna)) continue;
                this.tna.setSelectedItem(oldTna);
                break;
            }
        }
        this.listOfNodeAttributes = new ArrayList();
        this.listOfNodeAttributes.add(this.tna.getSelectedItem());
        this.listOfEdgeAttributes = new ArrayList();
        this.listOfEdgeAttributes.add(this.tea.getSelectedItem());
        this.query.addActionListener(this);
        this.target.addActionListener(this);
        this.tna.addActionListener(this);
        this.tea.addActionListener(this);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem i = new JMenuItem("Exit", this.menu[12]);
        i.addActionListener(this);
        fileMenu.add(i);
        menuBar.add(fileMenu);
        JMenu queryMenu = new JMenu("Query");
        i = new JMenuItem("Draw...", this.menu[14]);
        i.addActionListener(this);
        queryMenu.add(i);
        menuBar.add(queryMenu);
        JMenu wizard = new JMenu("Wizard");
        i = new JMenuItem("Switch to wizard mode", this.menu[19]);
        i.addActionListener(this);
        wizard.add(i);
        menuBar.add(wizard);
        JMenu help = new JMenu("Help");
        i = new JMenuItem("About...", this.menu[18]);
        i.addActionListener(this);
        help.add(i);
        i = new JMenuItem("Documentation", this.menu[17]);
        i.addActionListener(this);
        help.add(i);
        menuBar.add(help);
        return menuBar;
    }

    private void printMatch(ArrayList s, CyNetwork q, ArrayList d, CyNetwork t) {
        for (int i = 0; i < s.size(); ++i) {
            int[] tmp1 = (int[])s.get(i);
            int[] tmp2 = (int[])d.get(i);
            this.log.append("************************** Match " + (i + 1) + "\n");
            for (int j = 0; j < tmp1.length; ++j) {
                this.log.append(q.getNode(tmp1[j]).getIdentifier() + " matches " + t.getNode(tmp2[j]).getIdentifier() + "\n");
            }
        }
        this.log.append("**************************\n");
    }

    private void printMatch(ArrayList s, ArrayList d, CyNetwork t) {
        for (int i = 0; i < s.size(); ++i) {
            int[] tmp1 = (int[])s.get(i);
            int[] tmp2 = (int[])d.get(i);
            this.log.append("************************** Match " + (i + 1) + "\n");
            for (int j = 0; j < tmp1.length; ++j) {
                this.log.append(tmp1[j] + " matches " + t.getNode(tmp2[j]).getIdentifier() + "\n");
            }
        }
        this.log.append("**************************\n");
    }

    public void addQueryStructure(String name, GraphLoader g) {
        if (!this.queries.containsKey(name)) {
            this.query.addItem("QE-" + name);
            this.query.setSelectedItem("QE-" + name);
            this.query.setEnabled(true);
        }
        this.queries.put(name, g);
        if (this.wizardForm.isVisible()) {
            this.wizardForm.editorDone("QE-" + name);
        }
    }

    public void deattachRecipient() {
        this.isEditorOpen = false;
    }

    public void setQueryApproximate(boolean value) {
        this.isQueryApproximate = value;
    }

    public void addQPath(String path) {
        this.qpaths.add(path);
    }

    public void clearPaths() {
        this.qpaths.removeAllElements();
    }

    public void setAttrList(ArrayList attrs, boolean isNodeAttr) {
        JComboBox c = isNodeAttr ? this.tna : this.tea;
        c.removeActionListener(this);
        if (attrs == null) {
            c.removeItem("Select a List of Attributes...");
            c.removeItem("List of Attributes (select to change)...");
            c.addItem("Select a List of Attributes...");
            c.setSelectedIndex(0);
            if (isNodeAttr) {
                this.listOfNodeAttributes = null;
            } else {
                this.listOfEdgeAttributes = null;
            }
        } else {
            c.removeItem("Select a List of Attributes...");
            c.removeItem("List of Attributes (select to change)...");
            c.addItem("List of Attributes (select to change)...");
            c.setSelectedItem("List of Attributes (select to change)...");
            if (isNodeAttr) {
                this.listOfNodeAttributes = attrs;
            } else {
                this.listOfEdgeAttributes = attrs;
            }
        }
        c.addActionListener(this);
    }

    public void printArrayList(ArrayList l) {
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            System.out.print(o + " ");
        }
        System.out.println();
    }
}

